package gdxapp.shaders;

import java.io.Serializable;
import java.util.UUID;

import com.badlogic.gdx.math.Vector3;

import dressing.ui.engine3d.SceneTexture;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="material")
public class MaterialDto implements Serializable{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String name;
	UUID uuid;
	private Vector3 albedo;
	float metalness, roughness, opacity, ambiantOcclusion;
	String albedoMap, normalMap, metalnessMap, roughnessMap, aoMap;
	private SceneTexture textureDiffuse;
	
	
	public MaterialDto() {}
	
	public MaterialDto(PbrMaterial material) {
		name = material.getName();
		albedo = material.getAlbedo();
		metalness = material.getMetalness();
		roughness = material.getRoughness();
		opacity = material.getOpacity();
		ambiantOcclusion = material.getAmbiantOcclusion();
		if(material.getAlbedoMapPath() != null)
			albedoMap = material.getAlbedoMapPath();
		if(material.getNormalMapPath() != null)
			normalMap = material.getNormalMapPath();
		if(material.getMetalnessMapPath() != null)
			metalnessMap = material.getMetalnessMapPath();
		if(material.getRoughnessMapPath() != null)
			roughnessMap = material.getRoughnessMapPath();
		if(material.getAoMapPath() != null)
			aoMap = material.getAoMapPath();
	}


	public PbrMaterial getMaterial() {
		PbrMaterial material = new PbrMaterial();
		material.setName(name);
		material.setAlbedo(this.albedo);
		material.setMetalness(metalness);
		material.setRoughness(roughness);
		material.setAmbiantOcclusion(ambiantOcclusion);
		material.setOpacity(opacity);
		material.setAlbedoMapPath(albedoMap);
		material.setNormalMapPath(normalMap);
		material.setMetalnessMapPath(metalnessMap);
		material.setRoughnessMapPath(roughnessMap);
		material.setAoMapPath(aoMap);
		return material;
	}
	
	
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public UUID getId() {
		return uuid;
	}
	public void setId(UUID id) {
		this.uuid = id;
	}
	
	

	public Vector3 getAlbedo() {
		return albedo;
	}

	public void setAlbedo(Vector3 albedo) {
		this.albedo = albedo;
	}

	public float getMetalness() {
		return metalness;
	}

	public void setMetalness(float metalness) {
		this.metalness = metalness;
	}

	public float getRoughness() {
		return roughness;
	}

	public void setRoughness(float roughness) {
		this.roughness = roughness;
	}

	public float getAmbiantOcclusion() {
		return ambiantOcclusion;
	}

	public void setAmbiantOcclusion(float ambiantOcclusion) {
		this.ambiantOcclusion = ambiantOcclusion;
	}

	public String getAlbedoMap() {
		return albedoMap;
	}

	public void setAlbedoMap(String albedoMap) {
		this.albedoMap = albedoMap;
	}

	public String getNormalMap() {
		return normalMap;
	}

	public void setNormalMap(String normalMap) {
		this.normalMap = normalMap;
	}

	public String getMetalnessMap() {
		return metalnessMap;
	}

	public void setMetalnessMap(String metalnessMap) {
		this.metalnessMap = metalnessMap;
	}

	public String getRoughnessMap() {
		return roughnessMap;
	}

	public void setRoughnessMap(String roughnessMap) {
		this.roughnessMap = roughnessMap;
	}

	public String getAoMap() {
		return aoMap;
	}

	public void setAoMap(String aoMap) {
		this.aoMap = aoMap;
	}

	public SceneTexture getTextureDiffuse() {
		return textureDiffuse;
	}

	public void setTextureDiffuse(SceneTexture textureDiffuse) {
		this.textureDiffuse = textureDiffuse;
	}

	public float getOpacity() {
		return opacity;
	}
	public void setOpacity(float opacity) {
		this.opacity = opacity;
	}
	
	public MaterialDto clone() {
		MaterialDto clone = new MaterialDto();
		clone.setName(getName());
		clone.setAlbedo(getAlbedo());
		clone.setTextureDiffuse(getTextureDiffuse().clone());
		clone.setAlbedoMap(getAlbedoMap());
		clone.setRoughness(getRoughness());
		clone.setRoughnessMap(getRoughnessMap());
		clone.setMetalness(getMetalness());
		clone.setMetalnessMap(getMetalnessMap());
		clone.setAmbiantOcclusion(getAmbiantOcclusion());
		clone.setAoMap(getAoMap());
		clone.setNormalMap(getNormalMap());
		clone.setId(UUID.randomUUID());
		return clone;
	}
	
	public static void main(String[] args) {
		

		
	}

}
