package dressing.ui.project;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.joml.Math;

import dressing.model.ModelProvider;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import dressing.ui.util.SingleImageItemLabelProvider;
import gdxapp.scenes.ScenePreferences;
import gdxapp.shaders.PbrMaterial;

public class SceneCeilingSettingComposite extends Composite {
	
	//model attrs
	private ScenePreferences preferences;
	private PbrMaterial material;
	private float thickness;

	
	//ui attrs
	private Spinner SPepaisseur;
	private TableComboViewer tcvMaterial;
	private Button btnPreview;
	
	PropertyChangeSupport pcs;

	public SceneCeilingSettingComposite(Composite parent, ScenePreferences preferences) {
		super(parent, SWT.NONE);
		this.preferences = preferences;
		this.pcs = new PropertyChangeSupport(this);
		createControl();
		bind();
	}

	private void createControl() {
		List<PbrMaterial> materials = ModelProvider.getMaterialsByCategory(CATEGORY.CEILING);
		SingleImageItemLabelProvider labelProvider = SingleImageItemLabelProvider.getInstance();
		
		setLayout(new GridLayout(1, false));
		

		Composite composite = new Composite(this, SWT.NONE);
		composite.setLayout(new GridLayout(1, false));
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));


		Composite marbleContainer = new Composite(composite, SWT.NONE);
		marbleContainer.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		marbleContainer.setLayout(new GridLayout(2, false));


		Label lblMotif = new Label(marbleContainer, SWT.NONE);
		lblMotif.setText("Motif: ");

		tcvMaterial = new TableComboViewer(marbleContainer, SWT.NONE);
		TableCombo tcMaterial = tcvMaterial.getTableCombo();
		tcMaterial.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		tcvMaterial.setContentProvider(ArrayContentProvider.getInstance());
		tcvMaterial.setLabelProvider(labelProvider);
		tcvMaterial.setInput(materials);
		tcvMaterial.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				materialChanged();
			}
		});
	
		
		Label lblEpaisseur = new Label(marbleContainer, SWT.NONE);
		lblEpaisseur.setText("Épaisseur: ");

		SPepaisseur = new Spinner(marbleContainer, SWT.BORDER);
		SPepaisseur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		SPepaisseur.setMaximum(1000);
		SPepaisseur.setMinimum(100);

		
		btnPreview = new Button(marbleContainer, SWT.NONE);
		btnPreview.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		new Label(marbleContainer, SWT.NONE);
		new Label(marbleContainer, SWT.NONE);
		SPepaisseur.addModifyListener(new ModifyListener() {

			@Override
			public void modifyText(ModifyEvent e) {
				thickness = SPepaisseur.getSelection() / 1000f;
				pcs.firePropertyChange("plinth setting changed", null, null);
			}
		});		
	}
	
	private void bind() {
		try {
			material = ModelProvider.findMaterial(CATEGORY.CEILING ,this.preferences.getCeilingMaterial().getName());
		}catch (NullPointerException e) {
			System.err.println("unkown material");
		}
		if(material != null) {
			tcvMaterial.setSelection(new StructuredSelection(material));
		}
		float thickness = this.preferences.getMarbleThickness();
		this.SPepaisseur.setSelection(Math.round(thickness  * 1000));
	}
	
	protected void materialChanged() {
		material = (PbrMaterial) tcvMaterial.getStructuredSelection().getFirstElement();
		if (material != null) {
			if (btnPreview != null)
				btnPreview.setImage(ModelProvider.getTexture(material.getAlbedoMapPath()).getPreview());
			 pcs.firePropertyChange("ceiling setting changed", null, null);

		}		
	}
	
	public boolean hasValidInput() {
		return material != null && thickness >= 0.1f;
	}
	
	public void apply() {
		this.preferences.setCeilingMaterial(material);
		this.preferences.setCeilingThickness(thickness);
	}
	
	public void addPropertyChangeListener(PropertyChangeListener lsitener) {
		pcs.addPropertyChangeListener(lsitener);
	}
	
	public void clearListeners() {
		for(var listner: pcs.getPropertyChangeListeners())
			pcs.removePropertyChangeListener(listner);
	}

}
