package dressing.ui;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;

import param.AccessoireInstance;
import param.AccessoireInstanceGroup;
import param.ArticleInstance;
import param.BaseObject;
import param.ParamFactory;
import param.QuincaillerieInstance;
import param.QuincaillerieInstanceGroup;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Table;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.config.ReportingPreferences;
import dressing.ui.editorWindows.ArticleInstanceEditorWindow;
import dressing.ui.util.EditorWindow;

import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.window.Window;

public class MecahnicDesignAccesoireComposite extends Composite {
	private Table table;
	private QuincaillerieInstanceGroup quincailleries;
	private	AccessoireInstanceGroup accessoires;
	private TableViewer tableViewer;
	private boolean isShowAccessoire = ReportingPreferences.getInstance().getProperty("report.accessoire", true);
	private boolean isShowQuicaillerie = ReportingPreferences.getInstance().getProperty("report.quicaillerie", true);
	private boolean designArticlesChanged=false;
	/**
	 * Create the composite.
	 * @param parent
	 * @param design 
	 * @param style
	 */
	public MecahnicDesignAccesoireComposite(Composite parent, QuincaillerieInstanceGroup quincailleries,AccessoireInstanceGroup accessoires,int style) {
		super(parent, style);
		this.quincailleries = quincailleries;
		this.accessoires = accessoires;
		setLayout(new GridLayout(2, false));
		
		tableViewer = new TableViewer(this, SWT.BORDER | SWT.FULL_SELECTION);
		table = tableViewer.getTable();
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		TableViewerColumn tableViewerColumnName = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerColumnName.setLabelProvider(new DesignArticleInstanceNameLabelProvider());
		TableColumn tblclmnNom = tableViewerColumnName.getColumn();
		tblclmnNom.setWidth(150);
		tblclmnNom.setText("Nom");
		
		TableViewerColumn tableViewerColumnArticle = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerColumnArticle.setLabelProvider(new DesignArticleInstanceArticleNameLabelProvider());
		TableColumn tblclmnArticle = tableViewerColumnArticle.getColumn();
		tblclmnArticle.setWidth(120);
		tblclmnArticle.setText("Article");
		
		TableViewerColumn tableViewerColumnNumber = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerColumnNumber.setLabelProvider(new DesignArticleInstanceNumberLabelProvider());
		TableColumn tblclmnNombre = tableViewerColumnNumber.getColumn();
		tblclmnNombre.setWidth(100);
		tblclmnNombre.setText("Nombre");
		
		TableViewerColumn tableViewerColumnPrice = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerColumnPrice.setLabelProvider(new DesignArticleInstancePriceLabelProvider());
		TableColumn tblclmnPrix = tableViewerColumnPrice.getColumn();
		tblclmnPrix.setWidth(100);
		tblclmnPrix.setText("Prix");
		
		Composite composite = new Composite(this, SWT.NONE);
		composite.setLayout(new GridLayout(1, false));
		composite.setLayoutData(new GridData(SWT.RIGHT, SWT.FILL, false, false, 1, 1));
		composite.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		Button btnView = new Button(composite, SWT.NONE);
		btnView.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnView.setText("Voir");
		
		Button btnAddAccessoire = new Button(composite, SWT.NONE);
		btnAddAccessoire.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnAddAccessoire.setText("Ajouter Accessoire");
		
		Button btnAddQuincaillerie = new Button(composite, SWT.NONE);
		btnAddQuincaillerie.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnAddQuincaillerie.setText("Ajouter Quincaillerie");
		
		Button btnModifier = new Button(composite, SWT.NONE);
		btnModifier.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnModifier.setText("Modifier");
		
		Button btnSupprimer = new Button(composite, SWT.NONE);
		btnSupprimer.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnSupprimer.setText("Supprimer");

        this.addControlListener(new ControlAdapter() {
            public void controlResized(ControlEvent e) {
                TableColumn[] columns = table.getColumns();
//                table.setSize(table.computeSize(SWT.DEFAULT, SWT.DEFAULT));
                int tableWidth= MecahnicDesignAccesoireComposite.this.getSize().x-composite.getSize().x;
                int oldSize = table.getSize().x;
                int width =tableWidth-table.getVerticalBar().getSize().x- table.getBorderWidth()*2;;
            	if (oldSize > tableWidth) {
					// table is getting smaller so make the columns
					// smaller first and then resize the table to
					// match the client area width
					int columnWidth = (width) / columns.length;
					for(TableColumn column:table.getColumns()) {
						column.setWidth(columnWidth);
					}
					

					table.setSize(tableWidth, MecahnicDesignAccesoireComposite.this.getSize().y-MecahnicDesignAccesoireComposite.this.getBorderWidth()*2);

				} else {
					// table is getting bigger so make the table
					// bigger first and then make the columns wider
					// to match the client area width
					int columnWidth = (width) /  columns.length;
					table.setSize(tableWidth, MecahnicDesignAccesoireComposite.this.getSize().y-MecahnicDesignAccesoireComposite.this.getBorderWidth()*2);

					for(TableColumn column:columns) {
						column.setWidth(columnWidth);
					}

				}
            }
        });
        tableViewer.setContentProvider(new ListAccessoireContentProvider());
        setTableViewerInput();
        btnAddAccessoire.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				AccessoireInstance accessoire = ParamFactory.eINSTANCE.createAccessoireInstance();
				ArticleInstanceEditorWindow window = new ArticleInstanceEditorWindow(getShell(), EditorWindow.create,accessoire);
				int returnCode = window.open();
				if (returnCode == Window.OK) {
					MecahnicDesignAccesoireComposite.this.accessoires.getAccessoires().add(accessoire);
					setTableViewerInput();
					tableViewer.refresh();
					designArticlesChanged=true;
				}
			}
		});
        btnAddQuincaillerie.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				QuincaillerieInstance quincaillerie = ParamFactory.eINSTANCE.createQuincaillerieInstance();
				ArticleInstanceEditorWindow window = new ArticleInstanceEditorWindow(getShell(), EditorWindow.create,quincaillerie);
				int returnCode = window.open();
				if (returnCode == Window.OK) {
					MecahnicDesignAccesoireComposite.this.quincailleries.getQuincailleries().add(quincaillerie);
					setTableViewerInput();
					tableViewer.refresh();
					designArticlesChanged=true;
				}
			}
		});
        btnModifier.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				
				ArticleInstance accessoire = (ArticleInstance) tableViewer.getStructuredSelection().getFirstElement();
				if(accessoire!=null) {
					ArticleInstanceEditorWindow window = new ArticleInstanceEditorWindow(getShell(), EditorWindow.update,
							accessoire);
					int returnCode = window.open();
					if (returnCode == Window.OK) {
						setTableViewerInput();
						tableViewer.refresh();
						designArticlesChanged=true;
					}
				}
				
			}
		});
        btnView.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				
				ArticleInstance accessoire = (ArticleInstance) tableViewer.getStructuredSelection().getFirstElement();
				if(accessoire!=null) {
					ArticleInstanceEditorWindow window = new ArticleInstanceEditorWindow(getShell(), EditorWindow.View,accessoire);
					int returnCode = window.open();
				}
				
			}
		});
        btnSupprimer.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				
				ArticleInstance article = (ArticleInstance) tableViewer.getStructuredSelection().getFirstElement();
				if(article!=null) {
					boolean confirm=MessageDialog.openConfirm(getShell(), "Supprimer Article!", "voulez vous suupprimer l'article "+article.getName()+"?!");
					if (confirm) {
						if(article instanceof AccessoireInstance) {
							MecahnicDesignAccesoireComposite.this.accessoires.getAccessoires().remove(article);
						}else {
							MecahnicDesignAccesoireComposite.this.quincailleries.getQuincailleries().remove(article);

						}
						setTableViewerInput();
						tableViewer.refresh();
						designArticlesChanged=true;
					}
				}
				
			}
		});

        btnAddAccessoire.setVisible(isShowAccessoire);
		btnAddQuincaillerie.setVisible(isShowQuicaillerie);

	}
	private void setTableViewerInput() {
		List<BaseObject> articles = new ArrayList<BaseObject>();
		if (isShowAccessoire) {
			articles.addAll(this.accessoires.getAccessoires());
		}
		if (isShowQuicaillerie) {
			articles.addAll(this.quincailleries.getQuincailleries());
		}

		tableViewer.setInput(articles);
	}
	
	public boolean isDesignArticlesChanged() {
		return designArticlesChanged;
	}

	class DesignArticleInstancePriceLabelProvider extends ColumnLabelProvider {
		public Image getImage(Object element) {
			// TODO Auto-generated method stub
			return null;
		}
		public String getText(Object element) {
			if(element instanceof AccessoireInstance) {
				AccessoireInstance art=(AccessoireInstance)element;
				return art.getAccessoire()!=null?( String.format("%,.3f TND", ( art.getAccessoire().getPrix()*art.getNombreFix() ) ) ):"0.0";
			}
			if(element instanceof QuincaillerieInstance) {
				QuincaillerieInstance art=(QuincaillerieInstance)element;

				return art.getQuincaillerie()!=null?( String.format("%,.3f TND", ( art.getQuincaillerie().getPrix()*art.getNombreFix() ) ) ):"0.0";
			}
			return element == null ? "" : element.toString();
		}
		@Override
		public Color getBackground(Object element) {
			if(element instanceof AccessoireInstance) {
				return JFaceResources.getResources().createColor(new RGB(250, 100, 150));
			}
			if(element instanceof QuincaillerieInstance) {
				return JFaceResources.getResources().createColor(new RGB(150, 250, 100));
			}
			return super.getBackground(element);
		}
	}
	class DesignArticleInstanceNumberLabelProvider extends ColumnLabelProvider {
		public Image getImage(Object element) {
			// TODO Auto-generated method stub
			return null;
		}
		public String getText(Object element) {
			if(element instanceof AccessoireInstance) {
				AccessoireInstance art=(AccessoireInstance)element;
				return String.valueOf( art.getNombreFix());
			}
			if(element instanceof QuincaillerieInstance) {
				QuincaillerieInstance art=(QuincaillerieInstance)element;

				return art.getNombreFix()+"";
			}
			return element == null ? "" : element.toString();
		}
		@Override
		public Color getBackground(Object element) {
			if(element instanceof AccessoireInstance) {
				return JFaceResources.getResources().createColor(new RGB(250, 100, 150));
			}
			if(element instanceof AccessoireInstance) {
				return JFaceResources.getResources().createColor(new RGB(150, 250, 100));
			}
			return super.getBackground(element);
		}
	}
	class DesignArticleInstanceNameLabelProvider extends ColumnLabelProvider {
		public Image getImage(Object element) {
			// TODO Auto-generated method stub
			return null;
		}
		public String getText(Object element) {
			if(element instanceof AccessoireInstance) {
				AccessoireInstance art=(AccessoireInstance)element;
				return  art.getName();
			}
			if(element instanceof QuincaillerieInstance) {
				QuincaillerieInstance art=(QuincaillerieInstance)element;

				return art.getName();
			}
			return element == null ? "" : element.toString();
		}
		@Override
		public Color getBackground(Object element) {
			if(element instanceof AccessoireInstance) {
				return JFaceResources.getResources().createColor(new RGB(250, 100, 150));
			}
			if(element instanceof AccessoireInstance) {
				return JFaceResources.getResources().createColor(new RGB(150, 250, 100));
			}
			return super.getBackground(element);
		}
	}
	class DesignArticleInstanceArticleNameLabelProvider extends ColumnLabelProvider {
		public Image getImage(Object element) {
			// TODO Auto-generated method stub
			return null;
		}
		public String getText(Object element) {
			if(element instanceof AccessoireInstance) {
				AccessoireInstance art=(AccessoireInstance)element;
				return   art.getAccessoire()!=null?(  art.getAccessoire().getName()  ):"";
			}
			if(element instanceof QuincaillerieInstance) {
				QuincaillerieInstance art=(QuincaillerieInstance)element;
				return art.getQuincaillerie()!=null?(  art.getQuincaillerie().getName()  ):"";
			}
			return element == null ? "" : element.toString();
		}
		@Override
		public Color getBackground(Object element) {
			if(element instanceof AccessoireInstance) {
				return JFaceResources.getResources().createColor(new RGB(250, 100, 150));
			}
			if(element instanceof AccessoireInstance) {
				return JFaceResources.getResources().createColor(new RGB(150, 250, 100));
			}
			return super.getBackground(element);
		}
	}
	class ListAccessoireContentProvider implements IStructuredContentProvider{

		@Override
		public Object[] getElements(Object inputElement) {
			if(inputElement instanceof List) {
				return ((List) inputElement).toArray();
			}
			return new ArrayList<Object>().toArray();
		}
	}
}
