/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PieceType implements Enumerator
{
    PIECE2D(0, "PIECE2D", "PIECE2D"),
    CAISSON(10, "CAISSON", "CAISSON"),
    SPACE3D(2, "SPACE3D", "SPACE3D"),
    TROU(4, "TROU", "TROU"),
    RAINURE(5, "RAINURE", "RAINURE"),
    ACCESOIRE(7, "ACCESOIRE", "ACCESOIRE"),
    DRESSING(8, "DRESSING", "DRESSING"),
    OBSTACLE(9, "OBSTACLE", "OBSTACLE");

    public static final int PIECE2D_VALUE = 0;
    public static final int CAISSON_VALUE = 10;
    public static final int SPACE3D_VALUE = 2;
    public static final int TROU_VALUE = 4;
    public static final int RAINURE_VALUE = 5;
    public static final int ACCESOIRE_VALUE = 7;
    public static final int DRESSING_VALUE = 8;
    public static final int OBSTACLE_VALUE = 9;
    private static final PieceType[] VALUES_ARRAY;
    public static final List<PieceType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PieceType[]{PIECE2D, CAISSON, SPACE3D, TROU, RAINURE, ACCESOIRE, DRESSING, OBSTACLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PieceType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PieceType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PieceType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PieceType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PieceType get(int value) {
        switch (value) {
            case 0: {
                return PIECE2D;
            }
            case 10: {
                return CAISSON;
            }
            case 2: {
                return SPACE3D;
            }
            case 4: {
                return TROU;
            }
            case 5: {
                return RAINURE;
            }
            case 7: {
                return ACCESOIRE;
            }
            case 8: {
                return DRESSING;
            }
            case 9: {
                return OBSTACLE;
            }
        }
        return null;
    }

    private PieceType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

