package dressing.ui.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import dressing.ui.engine3d.sceneconfig.FloorSettingComposite;
import gdxapp.scenes.ScenePreferences;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.FillLayout;

public class SceneAppearanceSettingComposite extends Composite{

	private ScenePreferences preferences;
	
	//ui attrs
	private SceneMarbleSettingComposite marbleComposite;
	private FloorSettingComposite floorComposite;
	private SceneCeilingSettingComposite ceilingComposite;
	private ScenePlinthSettingComposite  plinthComposite;
	private PropertyChangeSupport pcs;
	
	
	public SceneAppearanceSettingComposite(Composite parent,ScenePreferences preferences) {
		super(parent, SWT.NONE);
		this.preferences = preferences;
		this.pcs = new PropertyChangeSupport(this);
		
		createControl();
	}


	private void createControl() {
		
		setLayout(new GridLayout(2, true));
		
		Group grpMarbre = new Group(this, SWT.NONE);
		grpMarbre.setLayout(new FillLayout(SWT.HORIZONTAL));
		grpMarbre.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		grpMarbre.setText("Marbre");
		
		Group grpPlinth = new Group(this, SWT.NONE);
		grpPlinth.setLayout(new FillLayout(SWT.HORIZONTAL));
		grpPlinth.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		grpPlinth.setText("Socle");
		
		Group grpSol = new Group(this, SWT.NONE);
		grpSol.setLayout(new FillLayout(SWT.HORIZONTAL));
		grpSol.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		grpSol.setText("Sol");
		
		Group grpCeiling = new Group(this, SWT.NONE);
		grpCeiling.setLayout(new FillLayout(SWT.HORIZONTAL));
		grpCeiling.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		grpCeiling.setText("Plafond");
		
		this.marbleComposite = new SceneMarbleSettingComposite(grpMarbre, preferences);
		this.plinthComposite = new ScenePlinthSettingComposite(grpPlinth, preferences);
		this.floorComposite = new FloorSettingComposite(grpSol, preferences);
		this.ceilingComposite = new SceneCeilingSettingComposite(grpCeiling, preferences);
		
		PropertyChangeListener changeListenerDelegate = new PropertyChangeListener() {
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				pcs.firePropertyChange(evt);
			}
		};
		
		this.marbleComposite.addPropertyChangeListener(changeListenerDelegate);
		this.plinthComposite.addPropertyChangeListener(changeListenerDelegate);
		this.floorComposite.addPropertyChangeListener(changeListenerDelegate);
		this.ceilingComposite.addPropertyChangeListener(changeListenerDelegate);
		
	}
	
	
	public boolean hasValidInput() {
		return marbleComposite.hasValidInput() && plinthComposite.hasValidInput() && 
				floorComposite.hasValidInput() && ceilingComposite.hasValidInput();
	}
	
	public void apply() {
		marbleComposite.apply();
		plinthComposite.apply();
		floorComposite.apply();
		ceilingComposite.apply();
	}
	
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		this.pcs.addPropertyChangeListener(listener);
	}
	
	
}
