package dressing.ui.engine3d.sceneconfig;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import dressing.model.ModelProvider;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import dressing.ui.util.SingleImageItemLabelProvider;
import gdxapp.scenes.ScenePreferences;
import gdxapp.shaders.PbrMaterial;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Spinner;

public class FloorSettingComposite extends Composite{

	
	//model attrs
	private ScenePreferences preferences;
	private PbrMaterial floorMtl;
	private float thickness;
	
	//ui attrs
	private TableComboViewer tcvTexture;
	private Button btnPreview;
	private SingleImageItemLabelProvider labelProvider;
	private Spinner spnThickness;
	
	private PropertyChangeSupport pcs;

	
	public FloorSettingComposite(Composite parent, ScenePreferences preferences) {
		super(parent, SWT.NONE);
		this.preferences = preferences;
		this.pcs = new PropertyChangeSupport(this);
		createControl();
		bind();
	}
	
	private void createControl() {
		this.floorMtl = preferences.getFloorMtl();
		setLayout(new GridLayout(1, false));
		
		Composite container = new Composite(this, SWT.NONE);
		GridData gd_container = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_container.heightHint = 343;
		container.setLayoutData(gd_container);
		container.setLayout(new GridLayout(2, false));
				
		labelProvider = SingleImageItemLabelProvider.getInstance();
		
		Label lblTexture = new Label(container, SWT.NONE);
		lblTexture.setText("Motif: ");
		
		tcvTexture = new TableComboViewer(container, SWT.NONE);
		tcvTexture.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				textureChanged();
			}
		});
		TableCombo tcTexture = tcvTexture.getTableCombo();
		tcTexture.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tcvTexture.setContentProvider(ArrayContentProvider.getInstance());
		tcvTexture.setLabelProvider(labelProvider);
		tcvTexture.setInput(ModelProvider.getMaterialsByCategory(CATEGORY.FLOOR));
		
		Label lblEpaisseur = new Label(container, SWT.NONE);
		lblEpaisseur.setText("Epaisseur: ");
		
		spnThickness = new Spinner(container, SWT.BORDER);
		spnThickness.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spnThickness.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				setThickness(spnThickness.getSelection() * 1e-3f);		
			}
		});

		
		btnPreview = new Button(container, SWT.NONE);
		btnPreview.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);

	}
	
	
	private void bind() {
		try {
			var material = preferences.getFloorMtl();
			if(material != null) {
				floorMtl = ModelProvider.findMaterial(CATEGORY.FLOOR, preferences.getFloorMtl().getName());
				tcvTexture.setSelection(new StructuredSelection(floorMtl));
			}
			spnThickness.setSelection( Math.round(preferences.getFloorThickness() * 1000));
		}catch (Exception e) {
			e.printStackTrace();
		}
	}


	protected void textureChanged() {
		floorMtl = (PbrMaterial) tcvTexture.getStructuredSelection().getFirstElement();
		if(floorMtl != null) {
			btnPreview.setImage(ModelProvider.getTexture(floorMtl.getAlbedoMapPath()).getPreview());
			pcs.firePropertyChange("plinth setting changed", null, null);
		}
	}
	
	
	
	
	public float getThickness() {
		return thickness;
	}

	public void setThickness(float thickness) {
		this.thickness = thickness;
		pcs.firePropertyChange("plinth setting changed", null, null);
	}



	public void apply() {
		preferences.setFloorMtl(floorMtl);
		preferences.setFloorThickness(thickness);
	}



	public boolean hasValidInput() {
		return floorMtl != null && thickness > 0.001f;
	}
	
	public void addPropertyChangeListener(PropertyChangeListener lsitener) {
		pcs.addPropertyChangeListener(lsitener);
	}
	
	public void clearListeners() {
		for(var listner: pcs.getPropertyChangeListeners())
			pcs.removePropertyChangeListener(listner);
	}


}
