package dressing.ui.caisson;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;

import dressing.config.persistence.ResourceManagers;
import dressing.model.ModelProvider;
import dressing.model.Piece2D;
import dressing.ui.MaterialListWindow;
import dressing.ui.components.TableComboViewerSearch;
import dressing.ui.engine3d.SceneTexture;
import dressing.ui.util.ListEditorWindow;
import dressing.ui.util.MaterialTypeInstanceComposite;
import dressing.ui.util.SingleImageItemLabelProvider;
import dressing.ui.util.StaticUiObjects;
import dressing.ui.util.TypeDefContentProvider;
import dressing.ui.util.TypeDefElementLabelProvider;
import gdxapp.object3d.DoorHandle;
import param.Material;
import param.MaterialTypeInstance;
import param.MechanicDesignElment;
import param.MechanicPublicParam;
import param.TypeDef;
import param.impl.TypeDefElementImpl;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Group;

public class FacadeConfigComposite extends Composite {
	
	private Piece2D facade;
	private DoorHandle handle;

	//ui attributes
	
	//handle properties
	private FacadeHandleConfigurer handleConfigurer;
	private ComboViewer typeCombo;

	
	private TypeDefElementImpl type;
	private TableComboViewerSearch tableComboVwr_facademat;
	private MaterialTypeInstanceComposite facadeMaterialType;
	private MaterialTypeInstanceComposite vitreMaterialType;
	private Label lblFinitionvitre;
	

	public FacadeConfigComposite(Composite parent, Piece2D piece, DoorHandle doorHandle) {
		super(parent, SWT.NONE);
		this.facade = piece;
		this.handle = doorHandle;
		createControl();
	}

	private void createControl() {
		setLayout(new GridLayout(1, false));
		Composite mainContainer = new Composite(this, SWT.NONE);
		mainContainer.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		mainContainer.setLayout(new GridLayout(3, false));
		
		Label lblType = new Label(mainContainer, SWT.NONE);
		lblType.setText("Type");
		
		typeCombo = new ComboViewer(mainContainer, SWT.READ_ONLY);
		Combo combo_PorteType = typeCombo.getCombo();

		combo_PorteType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		typeCombo.setContentProvider(TypeDefContentProvider.getInstance());
		typeCombo.setLabelProvider(TypeDefElementLabelProvider.getInstance());
		typeCombo.setInput(ModelProvider.getTypeDef("FACADE_TYPE"));
		typeCombo.addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				type = (TypeDefElementImpl) event.getStructuredSelection().getFirstElement();
				boolean isvitre=false;
				if(type!=null ) {
					 isvitre=type.getKey().contentEquals("VITRE");
				}
				vitreMaterialType.setVisible(isvitre);
				lblFinitionvitre.setVisible(isvitre);
				mainContainer.redraw();
			}
		});
		Label lblmat = new Label(mainContainer, SWT.NONE);
		lblmat.setText("Matériaux");
		
		SingleImageItemLabelProvider matLabelProvider = SingleImageItemLabelProvider.getInstance();
		tableComboVwr_facademat = new TableComboViewerSearch(mainContainer, SWT.NONE);
		TableCombo tableCombo = tableComboVwr_facademat.getTableCombo();
		tableCombo.setEditable(true);
		tableCombo.setUpdateSelectionOnEnter(true);
		tableCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableCombo.defineColumns(StaticUiObjects.getMaterialColumns());
		tableComboVwr_facademat.setContentProvider(ArrayContentProvider.getInstance());
		tableComboVwr_facademat.setLabelProvider(matLabelProvider);
		tableComboVwr_facademat.getTableCombo().setShowTableHeader(true);
		tableComboVwr_facademat.setInput(ResourceManagers.getIntance().getMaterials());
		tableComboVwr_facademat.addSelectionChangedListener(new ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selection2 = tableComboVwr_facademat.getStructuredSelection();
				Object se2 = selection2.getFirstElement();
				if (se2 != null && se2 instanceof Material) {
					Material mat = (Material) se2;
					if (mat.isApplyTexture() && mat.getImage() != null && !mat.getImage().isEmpty()) {
						SceneTexture texture = ModelProvider.getMaterialSceneTexture(mat);
						if (texture != null) {
							facadeMaterialType.getTableComboViewerTexture()
									.setSelection(new StructuredSelection(texture), true);
						}

					}
				}
			}
		});
		Button btnList = new Button(mainContainer, SWT.CENTER);
		GridData gd_btnList = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_btnList.widthHint = 30;
		gd_btnList.heightHint = 30;
		btnList.setLayoutData(gd_btnList);
		btnList.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				ListEditorWindow listWindow = new MaterialListWindow(getShell(), null);
				listWindow.create();
				listWindow.setSelect(true);
				int ret = listWindow.open();
				tableComboVwr_facademat.setInput(ResourceManagers.getIntance().getMaterials());
				tableComboVwr_facademat.refresh();
				if (ret == Window.OK) {
					tableComboVwr_facademat.setSelection(new StructuredSelection(listWindow.getSelection()), true);
				}
			}
		});
		btnList.setImage(ResourceManager.getPluginImage("Dressing", "icons/list24.png"));
		
		Label lblFinition = new Label(mainContainer, SWT.NONE);
		lblFinition.setText("Finition");
		facadeMaterialType = new MaterialTypeInstanceComposite(mainContainer, SWT.NONE);
		facadeMaterialType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		facadeMaterialType.setSize(facadeMaterialType.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		
		
		lblFinitionvitre = new Label(mainContainer, SWT.NONE);
		lblFinitionvitre.setText("Finition Vitre");
		vitreMaterialType = new MaterialTypeInstanceComposite(mainContainer, SWT.NONE);
		vitreMaterialType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		vitreMaterialType.setSize(vitreMaterialType.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		
		Composite handleConfigurerContainer = new Composite(mainContainer, SWT.NONE);
		handleConfigurerContainer.setLayout(new FillLayout(SWT.HORIZONTAL));
		handleConfigurerContainer.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));
		if(handle != null) {
		Group grpPoigne = new Group(handleConfigurerContainer, SWT.NONE);
		grpPoigne.setText("Poignée");
		grpPoigne.setLayout(new FillLayout(SWT.HORIZONTAL));
			handleConfigurer = new FacadeHandleConfigurer(grpPoigne, handle);
		}
		bind();		
	}

	private void bind() {

		Material facadeMaterial= facade.getMaterial();
		if(facadeMaterial!=null) {
			tableComboVwr_facademat.setSelection(new StructuredSelection(facadeMaterial));
		}
		if (facade.getMaterialType() != null) {
			facadeMaterialType.setMaterial(facade.getMaterialType());
			facadeMaterialType.setEnabled(true);
		} else {
			facadeMaterialType.setEnabled(false);
		}

		try {
			MechanicDesignElment element = facade.getMechanicDesignElementDefinition();
			var facadeType = element.getFacadeType();
			if(facadeType == null)
			{
				MechanicPublicParam paramFacade = facade.getMechanicDesignDefinition().getPublicParam("FACADE_TYPE");
				if(paramFacade!=null)
				{
					facadeType = paramFacade.getTypedefelement();
				}
			}
			if(facadeType == null)
			{
				facadeType = ModelProvider.getTypeDef("FACADE_TYPE").getElement("SIMPLE");
			}
			if(facadeType == null)
			{
				TypeDef type=ModelProvider.getTypeDef("FACADE_TYPE");
				facadeType = type.getTypedefelement().get(type.getTypedefelement().size()-1);
			}
			
			typeCombo.setSelection(new StructuredSelection(facadeType));
		} catch (Exception e) {
			e.printStackTrace();
		}
		if (facade.getVitreMaterialType() != null) {
			vitreMaterialType.setMaterial(facade.getVitreMaterialType());
			vitreMaterialType.setEnabled(true);
		} else {
			vitreMaterialType.setEnabled(false);
		}
	}
	
	public void update() {
		
		if(facadeMaterialType.isDirty()) {
			MaterialTypeInstance material = facadeMaterialType.getMaterial();
			MaterialTypeInstance elementMaterialType = facade.getMaterialType();
			elementMaterialType.setIsColor(material.isIsColor());
			elementMaterialType.setMaterial(material.getMaterial());
			elementMaterialType.setTexture(facadeMaterialType.getSelectedTexture());
			if (facadeMaterialType.getColorComposite().isDirty()) {
				elementMaterialType.setColor(facadeMaterialType.getColorComposite().getEmfColor());
			}
			facade.getMechanicDesignElementDefinition().setMaterialTypeFree(true);
		}
		
		if(vitreMaterialType.isDirty()) {
			MaterialTypeInstance material = vitreMaterialType.getMaterial();
			MaterialTypeInstance elementMaterialType = facade.getVitreMaterialType();
			elementMaterialType.setIsColor(material.isIsColor());
			elementMaterialType.setMaterial(material.getMaterial());
			elementMaterialType.setTexture(vitreMaterialType.getSelectedTexture());
			if (vitreMaterialType.getColorComposite().isDirty()) {
				elementMaterialType.setColor(vitreMaterialType.getColorComposite().getEmfColor());
			}
			facade.getMechanicDesignElementDefinition().setVitreMaterialTypeFree(true);
		}
		
		var facadeType = facade.getMechanicDesignElementDefinition().getFacadeType();
		if(facadeType == null || !facade.getMechanicDesignElementDefinition().getFacadeType().equals(type)) {
			facade.getMechanicDesignElementDefinition().setFacadeType(type);
			facade.getMechanicDesignElementDefinition().setFacadeTypeFree(true);
		}
		
		if(handle != null) {
			handleConfigurer.updateDoorHandle();
		}
	}

}
