package gdxapp.screens.ObjectEditor;


import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;

import dressing.events.Event;
import dressing.events.EventDriver;
import gdxapp.assets.AssetsTextures;
import gdxapp.object3d.Object3D;
import gdxapp.object3d.WorldObject;
import gdxapp.scenes.SceneEvent;

public class Object3DRightClickMenu extends Table {
	
	private static final String MOVE_LABEL =  "move";
	private static final String ROTATE_LABEL =  "rotate";
	private static final String SCALE_LABEL =  "scale";
	private static final String COPY_LABEL =  "copy";
	private static final String DELETE_LABEL =  "delete";
	private static final String HIDE_LABEL = "hide";
	private static final String ISOLATE_LABEL = "isolate";
	private static final String PLUMBING_LABEL = "plumbing scheme";
	private static final String ISOLATED_VIEW = "isolated view";

	
	public final static int PLUMBING = 0;
	
	private Object3D subject;
	
	TextButton moveBtn;
	TextButton rotateBtn;
	TextButton scaleBtn;
	TextButton deleteBtn;
	TextButton copyBtn;

	MoveWindow moveWindow;
	RotateWindow rotateWindow;
	ScaleWindow scaleWindow;
	
	List<String> menu;
	MenuChangeListener menuChangeListener;
	
	private static Object3DRightClickMenu instance;
	
	private Object3DRightClickMenu() {
		super();
		createContents();
	}
	
	
	public void createContents() {
		
		copyBtn = new TextButton("copy", AssetsTextures.getInstance().getSkin());
		moveBtn = new TextButton("move", AssetsTextures.getInstance().getSkin());
		rotateBtn = new TextButton("rotate", AssetsTextures.getInstance().getSkin());
		scaleBtn = new TextButton("scale", AssetsTextures.getInstance().getSkin());
		deleteBtn = new TextButton("delete", AssetsTextures.getInstance().getSkin());
		
		moveWindow = new MoveWindow();
		
		menu = new List<String>(AssetsTextures.getInstance().getSkin(), "default");
		setListeners();
		menu.setSize(300, 30 * menu.getItems().size);
				
		add(menu);
		
	}
	
	private void setForObjectHandling() {
		
		clearChildren();
		
		menu = new List<String>(AssetsTextures.getInstance().getSkin(), "default");
		menu.setItems(COPY_LABEL, MOVE_LABEL, ROTATE_LABEL, SCALE_LABEL, DELETE_LABEL, HIDE_LABEL, ISOLATE_LABEL, ISOLATED_VIEW);
		menu.setSelectedIndex(-1);
		setListeners();
		menu.setSize(300, 30 * menu.getItems().size);
		add(menu);

		
	}
	
	public void setForPlumbing() {
		clearChildren();
		menu = new List<String>(AssetsTextures.getInstance().getSkin(), "default");
		menu.setItems(PLUMBING_LABEL);
		menu.setSelectedIndex(-1);
		setListeners();
		menu.setSize(300, 30 * menu.getItems().size);
		add(menu);

	}
	
	private void setListeners() {
		if(menuChangeListener == null)
			menuChangeListener = new MenuChangeListener();
		menu.addListener(menuChangeListener);
		menu.addCaptureListener(menuChangeListener);
		
		
	}


	public static Object3DRightClickMenu getInstance() {
		if(instance == null)
			instance = new Object3DRightClickMenu();
		return instance;
	}
	
	
	public void requestDelete() {
		EventDriver.getDriver().deliverEvent(new Event(SceneEvent.REMOVE_OBJECT_REQUEST.name(), subject));
		menu.setSelectedIndex(-1);
		remove();
		
	}
	
	public void requestHide() {
		EventDriver.getDriver().deliverEvent(new Event(SceneEvent.HIDE_OBJECT.name(), subject));
		menu.setSelectedIndex(-1);
		remove();		
	}
	
	
	public void displayMoveWindow() {
		moveWindow.setPosition(Gdx.graphics.getWidth()/2, Gdx.graphics.getHeight()/2);
		getStage().addActor(moveWindow);
		moveWindow.setVisible(true);
		menu.setSelectedIndex(-1);
		remove();
	}
	
	public Object3D getSubject() {
		return subject;
	}


	public void setSubject(Object3D subject) {
		this.subject = subject;
	}
	
	

	class MoveWindow extends Window{
		
		private static final String title = "move object";
		
		TextField xInput;
		TextField yInput;
		TextField zInput;
		
		TextButton submitBtn;
		TextButton cancelBtn;

		public MoveWindow( ) {
			super(title, AssetsTextures.getInstance().getSkin());
			MoveWindow.this.createContents();
		}
		
		private void createContents() {
			pad(20);
			Label positionLabel = new Label("position", getSkin(), "default");
			xInput = new TextField("", getSkin());
			yInput = new TextField("", getSkin());
			zInput = new TextField("", getSkin());
			
			submitBtn = new TextButton("move", getSkin());
			submitBtn.addListener(new ClickListener() {

				@Override
				public void clicked(InputEvent event, float x, float y) {
					
					Vector3 pos = new Vector3(Float.valueOf(xInput.getText()), 
							Float.valueOf(yInput.getText()), Float.valueOf(zInput.getText()));
					subject.translate(pos.sub(subject.getPosition()));
					MoveWindow.this.remove();
				}
				
			});
			cancelBtn = new TextButton("cancel", getSkin());
		
			add(positionLabel);
			add(new Label("X:" , getSkin(), "default"));
			add(xInput).width(80);
			add(new Label("Y:" , getSkin(), "default"));
			add(yInput).width(80);
			add(new Label("Z:" , getSkin(), "default"));
			add(zInput).width(80);
			row();
			add(cancelBtn).expand().right();
			add(submitBtn).expand().left();
			pack();
			setPosition(Gdx.graphics.getWidth()/2, Gdx.graphics.getHeight());
		}

		
	}
	
	class RotateWindow{
		
	}
	
	class ScaleWindow{
		
	}
	
	class MenuChangeListener extends ChangeListener{
		
		

		@Override
		public void changed(ChangeEvent event, Actor actor) {
			String selection = menu.getSelected();
			if(selection != null) {
				switch (selection) {
				case MOVE_LABEL:
					displayMoveWindow();
					break;
				case ROTATE_LABEL:
					
					break;
				case SCALE_LABEL:
					
					break;
				case COPY_LABEL:
					
					break;
				case DELETE_LABEL:
					requestDelete();
					break;
				case HIDE_LABEL:
					requestHide();
					break;
				case ISOLATE_LABEL:
					isolateRequest(subject);
					break;
				case PLUMBING_LABEL:
					invokePlumberEditor();
					break;
				case ISOLATED_VIEW:
					invokeModelViewer(subject.getWorldObject());
				}
			}
		}

		private void invokeModelViewer(WorldObject worldObject) {
			EventDriver.getDriver().deliverEvent(new Event(SceneEvent.ISOLATED_VIEW.name(), subject.getWorldObject()));
			menu.setSelectedIndex(-1);
			remove();			
		}

		private void invokePlumberEditor() {
			EventDriver.getDriver().deliverEvent(new Event(SceneEvent.PLUMBING_EDITOR.name(), subject));
			menu.setSelectedIndex(-1);
			remove();
		}

		private void isolateRequest(Object3D subject) {
			EventDriver.getDriver().deliverEvent(new Event(SceneEvent.ISOLATE_OBJECT.name(), subject));
			menu.setSelectedIndex(-1);
			remove();
		}
		
	}

	public void makeKeyBoardFocus() {
		getStage().setKeyboardFocus(menu);
	}


	@Override
	public void draw(Batch batch, float parentAlpha) {
		super.draw(batch, parentAlpha);
		if(getStage().getKeyboardFocus() != menu ) {
			remove();
		}
	}


	public void setContent(int content) {
		switch (content) {
		case PLUMBING:
			setForPlumbing();
			break;
		default:
			setForObjectHandling();
			break;
		}
	}



	
	
	
}
