package gdxapp.object3d;

import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="info")
public class ModelInfo implements Serializable{
	
	private String name;
	private UUID uuid;
	private float width, height, depth;
	private Matrix4 transform;
	private Properties properties = new Properties();
	private Vector3 scale;
	private Vector3 translation;
	private transient Quaternion rotation;
	
	
	public void setToDefault() {
		name = "";
		scale = new Vector3(1,1,1);
		translation = new Vector3(0,0,0);
		rotation = new Quaternion(Vector3.Y, 0);
		transform = new Matrix4(translation, rotation, scale);
		uuid = UUID.randomUUID();
		name = "object_" + uuid;
		width = 1;
		height = 1;
		depth = 1;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public UUID getUuid() {
		return uuid;
	}
	public void setUuid(UUID uuid) {
		this.uuid = uuid;
	}
	public Properties getProperties() {
		return properties;
	}
	public void setProperties(Properties properties) {
		this.properties = properties;
	}
	
	public float getWidth() {
		return width;
	}
	public void setWidth(float width) {
		this.width = width;
	}
	public float getHeight() {
		return height;
	}
	public void setHeight(float height) {
		this.height = height;
	}
	public float getDepth() {
		return depth;
	}
	public void setDepth(float depth) {
		this.depth = depth;
	}
	public Matrix4 getTransform() {
		return transform;
	}
	public void setTransform(Matrix4 transform) {
		this.transform = transform;
	}
	public Vector3 getScale() {
		return scale;
	}
	public void setScale(Vector3 scale) {
		this.scale = scale;
	}
	public Vector3 getTranslation() {
		return translation;
	}
	public void setTranslation(Vector3 translation) {
		this.translation = translation;
	}
	public Quaternion getRotation() {
		return rotation;
	}
	public void setRotation(Quaternion rotation) {
		this.rotation = rotation;
	}
	
	public ModelInfo clone() {
		ModelInfo info=new ModelInfo();
		info.setToDefault();
		info.scale=scale.cpy();
		info.translation=translation.cpy();
		info.setName(getName());
		info.setWidth(getWidth());
		info.setDepth(getDepth());
		info.setHeight(getHeight());
		info.setUuid(getUuid());
		info.setRotation(rotation.cpy());
		info.setProperties((Properties) properties.clone());
		return info;
	}
	
	
}
