package dressing.ui.tiroire;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;

import dressing.controller.TiroireCreator;
import dressing.model.DesignException;
import dressing.model.evalutor.GeometricEngineException;
import dressing.ui.etagere.EtagereCompositeWelcomePage;

public class TiroireWizardWelcomePage extends WizardPage{
	TiroireCreator tCreator;
	TiroireCompositeWelcomePage composite;
	PropertyChangeListener pcl;
	boolean errorfound=true;
	/**
	 * @return the tCreator
	 */
	public TiroireCreator gettCreator() {
		return tCreator;
	}

	/**
	 * @param tCreator the tCreator to set
	 */
	public void settCreator(TiroireCreator tCreator) {
		this.tCreator = tCreator;
	}

	protected TiroireWizardWelcomePage(String pageName,TiroireCreator tCreator) {
		super(pageName);
		settCreator(tCreator);
		setTitle("Block Tiroire information");
		setDescription("S'il vous plais entrer les informataion de vous Tiroires");
		setPageComplete(false);
		
	}

	@Override
	public void createControl(Composite parent) {
		// TODO Auto-generated method stub
		composite = new TiroireCompositeWelcomePage(parent, SWT.BORDER, tCreator);
		setControl(composite);
		pcl = new PropertyChangeListener() {

			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				// TODO Auto-generated method stub
				System.out.println("ho");
				if (!evt.getPropertyName().startsWith("project.")) // seulemnt les proprietes de javabean
				{
					try {
					
						tCreator.create();
						
						setErrorMessage(null);
						errorfound = false;
						setMessage("Vous pouvez ajouter votre Etagère", WizardPage.INFORMATION);
					} catch (DesignException | GeometricEngineException e) {
						setErrorMessage(e.getMessage());

						errorfound = true;
					}
					getWizard().getContainer().updateButtons();
				}

			}
		};
	
		tCreator.addPropertyChangeListener(pcl);

	}
	@Override
	public boolean isPageComplete() {
		// TODO Auto-generated method stub
		boolean b = true;
		return b;
	}

	public void clearlistners() {
		tCreator.removePropertyChangeListener(pcl);
	}
	
	

}
