package dressing.ui.caissonciosine;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;

import dressing.controller.CaissonCuisineCreator;
import dressing.controller.CuisineCreator;
import dressing.model.Cuisine;
import dressing.model.DesignException;
import dressing.model.Project3D;
import dressing.model.evalutor.GeometricEngineException;
import dressing.ui.cuisine.CuisineWizardPage;

public class CaissonCuisineWizard extends Wizard {
	CaissonCuisineWizardPage caissoncuisinepage;
	Cuisine cuisine;
	CaissonCuisineCreator caisson=new CaissonCuisineCreator();
	public CaissonCuisineWizard() {
		setWindowTitle("New Wizard");
	}

	@Override
	public void addPages() {
		caissoncuisinepage=new CaissonCuisineWizardPage("welcome Page", caisson);
			this.addPage(caissoncuisinepage);
	}

	@Override
	public boolean performFinish() {
		for(IWizardPage page :getPages())
		{
			((WizardPage) page).setErrorMessage("");
		}
			try {
				this.caisson.create();
				
				caissoncuisinepage.clearlistners();
//			
				this.cuisine.addElement(caisson.getCaissonInstance());		
			} catch (DesignException  | GeometricEngineException e) {
				for(IWizardPage page :getPages())
				{
					((WizardPage) page).setErrorMessage(e.getMessage());
				}
					return false;
			}

					
			return true;
	}
	
public void setProject3d(Cuisine project3d) {
	this.cuisine = project3d;	
	caisson.setParent(project3d);
}

}
