package dressing.handlers.gdx;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.Active;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.internal.contexts.EclipseContext;

import com.badlogic.gdx.Gdx;

import dressing.model.ProjectManager;
import gdxapp.Commun.Preferences;
import gdxapp.scenes.Scene;
import gdxapp.screens.room3d.Room3DScreen;

public class ViewGdx3D {
	
	@Inject 
	IEclipseContext  eclipsecontext;
	@Execute
	public void execute() {
		Gdx.app.postRunnable(new Runnable() {
			@Override
			public void run() {
				// TODO Auto-generated method stub
				Scene.game.setScreen(Room3DScreen.getInstance());

			}
		});
	}
	
	@CanExecute
	public boolean check() {
		if(ProjectManager.getManager().getCurrentKitchen()==null) {
			return false;
		}
		
		return true;
	}

}
