package dressing.handlers;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

import dressing.model.Caisson;
import dressing.model.DesignObject3D;
import dressing.model.Dressing;
import dressing.model.Etagere;
import dressing.model.Kitchen;
import dressing.model.ModelProvider;
import dressing.model.Project3D;
import dressing.model.Separator;
import dressing.model.Space3D;
import dressing.model.Space3DFree;
import dressing.model.Tirroir;
import dressing.ui.dressing.DressingWizard;
import dressing.model.Piece2D;
import dressing.model.Piece2DCoupe;
import dressing.model.Project3D;

public class CopyPiecesNomenclatureToExcellHandler {

	@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	
	String groupby=Piece2DCoupe.GROUPBY_NONE;

	@Execute
	public void execute(Shell shell,ParameterizedCommand cmd ){
		Object o = selectionService.getSelection("dressing.part.projectexplorer");
		
		//Determiner la nature de groupement
		if(cmd!=null)
		{
			if(cmd.getParameterMap()!=null)
			{
				String s = (String) cmd.getParameterMap().get("dressing.commandparameter.copyexcell.groupby");
				if(s!=null)
				{
					groupby=s;
				}
			}
		}
		//Voire l element de l arbre selectionne
		if(o instanceof DesignObject3D || o instanceof Object[] || o instanceof Kitchen)
		{
			
			
			
			if(check())
			{
				StringBuilder builder = new StringBuilder();
				Object[] list =null;
				
				if(o instanceof Object[])
				{
					list = (Object[]) o;
				}
				else if(o instanceof Kitchen) {
					list = ((Kitchen) o).getElements().toArray();
				}
				else {
					list =new Object[] {o};
				}
				if(list instanceof Object[]) //Pour suppertorter la selectio multiple
				{
					List<Piece2D> exportedlist = new ArrayList<Piece2D>();
					List<Piece2DCoupe> coupelist = new ArrayList<Piece2DCoupe>();
					for(Object design : (Object[])list)
					{
						if(design instanceof Project3D)
						{
							copyProject3DToExcell((Project3D) design, builder,exportedlist,coupelist);
						}
						else if(design instanceof Dressing)
						{
							copyDressingToExcell((Dressing) design, builder,exportedlist,coupelist);
						}
						else if(design instanceof Caisson || design instanceof Space3DFree)
						{
							copyCaissonToExcell((Space3D) design, builder,exportedlist,coupelist);
						}
						else if(design instanceof Separator)
						{
							copySeparatorToExcell((Separator) design, builder,exportedlist,coupelist);
						}
						else if(design instanceof Piece2D)
						{
							copyPiece2DToExcell((Piece2D) design, builder,exportedlist,coupelist);
						}
					}
					if(groupby!=Piece2DCoupe.GROUPBY_NONE)
					{
						writePiecestoStringBuilder(builder, coupelist);
					}
					exportedlist.clear();
					coupelist.clear();
					exportedlist=null;
					coupelist=null;
				}


				//Le string builder est termioner on cree le data transfer								
				Clipboard clipboard = new Clipboard(Display.getCurrent());
	    	    String textData = builder.toString();
	    	    TextTransfer textTransfer = TextTransfer.getInstance();
	    	    Transfer[] transfers = new Transfer[]{textTransfer};
	    	    Object[] data = new Object[]{textData};
	    	    clipboard.setContents(data, transfers);
	    	    clipboard.dispose();
			}
			

		}		
	}

	@CanExecute
	public boolean check()
	{
		Object o = selectionService.getSelection("dressing.part.projectexplorer");
		//Voire l element de l arbre selectionne
		if(o instanceof Kitchen || o instanceof Caisson || o instanceof Piece2D || o instanceof Dressing || o instanceof Space3DFree)
		{
			return true;
		}
		if(o instanceof Object[])
		{
			return true;
		}
		return false;
	}
	
	private void writePiecestoStringBuilder(StringBuilder builder,List<Piece2DCoupe> coupelist)
	{
		for(Piece2DCoupe piece : coupelist)
		{
//			builder.append(piece.getFullname());
//			builder.append("\t");
			
			builder.append(piece.getProjetname());
			builder.append("\t");
			builder.append(piece.getEtagename());
			builder.append("\t");
			builder.append(piece.getAppartementname());
			builder.append("\t");
			builder.append(piece.getDressingname());
			builder.append("\t");
			builder.append(piece.getCaissonname());
			builder.append("\t");
//			builder.append(piece.getParentname());
//			builder.append("\t");
			builder.append(piece.getPiecename());
			builder.append("\t");			
			builder.append(piece.getMaterial());
			builder.append("\t");			
			builder.append(piece.getPieceL());
			builder.append("\t");
			builder.append(piece.getPieceH());
			builder.append("\t");	
			builder.append(piece.getQty());
			builder.append("\t");	
			builder.append(piece.getChants());
			builder.append("\t");
			builder.append("\n");
		if(piece.getEtagename()== null||piece.getAppartementname()==null||piece.getEtagename().isEmpty()||piece.getAppartementname().isEmpty()) {
			System.out.println("erroooooooooooooooooooooooooooooooooooooooooooooooooooor");
		}
		}
	}	
	private void copyPiece2DToExcell(Piece2D piece,StringBuilder builder,List<Piece2D> exportedlist,List<Piece2DCoupe> coupelist)
	{	
		if(!exportedlist.contains(piece))
		{
			exportedlist.add(piece);
		}
		else
		{
			return; //pour ne pas exporter le m�me elemnt 2 fois
		}		
		//Assembler les pieces par nothing
		 
		
		if(groupby!=Piece2DCoupe.GROUPBY_NONE)
		{
			Piece2DCoupe pcoupe = piece.createPieceCoupe();
			pcoupe.setGroupby(groupby);
			boolean found=false;
			for(Piece2DCoupe pc : coupelist)
			{
				if(pc.equals(pcoupe))
				{
					pc.setQty(pc.getQty()+1);
					found=true;
					break;
				}
			}
			
			if(!found)
			{
				coupelist.add(pcoupe);
			}
			return;//pas besoin de contionuer on doit pas remplir le strigbuilder ici
		}

		
//		if(piece.getParentdesign()!=null && piece.getParentdesign().getParentdesign()!=null && piece.getParentdesign().getParentdesign().getParentdesign()!=null)
//		{	
//			builder.append(piece.getParentdesign().getParentdesign().getParentdesign().getName());
//			builder.append("\t");
//			if(piece.getParentdesign().getParentdesign() instanceof Dressing) {
//				builder.append(((Dressing)piece.getParentdesign().getParentdesign()).getEtage());
//				builder.append("\t");
//				builder.append(((Dressing)piece.getParentdesign().getParentdesign()).getAppartement());
//				builder.append("\t");
//			}
//		
//			builder.append(piece.getParentdesign().getParentdesign().getName());
//			builder.append("\t");
//			builder.append(piece.getParentdesign().getName());
//			builder.append("\t");
//		}
//		else if(piece.getParentdesign()!=null && piece.getParentdesign().getParentdesign()!=null)
//		{
//			if(piece.getParentdesign().getParentdesign() instanceof Dressing) {
//			builder.append(((Dressing)piece.getParentdesign().getParentdesign()).getEtage());
//			builder.append("\t");
//			builder.append(((Dressing)piece.getParentdesign().getParentdesign()).getAppartement());
//			builder.append("\t");
//			}
//			builder.append(" ");
//			builder.append("\t");
//			builder.append(piece.getParentdesign().getParentdesign().getName());
//			builder.append("\t");
//			builder.append(piece.getParentdesign().getName());
//			builder.append("\t");
//		}
//		else if(piece.getParentdesign()!=null)
//		{
//			builder.append(" ");
//			builder.append("\t");
//			builder.append(" ");
//			builder.append("\t");
//			builder.append(piece.getParentdesign().getName());
//			builder.append("\t");
//		}
		DesignObject3D parent=piece.getParentdesign();
		List<String> strings=new ArrayList<String>();
		while( parent !=null)
		{	
				if(parent instanceof Space3D&& !(parent instanceof Caisson)&& !(parent instanceof Dressing) && !(parent instanceof Tirroir)) {
					parent =parent.getParentdesign();
				}
				else if(parent instanceof Dressing) {
//					builder.append(((Dressing)parent).getEtage());
//					builder.append("\t");
//					builder.append(((Dressing)parent).getAppartement());
//					builder.append("\t");
//					builder.append(parent.getName());
//					builder.append("\t");		
					strings.add(parent.getName());
					strings.add("\t");
					strings.add(((Dressing)parent).getAppartement());
					strings.add("\t");
					strings.add(((Dressing)parent).getEtage());
					strings.add("\t");
					
					
					parent =parent.getParentdesign();

					}
				else if(parent instanceof Project3D) {
//					builder.append(parent.getName());
//					builder.append("\t");
					strings.add(parent.getName());
					break;
				}
				else if(parent instanceof Caisson) {
//					builder.append(parent.getName());
//					builder.append("\t");
					strings.add(parent.getName());
					strings.add("\t");
					parent =parent.getParentdesign();
				}else if(parent instanceof Separator) {
					parent =parent.getParentdesign();
					
				}
				else if(parent instanceof Tirroir) {
//					strings.remove(strings.size()-1);
					strings.add(parent.getName()+"_");
					strings.add("\t");
					parent =parent.getParentdesign();
				}
				
			
		}
		for(int i=strings.size()-1;i>=0;i--) {
			builder.append(strings.get(i));
		}
		if(! (piece.getParentdesign() instanceof Tirroir)) {
			builder.append("\t");
		}
		
		builder.append(piece.getName());
		builder.append("\t");
		
		builder.append(piece.getMaterial().getName());
		builder.append("\t");

		builder.append(piece.getPieceL());
		builder.append("\t");
		
		
		builder.append(piece.getPieceH());
		builder.append("\t");
		
		builder.append(1);
		builder.append("\t");
		
		builder.append(piece.getChants());
		builder.append("\t");
		
		builder.append("\n");
	}
	private void copyCaissonToExcell(Space3D o,StringBuilder builder,List<Piece2D> exportedlist,List<Piece2DCoupe> coupelist)
	{		
		for(DesignObject3D p : o.getChilds())
		{	
			if(p instanceof Tirroir) {
				copyTiroireToExcell((Tirroir)p, builder, exportedlist, coupelist);
			}
			if(p instanceof Separator) {
				copySeparatorToExcell((Separator)p, builder, exportedlist, coupelist);
			}
			else if(p instanceof Piece2D)
			{
				copyPiece2DToExcell((Piece2D) p,builder,exportedlist,coupelist);
			}
		}	
		
	}
	private void copyTiroireToExcell(Tirroir o,StringBuilder builder,List<Piece2D> exportedlist,List<Piece2DCoupe> coupelist)
	{		
//		
//		builder.append(o.getName());
//		builder.append("\t");
//		
//		builder.append(1);
//		builder.append("\t");
//		
//		builder.append("\n");
		for(DesignObject3D p : o.getChilds())
		{
			if(p instanceof Separator) {
				copySeparatorToExcell((Separator)p, builder, exportedlist, coupelist);
			}
			else if(p instanceof Piece2D)
			{
				copyPiece2DToExcell((Piece2D) p,builder,exportedlist,coupelist);
			}
		}	
		
	}
	private void copyProject3DToExcell(Project3D design,StringBuilder builder,List<Piece2D> exportedlist,List<Piece2DCoupe> coupelist)
	{		
		List<Piece2D>	piecelist  = new ArrayList<>();
		List<Caisson>	caissonlist  = new ArrayList<>();
		List<Dressing>	dressinglist  = new ArrayList<>();
		
		for(DesignObject3D c : design.getChilds())
		{
			if(c instanceof Caisson)
			{
				caissonlist.add((Caisson) c);
			}
			if(c instanceof Piece2D)
			{
				piecelist.add((Piece2D) c);
			}
			
			if(c instanceof Dressing)
			{
				dressinglist.add((Dressing) c);
			}
		}
		for(Piece2D piece : piecelist)
		{
			if(piece instanceof Separator) {
			copySeparatorToExcell((Separator)piece, builder, exportedlist, coupelist);
			}
			else {
			copyPiece2DToExcell(piece, builder,exportedlist,coupelist);

			}
		}
		for(DesignObject3D c : caissonlist)
		{
			copyCaissonToExcell((Caisson)c, builder,exportedlist,coupelist);
		}
		
		for(Dressing dr : dressinglist)
		{
			copyDressingToExcell(dr, builder,exportedlist,coupelist);
		}
		
	}
	
	private void copyDressingToExcell(Dressing design, StringBuilder builder,List<Piece2D> exportedlist,List<Piece2DCoupe> coupelist) {
		// TODO Auto-generated method stub
		List<Piece2D>	piecelist  = new ArrayList<>();
		List<Caisson>	caissonlist  = new ArrayList<>();			
		for(DesignObject3D c : design.getChilds())
		{
			if(c instanceof Caisson)
			{
				caissonlist.add((Caisson) c);
			}
			if(c instanceof Piece2D)
			{
				piecelist.add((Piece2D) c);
			}
		}
		for(Piece2D piece : piecelist)
		{
			if(piece instanceof Separator) {
				copySeparatorToExcell((Separator)piece, builder, exportedlist, coupelist);
			}else {
				copyPiece2DToExcell(piece, builder,exportedlist,coupelist);
			}
		}
		for(DesignObject3D c : caissonlist)
		{
			copyCaissonToExcell((Caisson)c, builder,exportedlist,coupelist);
		}
	}
	private void copySeparatorToExcell(Separator piece,StringBuilder builder,List<Piece2D> exportedlist,List<Piece2DCoupe> coupelist) {
		copySeparatorPiece2dToExcell(piece, builder, exportedlist, coupelist);
		for(DesignObject3D child:piece.getChilds()) {
			
			if(child instanceof Space3D )
			{	
				for(DesignObject3D childspace:child.getChilds()) {
					
				
					if(childspace instanceof Tirroir) {
						copyTiroireToExcell((Tirroir)childspace, builder, exportedlist, coupelist);
						break;
					}
					Piece2D childs=(Piece2D)childspace;
					if(childspace instanceof Separator ) {
						copySeparatorToExcell((Separator) childspace,builder,exportedlist,coupelist);
						break;
					}
					if(childspace instanceof Piece2D) {
						if(!exportedlist.contains(childs))
						{
							exportedlist.add(childs);
						}
						else
						{
							break; //pour ne pas exporter le m�me elemnt 2 fois
						}	
						//Assembler les pieces par nothing
						if(groupby!=Piece2DCoupe.GROUPBY_NONE)
						{
							Piece2DCoupe pcoupe =((Piece2D)childspace).createPieceCoupe();
							pcoupe.setGroupby(groupby);
							boolean found=false;
							for(Piece2DCoupe pc : coupelist)
							{
								if(pc.equals(pcoupe))
								{
									pc.setQty(pc.getQty()+1);
									found=true;
									break;
								}
							}
							
							if(!found)
							{
								coupelist.add(pcoupe);
							}
							continue;//pas besoin de contionuer on doit pas remplir le strigbuilder ici
						}
						DesignObject3D parent=childspace.getParentdesign();
						List<String> strings=new ArrayList<String>();
						while( parent !=null)
						{	
								if(parent instanceof Space3D&& !(parent instanceof Caisson)&& !(parent instanceof Dressing)&& !(parent instanceof Tirroir)) {
									parent =parent.getParentdesign();
								}
								if(parent instanceof Dressing) {
//									builder.append(((Dressing)parent).getEtage());
//									builder.append("\t");
//									builder.append(((Dressing)parent).getAppartement());
//									builder.append("\t");
//									builder.append(parent.getName());
//									builder.append("\t");		
									strings.add(parent.getName());
									strings.add("\t");
									strings.add(((Dressing)parent).getAppartement());
									strings.add("\t");
									strings.add(((Dressing)parent).getEtage());
									strings.add("\t");
									
									
									parent =parent.getParentdesign();

									}
								if(parent instanceof Project3D) {
//									builder.append(parent.getName());
//									builder.append("\t");
									strings.add(parent.getName());
									break;
								}
								if(parent instanceof Caisson) {
//									builder.append(parent.getName());
//									builder.append("\t");
									strings.add(parent.getName());
									strings.add("\t");
									parent =parent.getParentdesign();
								}if(parent instanceof Separator) {
									parent =parent.getParentdesign();
									
								}if(parent instanceof Tirroir) {
									
//									strings.remove(strings.size()-1);
									strings.add(parent.getName()+"_");
									strings.add("\t");
									parent =parent.getParentdesign();
								}
							
						}	
						
						for(int i=strings.size()-1;i>=0;i--) {
							builder.append(strings.get(i));
						}
						if(! (childs.getParentdesign() instanceof Tirroir)) {
							builder.append("\t");
						}
					builder.append(childs.getName());
					builder.append("\t");
					
					builder.append(childs.getMaterial().getName());
					builder.append("\t");
					
					builder.append(childs.getPieceL());
					builder.append("\t");
					
					builder.append(childs.getPieceH());
					builder.append("\t");
					
					builder.append(1);
					builder.append("\t");
					
					builder.append(childs.getChants());
					builder.append("\t");
					
					builder.append("\n");
				}
				}
			}
			
		}
		
		
		
	}
	private void copySeparatorPiece2dToExcell(Separator piece,StringBuilder builder,List<Piece2D> exportedlist,List<Piece2DCoupe> coupelist) {
	

		if(piece instanceof Piece2D) {
			
		//Assembler les pieces par nothing
		if(groupby!=Piece2DCoupe.GROUPBY_NONE)
		{
			Piece2DCoupe pcoupe = piece.createPieceCoupe();
			pcoupe.setGroupby(groupby);
			boolean found=false;
			for(Piece2DCoupe pc : coupelist)
			{
				if(pc.equals(pcoupe))
				{
					pc.setQty(pc.getQty()+1);
					found=true;
					break;
				}
			}
			
			if(!found)
			{
				coupelist.add(pcoupe);
			}
			return;//pas besoin de contionuer on doit pas remplir le strigbuilder ici
		}
		DesignObject3D parent=piece.getParentdesign();
		List<String> strings=new ArrayList<String>();
		while( parent !=null)
		{	
				if(parent instanceof Space3D&& !(parent instanceof Caisson)&& !(parent instanceof Dressing)) {
					parent =parent.getParentdesign();
				}
				if(parent instanceof Dressing) {
					strings.add(parent.getName());
					strings.add("\t");
					strings.add(((Dressing)parent).getAppartement());
					strings.add("\t");
					strings.add(((Dressing)parent).getEtage());
					strings.add("\t");
					
					
					parent =parent.getParentdesign();

					}
				if(parent instanceof Project3D) {
					strings.add(parent.getName());
					break;
				}
				if(parent instanceof Caisson) {
					strings.add(parent.getName());
					strings.add("\t");
					parent =parent.getParentdesign();
				}if(parent instanceof Separator) {
					parent =parent.getParentdesign();
					
				}
			
		}	
		
		for(int i=strings.size()-1;i>=0;i--) {
			builder.append(strings.get(i));
		}
		builder.append("\t");
	builder.append(piece.getName());
	builder.append("\t");
	
	builder.append(piece.getMaterial().getName());
	builder.append("\t");
	
	builder.append(piece.getPieceL());
	builder.append("\t");
	
	builder.append(piece.getPieceH());
	builder.append("\t");
	
	builder.append(1);
	builder.append("\t");
	
	builder.append(piece.getChants());
	builder.append("\t");
	
	builder.append("\n");
		}

	}
}
