package supercad.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;

import supercad.structures.Node;
import supercad.structures.NodeIterator;
import supercad.xml.XmlTag.TAG_TYPE;

public class XmlNode implements Node {
	
	protected String name;
	protected HashMap<String, String> attributes;
	protected String value;
	protected XmlNode parent;
	protected ArrayList<XmlNode> children = new ArrayList<XmlNode>();
	
	//properties coming
	protected String rawString;
	protected String rawContent;
	
	
	
	public void addChild(XmlNode node) {
		if(children == null)
			children = new ArrayList<XmlNode>();
		this.children.add(node);
	}
	
	public XmlNode getFirstChild() {
		return children.get(0);
	}
	
	public void parse()  {
		String trimmed = rawString.trim();
		if(!trimmed.startsWith("<"))
			throw new Error("invalid xml element");
		String startTag = trimmed.substring(0, trimmed.indexOf('>') + 1);
		XmlTag tag = new XmlTag(startTag);
		this.name = tag.getTagName();
		this.attributes = tag.getAttrs();
		if(tag.getType() != TAG_TYPE.SELF_CLOSING) {
			trimmed = trimmed.replace(startTag, "");
			int index = trimmed.length() - 1;
			do {
				
			}while(trimmed.charAt(index--) != '<');
			this.rawContent = trimmed.substring(0,index);
			
		}
	}
	
	public String getAttr(String attrName) {
		return attributes.get(attrName);
	}
	
	public XmlNode getChildByName(String name) {
		for(XmlNode node: children) {
			if(node.getName().equals(name))
				return node;
		}
		return null;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public HashMap<String, String> getAttributes() {
		return attributes;
	}

	public void setAttributes(HashMap<String, String> attributes) {
		this.attributes = attributes;
	}

	public XmlNode getParent() {
		return parent;
	}

	public void setParent(XmlNode parent) {
		this.parent = parent;
	}

	public String getRawString() {
		return rawString;
	}

	public void setRawString(String rawString) {
		this.rawString = rawString;
	}
	
	

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getRawContent() {
		return rawContent;
	}

	public void setRawContent(String rawContent) {
		this.rawContent = rawContent;
	}

	@Override
	public String toString() {
		return "XmlNode [name=" + name + ", attributes=" + attributes + ", children=" + children + "]";
	}




	@Override
	public Iterator<Node> iterator() {
		return new NodeIterator(this);
	}

	@Override
	public ArrayList<XmlNode> getChildren() {
		return children;
	}


	
	
}