package supercad.graphics;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import com.badlogic.gdx.math.Matrix4;

import dressing.io.IOUtilities;
import gdxapp.shaders.PbrMaterial;

public class SceneExporter {

	private WaveFrontParser parser = new WaveFrontParser();
	private MeshIndexer optimizer = new MeshIndexer();
	private MtlParser parsermtl = new MtlParser();
	private String contentmtl;
	private ArrayList<PbrMaterial> mtlList = new ArrayList<PbrMaterial>();
	private int j;

	public void exportScene(String pathToElements, String path) {
		File sceneFolder = new File(pathToElements);
		if (!sceneFolder.exists()) {
			System.out.println(pathToElements + "doesn t exist! aborting export!");
		}
		File oldTextureFile = new File(sceneFolder, "texture");
		File nouveauFile = new File(path);
		File[] elementTexture = oldTextureFile.listFiles();
		if (elementTexture != null) {
			for (File texture : elementTexture) {
				File updateFile = new File(nouveauFile, texture.getName());
				try {
					IOUtilities.copyFileUsingChannel(texture, updateFile);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}

		File[] elementFolders = sceneFolder.listFiles(new FileFilter() {			
			@Override
			public boolean accept(File pathname) {
				if(!pathname.isFile())
					return false;
				if(pathname.getName().endsWith(".obj"))
					return true;
				return false;
			}
		});
		TNode scene = new TNode();
		int i = 0;
		for (File dotObjFile : elementFolders) {
			String modelName = dotObjFile.getName().split("\\.")[0];
			String transformFile = pathToElements + File.separator +  modelName + ".txt";
			String mtlfile = pathToElements + File.separator + modelName + ".mtl";

			TNode elementnode = new WaveFrontParser().parseFile(dotObjFile.getAbsolutePath(), mtlfile);
			elementnode.setNameNode("element" + i++);
			Matrix4 transform = WaveFrontParser.readTransformFile(transformFile);
			for (TNode node : elementnode) {
				node.setNameNode(node.getNameNode().trim() + i);
				PbrMaterial nodeMtl = node.getMaterial();

				if (nodeMtl != null) {
					boolean exist = false;
					for (PbrMaterial materiel : mtlList) {
						if (materiel.equals(nodeMtl)) {
							exist = true;
							break;
						}
					}

					if (!exist) {
						mtlList.add(nodeMtl);
					}
				}

				Simplex3D[] faces = node.getSimplices();
				if (faces != null) {

					for (Simplex3D face : faces) {
						for (Vertex vertex : face.getVertices()) {
							vertex.getPosition().mul(transform.cpy());
						}
					}
				}
			}

			scene.addChild(elementnode);
		}

		File optfile = new File(path);
		optfile.mkdir();
		Exportmtl exportmtl = new Exportmtl();
		IOUtilities.addStringTofile(optfile, "model.mtl", exportmtl.exportmtl(mtlList, path));
		IOUtilities.addStringTofile(optfile, "model.obj", optimizer.index(scene, mtlList));

	}

	class ModelFolderFilter implements FileFilter {
		@Override
		public boolean accept(File pathname) {
			if (!pathname.isDirectory())
				return false;
			File[] content = pathname.listFiles();
			boolean containsTransformFile = false;
			boolean containsObjectFile = false;
			for (File file : content) {
				if (file.getName().endsWith(".txt"))
					containsTransformFile = true;
				if (file.getName().endsWith(".obj"))
					containsObjectFile = true;
			}
			return containsObjectFile && containsTransformFile;
		}
	}
//	public static void main(String...strings) {
//		SceneExporter sceneExporter = new SceneExporter();
//		sceneExporter.exportScene("C:\\ProgramData\\supercad\\projects\\demo rustic\\3d scene", "C:\\scene_exports");
//	}

}
