package gdxapp.screens.wall;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import dressing.graphics.shapes2d.Line;
import dressing.mathutils.MathUtilities;
import dressing.model.ProjectManager;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.GroupSelection;
import gdxapp.assets.AssetsTextures;
import gdxapp.assets.DrawingHelper;
import gdxapp.object3d.Object2D;
import gdxapp.scenes.Scene;
import com.badlogic.gdx.scenes.scene2d.InputListener;

public class OnSurfacePositioner extends Actor {

	private final static String TAG = OnSurfacePositioner.class.getName();

	private Line leftAnchor;
	private Line rightAnchor;
	private Line topAnchor;
	private Line bottomAnchor;

	private Window anchorWindow;
	private Line selectedAnchor;
	private long lastClickDate;
	private float[] scales;
	private static OnSurfacePositioner positioner = new OnSurfacePositioner();
	TextField tf;
	private Object2D subject;
	private InputListener inputListener;

	private OnSurfacePositioner() {
		leftAnchor = new Line();
		rightAnchor = new Line();
		topAnchor = new Line();
		bottomAnchor = new Line();
		createInputListener();
	}

	private void createInputListener() {
		this.inputListener = new InputListener() {

			@Override
			public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
				if (subject == null)
					return false;
				Vector2 stageCoords = new Vector2(x,y);
				long newClickDate = System.currentTimeMillis();
				boolean handled = false;
				if (button == Input.Buttons.LEFT ) {
					if (selectedAnchor != null && newClickDate - lastClickDate < 300) {
						if (anchorWindow == null) {
							createAnchorWindow();
						} else {
							float distance = selectedAnchor.getLength() * scales[1];
							String value = String.valueOf(Math.round(distance * 1000));
							tf.setText(value);
						}
						Vector3 scale = new Vector3();
						getStage().getBatch().getTransformMatrix().getScale(scale);
						OrthographicCamera camera = (OrthographicCamera) getStage().getCamera();
						anchorWindow.setScale(camera.zoom);
						getStage().addActor(anchorWindow);
						anchorWindow.setPosition(stageCoords.x, stageCoords.y);
						anchorWindow.setVisible(true);
						handled = true;
					} else {
						detectSelectedAnchor(stageCoords);
						handled = selectedAnchor != null;
					}
				}
				System.out.println("");
				lastClickDate = newClickDate;
				return handled;
			}
		};
		addListener(inputListener);
	}

	public void calculateAnchors() {
		if (subject != null && subject.getStage() != null) {
			Vector2 topCenter = new Vector2(subject.getX() + subject.getWidth() / 2,
					subject.getY() + subject.getHeight());
			Vector2 leftCenter = new Vector2(subject.getX(), subject.getY() + subject.getHeight() / 2f);
			Vector2 bottomCenter = new Vector2(subject.getX() + subject.getWidth() / 2, subject.getY());
			Vector2 rightCenter = new Vector2(subject.getX() + subject.getWidth(),
					subject.getY() + subject.getHeight() / 2);

			float stageHeight = subject.getStage().getHeight();
			float stageWidth = subject.getStage().getWidth();

			Vector2 top = new Vector2(topCenter.x, stageHeight);
			Vector2 left = new Vector2(0, leftCenter.y);
			Vector2 bottom = new Vector2(bottomCenter.x, 0);
			Vector2 right = new Vector2(stageWidth, rightCenter.y);
			
			leftAnchor.setV0(left);
			leftAnchor.setV1(leftCenter);

			bottomAnchor.setV0(bottom);
			bottomAnchor.setV1(bottomCenter);

			rightAnchor.setV0(right);
			rightAnchor.setV1(rightCenter);

			topAnchor.setV0(top);
			topAnchor.setV1(topCenter);
		}

	}

	@Override
	public void draw(Batch batch, float parentAlpha) {
		querySubject();
		if (subject != null) {
			DrawingHelper.drawCutLine(leftAnchor.getV0(), leftAnchor.getV1(), batch, Color.BLUE, 2);
			DrawingHelper.drawCutLine(bottomAnchor.getV0(), bottomAnchor.getV1(), batch, Color.BLUE, 2);
			DrawingHelper.drawCutLine(rightAnchor.getV0(), rightAnchor.getV1(), batch, Color.BLUE, 2);
			DrawingHelper.drawCutLine(topAnchor.getV0(), topAnchor.getV1(), batch, Color.BLUE, 2);

			float distance = leftAnchor.getLength() * scales[1];
			String value = String.valueOf(Math.round(distance * 1000));
			DrawingHelper.drawText(value, new Vector3(leftAnchor.getCenter(), 0), 0, Color.BLACK, 2, batch);
			distance = bottomAnchor.getLength() * scales[1];
			value = String.valueOf(Math.round(distance * 1000));
			DrawingHelper.drawText(value, new Vector3(bottomAnchor.getCenter(), 0), 0, Color.BLACK, 2, batch);
			distance = rightAnchor.getLength() * scales[1];
			value = String.valueOf(Math.round(distance * 1000));
			DrawingHelper.drawText(value, new Vector3(rightAnchor.getCenter(), 0), 0, Color.BLACK, 2, batch);
			distance = topAnchor.getLength() * scales[1];
			value = String.valueOf(Math.round(distance * 1000));
			DrawingHelper.drawText(value, new Vector3(topAnchor.getCenter(), 0), 0, Color.BLACK, 2, batch);
			if (selectedAnchor != null)
				DrawingHelper.drawLine(selectedAnchor.getV0(), selectedAnchor.getV1(), batch, Color.RED, 2);

		}
	}

	public void querySubject() {
		Object selection = GroupSelection.getInstance().getFirstElement();
		if (selection != null) {
			if (selection instanceof Object2D) {
				if (subject != selection) {
					subject = (Object2D) selection;
					SurfaceScreen screen = (SurfaceScreen) Scene.game.getScreen();
					scales = screen.getController().getScales();
				}
				calculateAnchors();
			}
		} else {
			subject = null;
		}
	}

	public void moveSubject(float amount) {
		if (selectedAnchor == leftAnchor) {
			subject.setX(amount / scales[0]);
		}
		if (selectedAnchor == rightAnchor) {
			subject.setX(getStage().getWidth() - subject.getWidth() - amount / scales[0]);
		}
		if (selectedAnchor == topAnchor) {
			subject.setY(getStage().getHeight() - subject.getHeight() - amount / scales[1]);
		}
		if (selectedAnchor == bottomAnchor) {
			subject.setY(amount / scales[1]);
		}
		if (subject.getWorldObject().isConstraint()) {
			SurfaceController controller = (SurfaceController) ((AbstractScreen) Scene.game.getScreen())
					.getController();
			Vector3 center = new Vector3(subject.getAbsoluteOrigin(), 0)
					.mul(controller.getSurface().getSurfaceToWorldTransform());
			ProjectManager.getManager().getCurrentScene().addConstraint(subject.getWorldObject(), center);
		}
	}

	public void detectSelectedAnchor(Vector2 point) {
		selectedAnchor = null;
		float t = MathUtilities.distance(new Vector3(point, 0), topAnchor);
		float l = MathUtilities.distance(new Vector3(point, 0), leftAnchor);
		float b = MathUtilities.distance(new Vector3(point, 0), bottomAnchor);
		float r = MathUtilities.distance(new Vector3(point, 0), rightAnchor);
		float shortestDistance = Math.min(Math.min(t, b), Math.min(l, r));
		if (shortestDistance < 10) {
			if (shortestDistance == t) {
				selectedAnchor = topAnchor;
			} else if (shortestDistance == b) {
				selectedAnchor = bottomAnchor;
			} else if (shortestDistance == l) {
				selectedAnchor = leftAnchor;
			} else {
				selectedAnchor = rightAnchor;
			}
		} else {
			selectedAnchor = null;
		}
	}

	public Object2D getSubject() {
		return subject;
	}

	public void setSubject(Object2D subject) {
		if (subject != this.subject) {
			this.subject = subject;
			calculateAnchors();
		}
	}

	public static OnSurfacePositioner getPositioner() {
		return positioner;
	}

	private void createAnchorWindow() {
		anchorWindow = new Window("", AssetsTextures.getInstance().getSkin());
		anchorWindow.setSize(200, 150);
		tf = new TextField("", AssetsTextures.getInstance().getSkin());
		if (selectedAnchor != null) {
			float distance = selectedAnchor.getLength() * scales[1];
			String value = String.valueOf(Math.round(distance * 1000));
			tf.setText(value);
		}

		TextButton tb = new TextButton("OK", AssetsTextures.getInstance().getSkin());
		tb.addListener(new ChangeListener() {

			@Override
			public void changed(ChangeEvent event, Actor actor) {
				try {
					String value = (String) tf.getText();
					moveSubject(Float.valueOf(value) * 0.001f);
				} catch (Exception e) {
					e.printStackTrace();
				} finally {
					anchorWindow.setVisible(false);
					tf.setText("");
					anchorWindow.remove();
				}
			}

		});
		Table content = new Table();
		content.add(tf);
		content.row();
		content.add(tb);
		anchorWindow.add(content);
		anchorWindow.setVisible(true);
		getStage().addActor(anchorWindow);

	}

}
