package gdxapp.screens.modelviewer;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Stage;

import dressing.cam.model.Direction;
import dressing.cam.model.Rainure;
import dressing.cam.model.Trou;
import dressing.cam.model.Usinage;
import dressing.cam.model.Util;
import dressing.events.Event;
import dressing.mathutils.CoordinateSystem;
import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.ui.ChangeCommandController;
import gdxapp.Commun.ScreenController;
import gdxapp.Commun.Tools3D;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.WorldObject;
import gdxapp.screens.room3d.CameraController;

public class ViewerController implements ScreenController{
	
	private PerspectiveCamera camera;
	private CameraController cameraController;
	private InputMultiplexer inputMultiplexer;
	private ModelBatch batch;
	private ModelBuilder modelBuilder;

	public ViewerController() {
		init();
	}
	
	public void init() {
		camera = new PerspectiveCamera(67,Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
		camera.up.set(Vector3.Y);
		camera.far = 100;
		camera.near = 0.5f;
		camera.position.set(-10,2,0);
		camera.lookAt(0,0,0);
		camera.update();
		cameraController = new CameraController(camera);
		inputMultiplexer = new InputMultiplexer();
		inputMultiplexer.addProcessor(cameraController);
		
		batch = new ModelBatch();
		modelBuilder = new ModelBuilder();
		
	}
	
	
	public void renderableChanged() {
		Object renderable = ViewerScreen.getScreen().getRenderable();
		if(renderable instanceof Piece2D) {
			ViewerScreen.getScreen().getInstances().clear();
			Piece2D piece = (Piece2D) renderable;
			Vector3 origin = new Vector3((float)piece.getXPosABS(),(float) piece.getYPosABS(),(float) piece.getZPosABS());
			//
			Gdx.app.postRunnable(new Runnable() {
				
				@Override
				public void run() {
					ViewerScreen.getScreen().getInstances().addAll(createPieceFrame(piece));
					
				}
			});
			List<Usinage> usinages = new ArrayList<Usinage>();
			for (DesignObject3D usinage : piece.getChilds()) {
				if(usinage instanceof Usinage)
					usinages.add((Usinage) usinage);
			}
			for(Usinage usinageX: usinages) {
				if(usinageX instanceof Trou) {
					Gdx.app.postRunnable(new Runnable() {

						@Override
						public void run() {
							// TODO Auto-generated method stub
							ModelInstance instance = createTrouInstance((Trou) usinageX,origin);
							ViewerScreen.getScreen().getInstances().add(instance);
						}
						
					});
					
				}if(usinageX instanceof Rainure) {
					Gdx.app.postRunnable(new Runnable() {

						@Override
						public void run() {
							// TODO Auto-generated method stub
							ModelInstance instance = createRainure((Rainure) usinageX);
							ViewerScreen.getScreen().getInstances().add(instance);
						}
						
					});
				}
			}
		}	
	}
	
	public ArrayList<ModelInstance> createPieceFrame(Piece2D piece) {
		ModelInstance instance = null;
		
		float longueur = (float) piece.getLongeurext()/100;
		float hauteur = (float) piece.getHauteurext()/100;
		float profondeur = (float) piece.getProfondeurext()/100;
		//calculer les position de piece2D par rapport a la rootCaisson qui le contenue dans plan absolue
		float x = (float) ( (piece.getXPosABS() + 0.5f * piece.getLongeurext()) * 0.01f);
		float y = (float) ( (piece.getYPosABS() + .5f * piece.getHauteurext()) * 0.01f);
		float z = (float) ( (piece.getZPosABS() + .5f * piece.getProfondeurext()) * 0.01f);
		
		Model model = modelBuilder.createBox(longueur, hauteur, profondeur, GL20.GL_LINES, 
				new Material(ColorAttribute.createDiffuse(new Color(164/256f,90/256f,82/256f,.5f))), VertexAttributes.Usage.Position);
		instance = new ModelInstance(model);
		instance.transform.setToTranslation(x,y,z);
		instance.calculateTransforms();
		
		ArrayList<ModelInstance> instances = new ArrayList<ModelInstance>();
		instances.add(instance);
		ArrayList<Vector3> corners = piece.getCornersList();
		
		for(Vector3 corner: corners) {
			Model modelSphere = modelBuilder.createSphere(0.05f, .05f, .05f, 20, 20,
					new Material(ColorAttribute.createDiffuse(Color.PURPLE)), VertexAttributes.Usage.Position);
			ModelInstance sphereInstance  = new ModelInstance(modelSphere);
			sphereInstance.transform.setToTranslation(corner.cpy().scl(.01f));
			instances.add(sphereInstance);
		}
		ArrayList<CoordinateSystem> systems = CoordinateSystem.getPieceCoordinateSytem(piece);//CoordinateSystem.getMachineCoordSystem(piece);
		for(CoordinateSystem system: systems) {
			instances.add(Tools3D.createCoordinateSystem(system));
		}
		return instances;
	}
	
	public ModelInstance createTrouInstance(Trou trou, Vector3 origin) {
		
		Material mat = new Material(ColorAttribute.createDiffuse(Color.YELLOW));
		int attr = VertexAttributes.Usage.Position | VertexAttributes.Usage.Normal;
		float width = (float) trou.getDiameter() * 0.01f;
		float height = (float) trou.getDepth() * 0.01f;
		Model model = modelBuilder.createCylinder(width, height, width, 20, mat, attr);
		
		Vector3 position = new Vector3();
		
		position.x = (float) trou.getXcenter() ;
		position.y = (float) trou.getYcenter() ;
		position.z = (float) trou.getZcenter() ;
		
		
		float halfDepth = (float) (0.5f * trou.getDepth());
		switch(trou.getDirection()) {
		case XMINUS:
			position.add(-halfDepth,0,0);
			break;
		case XPLUS:
			position.add((float) ( halfDepth),0,0);
			break;
		case YMINUS:
			position.add(0,(float) (- halfDepth),0);
			break;
		case YPLUS:
			position.add(0,halfDepth,0);
			break;
		case ZMINUS:
			position.add(0, 0, -halfDepth);
			break;
		case ZPLUS:
			position.add(0, 0, halfDepth);
			break;
		default:
			break;
		}
		position.add(origin).scl(.01f);
		ModelInstance instance = new ModelInstance(model);
		instance.transform.setToTranslation(position);
		if(trou.getDirection() == Direction.XMINUS || trou.getDirection() == Direction.XPLUS) {
			instance.transform.rotate(Vector3.X, 90).rotate(Vector3.Z, 90);
		}
		if(trou.getDirection() == Direction.ZMINUS || trou.getDirection() == Direction.ZPLUS) {
			instance.transform.rotate(Vector3.X, 90);
		}
		instance.calculateTransforms();
		
		return instance;
	}

	public ModelInstance createRainure(Rainure rainure) {
		
		ModelInstance instance = null;
		Vector3 position = new Vector3();
		Vector3 dimension = new Vector3();
		
		Vector3 axe = Util.getDesignAxe(rainure);
		axe.toString();
		dimension.x = (float) rainure.getLongeurext() * 0.01f;
		dimension.y = (float) rainure.getHauteurext() * 0.01f;
		dimension.z = (float) rainure.getProfondeurext() * 0.01f;
		
		position.x = (float) (rainure.getXPosABS() + .5f * rainure.getLongeurext())* 0.01f;
		position.y = (float) (rainure.getYPosABS() + .5f * rainure.getHauteurext()) * 0.01f;
		position.z = (float) (rainure.getZPosABS() + .5f * rainure.getProfondeurext())  * 0.01f;
		
		Model model = modelBuilder.createBox(dimension.x, dimension.y, dimension.z, 
				new Material(ColorAttribute.createDiffuse(Color.GREEN)), VertexAttributes.Usage.Position);
		
		instance = new ModelInstance(model);
		instance.transform.setToTranslation(position);
		
		return instance;
	}
	
	
	public PerspectiveCamera getCamera() {
		return camera;
	}

	public void setCamera(PerspectiveCamera camera) {
		this.camera = camera;
	}

	public CameraController getCameraController() {
		return cameraController;
	}

	public void setCameraController(CameraController cameraController) {
		this.cameraController = cameraController;
	}

	public InputMultiplexer getInputMultiplexer() {
		return inputMultiplexer;
	}

	public void setInputMultiplexer(InputMultiplexer inputMultiplexer) {
		this.inputMultiplexer = inputMultiplexer;
	}

	public ModelBatch getBatch() {
		return batch;
	}

	public void setBatch(ModelBatch batch) {
		this.batch = batch;
	}

	@Override
	public void dropActor(Object actor, float x, float y) {
		((WorldObject) actor).setSceneId(UUID.randomUUID());
		
	}

	@Override
	public void handle(Event event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void addActor(Object actor) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void removeActor(Object actor) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void rectifyPosition(Object object) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateWorldObject(Object object2d) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateObject(WorldObject object) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public Object getObject(WorldObject worldObject) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void reloadActors() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void reloadActor(WorldObject... worldObject) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public Stage getUIStage() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public float[] getScales() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ChangeCommandController getChangeCommandController() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void clear() {
		// TODO Auto-generated method stub
		
	}




	
	
}
