package gdxapp.screens.modelcreator;

import org.w3c.dom.views.AbstractView;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.utils.CameraInputController;
import com.badlogic.gdx.math.Vector3;

import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.ScreenController;

public class ModelCreatorScreen extends AbstractScreen {
	
	ModelCreatorScreenController controller;
	private static ModelCreatorScreen screen;
	
	private  ModelCreatorScreen() {
		init();
	}
	

	private void init() {
		
		controller = new ModelCreatorScreenController();
	}


	@Override
	public void show() {
		Gdx.input.setInputProcessor(controller.getCameraInputController());
	}

	@Override
	public void render(float delta) {
		 Gdx.gl20.glClearColor(255/255f, 255/255f,255/255f,1);
	     Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT | GL20.GL_DEPTH_BUFFER_BIT | (Gdx.graphics.getBufferFormat().coverageSampling ? GL20.GL_COVERAGE_BUFFER_BIT_NV : 0));
	     if(controller.getPreviewInstance() != null) {
	    	 controller.renderItemWithSpec(0.1f);
	     }
	}

	@Override
	public void resize(int width, int height) {
		// TODO Auto-generated method stub

	}

	@Override
	public void pause() {
		// TODO Auto-generated method stub

	}

	@Override
	public void resume() {
		// TODO Auto-generated method stub

	}

	@Override
	public void hide() {
		// TODO Auto-generated method stub

	}

	@Override
	public void dispose() {
		// TODO Auto-generated method stub

	}

	@Override
	public ScreenController getController() {
		return controller;
	}


	public static ModelCreatorScreen getScreen() {
		if(screen == null)
			screen = new ModelCreatorScreen();
		return screen;
	}


	@Override
	public Vector3 toWorldCoordiantes(Vector3 screenCoords) {
		// TODO Auto-generated method stub
		return null;
	}
	

}
