package gdxapp.scenes;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;

import com.badlogic.gdx.math.Vector3;

import dressing.config.UserPreference;
import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.ui.engine3d.SceneTexture;
import gdxapp.assets.AssetsTextures;
import gdxapp.object3d.DoorHandle;
import gdxapp.shaders.PbrMaterial;
import jakarta.xml.bind.annotation.XmlRootElement;
import supercad.provider.FacadeHandleProvider;


@XmlRootElement(name="ScenePreferences")
public  class ScenePreferences
 {
	
	@Inject
	private transient IEventBroker eventBroker;

	private PbrMaterial wallMtl;
	private PbrMaterial ceilingMaterial;
	
	private PbrMaterial facadeMtl;
	private PbrMaterial boxMtl;
	private PbrMaterial backMtl;
	
	
	//wall
	private float wallHeight = 2.5f;
	private float wallThickness = 0.1f;
	//plinth
	private float plinthHeight = 0.15f;
	private float plinthThickness = 0.02f;
	private Vector3 plinthColor = new Vector3(0.2f, 0.2f, 0.2f);   //dark gray by default
	//marble
	private float marbleThickness = 0.03f;
	private PbrMaterial marbleMtl;
	//floor
	private PbrMaterial floorMtl;
	private float floorThickness = 0.01f;
	//ceiling
	private float ceilingThickness = 0.25f;
	private int cameraSensitivity = 1;
	private DoorHandle doorHandle;
	
    private float WORLD_WIDTH = 12;
    private float WORLD_HEIGHT = 12;
	
	private float coinsSimpleFausseFacadeLegnth = 0.07f;

	transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

	private SceneTexture ceilingTexture;

	private SceneTexture facadeTexture;

	private SceneTexture BoxTexture;

	private SceneTexture BackTexture;

	
	public ScenePreferences() {
		super();
		if(UserPreference.getPreference().getScenePreferences() != null) {
			this.set(UserPreference.getPreference().getScenePreferences());
		}
	}

	
	public void set(ScenePreferences other) {
		//wall
		setWallMtl(other.getWallMtl());
		setWallHeight(other.getWallHeight());
		setWallThickness(other.getWallThickness());
		//floor
		setFloorMtl(other.getFloorMtl());
		setFloorThickness(other.getFloorThickness());
		//ceiling
		setCeilingMaterial(other.getCeilingMaterial());
		setCeilingThickness(other.getCeilingThickness());
		//plinth
		setPlinthColor(other.getPlinthColor());
		setPlinthThickness(other.getPlinthThickness());
		setPlinthHeight(other.getPlinthHeight());
		//marble
		setMarbleMtl(other.getMarbleMtl());
		setMarbleThickness(other.getMarbleThickness());
		//other
		setFacadeTexture(other.getFacadeTexture());
		setBoxTexture(other.getBoxTexture());
		setBackTexture(other.getBackTexture());
		setFacadeMtl(other.getFacadeMtl());
		setBoxMtl(other.getBoxMtl());
		setBackMtl(other.getBackMtl());
		setDoorHandle(other.getDoorHandle());
		setCoinsSimpleFausseFacadeLegnth(other.getCoinsSimpleFausseFacadeLegnth());
		setCameraSensitivity(other.getCameraSensitivity());
	}


	public PbrMaterial getWallMtl() {
		if(wallMtl == null)
			wallMtl = AssetsTextures.getInstance().getMaterial("Wall");
		return wallMtl;
	}


	public void setWallMtl(PbrMaterial wallMtl) {
		this.wallMtl = wallMtl;
		propertyChangeSupport.firePropertyChange("wall material", null, wallMtl);
		EventDriver.getDriver().deliverEvent(new Event(SceneEvent.WALL_MATERIAL_CHANGED.name(), wallMtl));
	}

	public SceneTexture getCeilingTexture() {
		return ceilingTexture;
	}
	public void setCeilingTexture(SceneTexture ceilingtexture) {
		this.ceilingTexture = ceilingtexture;
	}
	
	public SceneTexture getFacadeTexture() {
		return facadeTexture;
	}

	public void setFacadeTexture(SceneTexture facadeTexture) {
		this.facadeTexture = facadeTexture;
	}

	public SceneTexture getBoxTexture() {
		return BoxTexture;
	}

	public void setBoxTexture(SceneTexture boxTexture) {
		BoxTexture = boxTexture;
	}

	public float getWallHeight() {
		return wallHeight;
	}

	public void setWallHeight(float wallHeight) {
		float oldValue = this.wallHeight;
		this.wallHeight = wallHeight;
		firePropertyChange("wallHeight", oldValue, this.wallHeight);
	}
	
	public float getWallThickness() {
		return wallThickness;
	}

	public void setWallThickness(float wallThickness) {
		float oldValue = this.wallThickness;
		this.wallThickness = wallThickness;
		firePropertyChange("wallThickness", oldValue, this.wallThickness);
	}

	public float getCoinsSimpleFausseFacadeLegnth() {
		return coinsSimpleFausseFacadeLegnth;
	}

	public void setCoinsSimpleFausseFacadeLegnth(float coinsSimpleFausseFacadeLegnth) {
		this.coinsSimpleFausseFacadeLegnth = coinsSimpleFausseFacadeLegnth;
	}


	public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
		if(this.propertyChangeSupport == null)
			propertyChangeSupport = new PropertyChangeSupport(this);
		this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
	}
	public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
		this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
	}
	
	protected void firePropertyChange(String propertyName, Object oldValue,
			Object newValue) {
			propertyChangeSupport.firePropertyChange(propertyName, oldValue,
					newValue);			
	}
	
	public ScenePreferences clone() {
		ScenePreferences preferences =new ScenePreferences();
		preferences.set(this);
		return preferences;
	}


	

	public DoorHandle getDoorHandle() {
		if(doorHandle == null)
			doorHandle = FacadeHandleProvider.getInstance().getHandlers().get(0).cpy();
		return doorHandle;
	}

	public void setDoorHandle(DoorHandle doorHandle) {
		if(this.doorHandle == null || !this.doorHandle.equals(doorHandle)) {
			DoorHandle oldvalue=this.doorHandle;
			this.doorHandle = doorHandle;
			propertyChangeSupport.firePropertyChange("handle", oldvalue, doorHandle);
		}
	}

	public PbrMaterial getFloorMtl() {
		return floorMtl;
	}

	public void setFloorMtl(PbrMaterial floorMtl) {
		PbrMaterial oldvalue=this.floorMtl;
		this.floorMtl = floorMtl;
		propertyChangeSupport.firePropertyChange("floor mtl", oldvalue, floorMtl);
		EventDriver.getDriver().deliverEvent(new Event(SceneEvent.WALL_MATERIAL_CHANGED.name(), floorMtl));
	}


	public PbrMaterial getMarbleMtl() {
		return marbleMtl;
	}


	public void setMarbleMtl(PbrMaterial marbleMtl) {
		this.marbleMtl = marbleMtl;
	}


	public SceneTexture getBackTexture() {
		return BackTexture;
	}


	public void setBackTexture(SceneTexture backTexture) {
		BackTexture = backTexture;
	}


	public PbrMaterial getFacadeMtl() {
		return facadeMtl;
	}


	public void setFacadeMtl(PbrMaterial facadeMtl) {
		this.facadeMtl = facadeMtl;
		propertyChangeSupport.firePropertyChange("facade mtl", null, facadeMtl);

	}


	public PbrMaterial getBoxMtl() {
		return boxMtl;
	}

	public void setBoxMtl(PbrMaterial boxMtl) {
		this.boxMtl = boxMtl;
		propertyChangeSupport.firePropertyChange("box mtl", null, boxMtl);
	}


	public PbrMaterial getBackMtl() {
		return backMtl;
	}


	public void setBackMtl(PbrMaterial backMtl) {
		this.backMtl = backMtl;
		propertyChangeSupport.firePropertyChange("back mtl", null,backMtl);
	}
	
	

	public float getPlinthHeight() {
		return plinthHeight;
	}


	public void setPlinthHeight(float plinthHeight) {
		this.plinthHeight = plinthHeight;
	}
	
	public int getCameraSensitivity() {
		return cameraSensitivity;
	}
	


	public void setCameraSensitivity(int cameraSensitivity) {
		this.cameraSensitivity = cameraSensitivity;
	}


	public void initAfterRead() {
		this.propertyChangeSupport = new PropertyChangeSupport(this);
	}
	
	
	public void dispose() {
		for(PropertyChangeListener listener: this.propertyChangeSupport.getPropertyChangeListeners()) {
			this.propertyChangeSupport.removePropertyChangeListener(listener);
		}
		this.propertyChangeSupport = null;
	}


	public float getCeilingThickness() {
		return ceilingThickness;
	}


	public void setCeilingThickness(float ceilingThickness) {
		this.ceilingThickness = ceilingThickness;
	}


	public float getWORLD_WIDTH() {
		return WORLD_WIDTH;
	}


	public void setWORLD_WIDTH(float wORLD_WIDTH) {
		WORLD_WIDTH = wORLD_WIDTH;
	}


	public float getWORLD_HEIGHT() {
		return WORLD_HEIGHT;
	}


	public void setWORLD_HEIGHT(float wORLD_HEIGHT) {
		WORLD_HEIGHT = wORLD_HEIGHT;
	}


	public float getMarbleThickness() {
		return marbleThickness;
	}


	public void setMarbleThickness(float marbleThickness) {
		this.marbleThickness = marbleThickness;
	}


	public PbrMaterial getCeilingMaterial() {
		return ceilingMaterial;
	}


	public void setCeilingMaterial(PbrMaterial ceilingMaterial) {
		this.ceilingMaterial = ceilingMaterial;
	}


	public float getPlinthThickness() {
		return plinthThickness;
	}


	public void setPlinthThickness(float plinthThickness) {
		this.plinthThickness = plinthThickness;
	}


	public Vector3 getPlinthColor() {
		return plinthColor;
	}


	public void setPlinthColor(Vector3 plinthColor) {
		this.plinthColor = plinthColor;
	}


	public float getFloorThickness() {
		return floorThickness;
	}

	public void setFloorThickness(float floorThickness) {
		this.floorThickness = floorThickness;
	}

}
