package gdxapp.Commun;

import com.badlogic.gdx.scenes.scene2d.Stage;

import dressing.events.Event;
import dressing.events.EventHandler;
import dressing.ui.ChangeCommandController;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.WorldObject;

public interface ScreenController<T> extends EventHandler {

	void dropActor(Object actor, float x, float y);

	void addActor(Object actor);

	void removeActor(Object actor);

	void rectifyPosition(T object); 

	//ascending modification
	void updateWorldObject(T object2D);

	//descending modification
	void updateObject(WorldObject object);

	T getObject(WorldObject worldObject);

	void reloadActors();
	
	void reloadActor(WorldObject... worldObject);

	Stage getUIStage();
	
	default Stage getStage() {
		return null;
	}

	float[] getScales();

	ChangeCommandController getChangeCommandController();

	void clear();
}