package dressing.ui.util;

import org.eclipse.swt.widgets.Shell;

import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.math.Vector2;
import dressing.mathutils.Edge;
import dressing.model.ProjectManager;
import dressing.ui.CommandStack;
import dressing.ui.parts.GdxPart;
import gdxapp.Commun.AbstractScreen;
import gdxapp.assets.AssetsTextures;
import gdxapp.object3d.Wall;
import gdxapp.scenes.Scene;
import gdxapp.screens.room.RoomController;
import gdxapp.screens.wall.WallFragment;
import geometry.CompoundShape;
import geometry.Polygon;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import java.util.ArrayList;
import java.util.Optional;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.wb.swt.ResourceManager;

public class EdgeConfigWindow extends org.eclipse.jface.window.Window {

	public Shell shell;
	public Action runAction;
	private Wall wall;
	private Edge edge;
	private Spinner spnLength, spnHeight, spnThickness;
	ArrayList<Edge> edges;
	CompoundShape compoundShape;
	boolean isFirstEdge;
	boolean isLastEdge;
	int index;

	public EdgeConfigWindow(Shell parentShell, Edge edge, Wall wall) {
		super(parentShell);
		setShellStyle(SWT.SHELL_TRIM | SWT.APPLICATION_MODAL);
		setBlockOnOpen(true);
		this.wall = wall;
		create();
		constrainShellSize();
		setEdge(edge);
	}

	public Action getRunAction() {
		return runAction;
	}

	public void setRunAction(Action runAction) {
		this.runAction = runAction;
	}

	/**
	 * Create contents of the window.
	 * 
	 * @return
	 */
	protected Control createContents(Composite parent) {
		parent.setTouchEnabled(true);
		this.shell = parent.getShell();
		parent.getShell().setText("Mesure");
		shell.addShellListener(getShellListener());

		Composite composite = new Composite(parent, SWT.FILL);
		composite.setTouchEnabled(true);
		composite.setLayout(new GridLayout(1, false));

		Composite composite_1 = new Composite(composite, SWT.FILL);
		GridData gd_composite_1 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_composite_1.widthHint = 289;
		gd_composite_1.heightHint = 171;
		composite_1.setLayoutData(gd_composite_1);
		composite_1.setLayout(new GridLayout(2, false));

		Label lblLongeur = new Label(composite_1, SWT.NONE);
		lblLongeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblLongeur.setText("Longeur");

		spnLength = new Spinner(composite_1, SWT.BORDER);
		GridData gd_spnLength = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_spnLength.widthHint = 173;
		spnLength.setLayoutData(gd_spnLength);
		spnLength.setMaximum(100000000);

		if (wall != null) {
			Label lblHauteur = new Label(composite_1, SWT.NONE);
			lblHauteur.setText("Hauteur");

			spnHeight = new Spinner(composite_1, SWT.BORDER);
			spnHeight.setMaximum(10000);
			spnHeight.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));

			Label lblEpaisseur = new Label(composite_1, SWT.NONE);
			lblEpaisseur.setText("Epaisseur");

			spnThickness = new Spinner(composite_1, SWT.BORDER);
			spnThickness.setMaximum(10000);
			spnThickness.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		}

		Composite composite_2 = new Composite(composite, SWT.NONE);
		GridData gd_composite_2 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_composite_2.heightHint = 39;
		composite_2.setLayoutData(gd_composite_2);
		GridLayout gl_composite_2 = new GridLayout(2, false);
		gl_composite_2.horizontalSpacing = 0;
		composite_2.setLayout(gl_composite_2);

		Button btnRun = new Button(composite_2, SWT.NONE);
		btnRun.setImage(ResourceManager.getPluginImage("Dressing", "icons/Calculer.png"));
		GridData gd_btnRun = new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1);
		gd_btnRun.heightHint = 31;
		btnRun.setLayoutData(gd_btnRun);
		if (runAction != null) {
			btnRun.setText(runAction.getText());
		} else {
			btnRun.setText("Terminer");
		}
		Button btnFermer = new Button(composite_2, SWT.NONE);
		GridData gd_btnFermer = new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1);
		gd_btnFermer.heightHint = 31;
		btnFermer.setLayoutData(gd_btnFermer);
		btnFermer.setText("Fermer");
		composite.setTabList(new Control[] { composite_1, composite_2 });
		
		btnFermer.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				EdgeConfigWindow.this.close();
			}
		});
		
		btnRun.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				float l = EdgeConfigWindow.this.spnLength.getSelection();
				l *= RoomController.getInstance().getScaleX();
				l /= 1000;
				if (compoundShape != null && compoundShape.isClosed()) {
					int mode = 1;
					if (isFirstEdge)
						mode = -1;
					edge.setLength(l, mode);
				} else {
					if (!isFirstEdge && !isLastEdge) {
						if (edges != null) {
							Vector2 translation = edge.getDirector().nor().scl(l - edge.getLength());
							for (int i = index + 1; i < edges.size(); i++) {
								edges.get(i).getV0().add(translation);
								if (i == edges.size() - 1 && !edges.get(i).getV1().equals(edges.get(0).getV0())) {
									edges.get(i).getV1().add(translation);
								}
							}
						}
					} else {
						int mode = 1;
						if (isFirstEdge || edge.getV1().equals(edges.get(0).getV0()))
							mode = -1;
						edge.setLength(l, mode);
					}
				}
				if (wall != null) {
					float h = EdgeConfigWindow.this.spnHeight.getSelection() /1000.0f;
					float t = EdgeConfigWindow.this.spnThickness.getSelection() / 1000.0f;
					
					
					
					ProjectManager.getManager().getCurrentScene().insertWallFragment(edge, h, t, wall.getMaterial());
				}
				close();
			}
		});
		return composite;
	}

	public Edge getEdge() {
		return edge;
	}

	public void setEdge(Edge edge) {
		this.edge = edge;
		if (edge != null) {
			float l = this.edge.getLength();
			this.spnLength.setSelection((int) ((l * 1000) / RoomController.getInstance().getScaleX()));
			if (wall == null)
				return;
			Optional<WallFragment> fragment = ProjectManager.getManager().getCurrentScene().findFragment(edge);
			if (fragment.isPresent()) {
				this.spnHeight.setSelection((int) (fragment.get().getHeight() * 1000));
				this.spnThickness.setSelection((int) (fragment.get().getThickness() * 1000));
			} else {
				this.spnHeight.setSelection((int) (wall.getHeight() * 1000));
				this.spnThickness.setSelection((int) (wall.getThickness() * 1000));
			}
			isFirstEdge = false;
			isLastEdge = false;
			this.edges = null;
		}
	}

	public CompoundShape getCompoundShape() {
		return compoundShape;
	}

	public void setCompoundShape(CompoundShape compoundShape) {
		this.compoundShape = compoundShape;
		this.edges = compoundShape.getEdges();
		index = -1;
		for (int i = 0; i < this.edges.size(); i++) {
			if (this.edges.get(i).equals(this.edge)) {
				index = i;
				break;
			}
		}
		if (index == 0) {
			isFirstEdge = true;
		}
		if (index == compoundShape.getEdges().size() - 1) {
			isLastEdge = true;
		}
	}

	public ArrayList<Edge> getEdges() {
		return edges;
	}

	public void setEdges(ArrayList<Edge> edges) {
		this.edges = edges;
		index = -1;
		for (int i = 0; i < edges.size(); i++) {
			if (edges.get(i).equals(this.edge)) {
				index = i;
				break;
			}
		}
		if (index == 0) {
			isFirstEdge = true;
		}
		if (index == edges.size() - 1) {
			isLastEdge = true;
		}
	}

	public Wall getWall() {
		return wall;
	}

	public void setWall(Wall wall) {
		this.wall = wall;
	}

}
