package dressing.ui.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import com.badlogic.gdx.math.Vector3;

import dressing.model.LibraryInfo;
import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import dressing.ui.shapedrawer.FinalPage;
import gdxapp.object3d.GeometryObject;
import geometry.CompoundObject;

public class MarbreConfigWizardFormPage extends WizardPage implements PropertyChangeListener , FinalPage {
	
	private GeometricObjectSettingComposite composite;
	private String description;
	private GeometryObject worldobject;
	

	
	public GeometricObjectSettingComposite getComposite() {
		return composite;
	}

	public void setComposite(GeometricObjectSettingComposite composite) {
		this.composite = composite;
	}

	protected MarbreConfigWizardFormPage(String title, CompoundObject geometry) {
		super("");
		setTitle("Créer un Plan de Travail");
		if(geometry != null) {
			this.worldobject = new GeometryObject();
			var pref = ProjectManager.getManager().getCurrentScene().getPreferences();
			geometry.getBorder().setMaterial(ProjectManager.getManager().getCurrentScene().getPreferences().getMarbleMtl());
			float thickness = pref.getMarbleThickness();
			this.worldobject.setRealWorldDimension(geometry.getRealWorldDimension(thickness));
			float elevation = LibraryInfo.getInstance().getBaseCabinetDefaultHeight();
			elevation += pref.getPlinthHeight() + thickness/2.0f;
			this.worldobject.setRealWorldPosition(new Vector3(0, elevation,0));
			this.worldobject.setGeometry(geometry);
			this.worldobject.addPropertyChangeListener(this);
			this.worldobject.setUserData("MARBLE");
		}
		
	}

	@Override
	public void createControl(Composite parent) {
		composite = new GeometricObjectSettingComposite(parent, SWT.EMBEDDED,(GeometryObject) worldobject,ModelProvider.getMaterialsByCategory(CATEGORY.MARBLE));
		composite.addPropertyChangeListener((event) -> {
			getWizard().getContainer().updateButtons();
		});
		setControl(composite);
	}
	public void clearlistners() {
		if(worldobject != null)
			worldobject.removePropertyChangeListener(this);
	}

	@Override
	public boolean isPageComplete() {
		return composite.hasValidInput();
		
	}

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		if(isCurrentPage())
		{
			if (MarbreConfigWizardFormPage.this != null) {
				setPageComplete(isPageComplete());
				if (getWizard().getContainer() != null)
					getContainer().updateButtons();
			}
		}
	}

	@Override
	public void onHide() {
		composite.apply();
		clearlistners();	
		if(worldobject != null)
			ProjectManager.getManager().getCurrentScene().addActor(worldobject, true);
	}
	@Override
	public IWizardPage getNextPage() {
		if(this.worldobject == null)
			return super.getNextPage();
		return null;
	}

	@Override
	public IWizardPage getPreviousPage() {
		if(this.worldobject == null)
			return super.getPreviousPage();
		return getWizard().getStartingPage();
	}

}

