package dressing.ui.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import com.badlogic.gdx.math.Vector3;

import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import dressing.ui.shapedrawer.FinalPage;
import gdxapp.object3d.GeometryObject;
import gdxapp.scenes.ScenePreferences;
import geometry.CompoundObject;

public class CeilingConfigWizardPage extends WizardPage  implements PropertyChangeListener , FinalPage {

	protected CeilingConfigWizardPage(CompoundObject geometry) {
		super("Créer un Plafond");
		this.geometry = geometry;
		createGeometricObject();

	}

	private GeometricObjectSettingComposite ceilingConfigComposite;
	private CompoundObject geometry;
	private GeometryObject geometricObject;

	@Override
	public void createControl(Composite parent) {
		ceilingConfigComposite = new GeometricObjectSettingComposite(parent, SWT.EMBEDDED, geometricObject, ModelProvider.getMaterialsByCategory(CATEGORY.CEILING));
		ceilingConfigComposite.addPropertyChangeListener((event) -> {
			getWizard().getContainer().updateButtons();
		});
		setControl(ceilingConfigComposite);
	}
	
	private void createGeometricObject() {
		var preferences = ProjectManager.getInstance().getCurrentScene().getPreferences();
		float thickness = preferences.getCeilingThickness();
		float height = preferences.getWallHeight() - thickness/2.0f;
		geometry.getBorder().setMaterial(preferences.getCeilingMaterial().cpy());
		this.geometricObject = new GeometryObject(geometry);
		this.geometricObject.setRealWorldDimension(geometry.getRealWorldDimension(thickness));
		this.geometricObject.setRealWorldPosition(new Vector3(0, height, 0));
		this.geometricObject.addPropertyChangeListener(this);
		this.geometricObject.setUserData("CEILING");
	}
	
	
	@Override
	public boolean isPageComplete() {
		return ceilingConfigComposite.hasValidInput();		
	}

	@Override
	public void onHide() {
		ceilingConfigComposite.apply();		
		geometricObject.removePropertyChangeListener(this);
		ProjectManager.getManager().getCurrentScene().addActor(geometricObject, true);
	}

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		if(isCurrentPage())
		{
			setPageComplete(isPageComplete());
			if (getWizard().getContainer() != null)
				getContainer().updateButtons();
		}
	}
	
	@Override
	public IWizardPage getNextPage() {
		return null;
	}

	@Override
	public IWizardPage getPreviousPage() {
		if(getWizard() == null)
			return null;
		return getWizard().getStartingPage();
	}

}
