package dressing.ui.editorWindows;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import dressing.config.WorkspaceConfiguration;
import dressing.config.persistence.ResourceManagers;
import dressing.model.MechanicDesignCreator;
import dressing.ui.DoubleTextFieldFactory;
import dressing.ui.util.DoubleToStringConvertor;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.ImageChooserDialog;
import dressing.ui.util.ImageLoaderCache;
import param.Accessoire;
import param.Article;
import param.ArticleFamily;
import param.ArticleFamilyGroup;
import param.ParamFactory;
import param.Quincaillerie;
import param.URL;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.wb.swt.SWTResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.beans.typed.PojoProperties;

import dressing.ui.util.NumericConvertor;
import org.eclipse.jface.viewers.ColumnLabelProvider;

public class ArticleEditorWindow extends dressing.ui.util.EditorWindow {

	private DataBindingContext m_bindingContext;

	private ScrolledComposite container;
	private Composite root;

	private Text txtName;
	private Text txtCode;
	private Text txtPrice;
	
	private CLabel lblImage;
	private Label lblUrls;
	private Button btnChooseImage;

	private Article article;
	private Article articleOrigin;

	private Composite composite;
	private Table table;
	private TableViewer tableViewer;

	private ComboViewer comboViewerParentFamily;

	private Button btnDelete;

	private Button btnAddURL;

	private Button btnModify;
	private Label labelImage;
	public ArticleEditorWindow(Shell parentShell,int update,Article article) {
		super(parentShell,update);
		this.article = article;
		this.articleOrigin=EcoreUtil.copy(article);
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		
		container = new ScrolledComposite(parent, SWT.V_SCROLL);
		container.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		container.setExpandHorizontal(true);
		container.setExpandVertical(true);
		
		root = new Composite(container, SWT.NONE);
		root.setLayout(new GridLayout(4, false));
		
		labelImage = new Label(root, SWT.BORDER | SWT.WRAP);
		GridData gd_labelImage = new GridData(SWT.FILL, SWT.FILL, false, false, 1, 8);
		gd_labelImage.heightHint = 200;
		gd_labelImage.widthHint = 200;
		labelImage.setLayoutData(gd_labelImage);
		
		Label lblNom = new Label(root, SWT.NONE);
		lblNom.setText("Nom");
		
		txtName = new Text(root, SWT.BORDER);
		GridData gd_txtName = new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1);
		gd_txtName.minimumWidth = 300;
		txtName.setLayoutData(gd_txtName);
		
		Label lblCode = new Label(root, SWT.NONE);
		lblCode.setText("Code");
		
		txtCode = new Text(root, SWT.BORDER);
		txtCode.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		Label lblTelephone = new Label(root, SWT.NONE);
		lblTelephone.setText("Prix");
		
		txtPrice = DoubleTextFieldFactory.createDoubleTextField(root, SWT.BORDER);
		txtPrice.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		Label lblfamille = new Label(root, SWT.NONE);
		lblfamille.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblfamille.setText("Famille");
		
		comboViewerParentFamily = new ComboViewer(root, SWT.READ_ONLY);
		Combo combo = comboViewerParentFamily.getCombo();
		combo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		Label lblEmail = new Label(root, SWT.NONE);
		lblEmail.setText("Image");
		
		lblImage = new CLabel(root, SWT.NONE);
		lblImage.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		lblImage.setText("");
		
		btnChooseImage = new Button(root, SWT.NONE);
		btnChooseImage.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnChooseImage.setText("...");
		
		lblUrls = new Label(root, SWT.NONE);
		lblUrls.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, false, 1, 1));
		lblUrls.setText("Urls");
		
		composite = new Composite(root, SWT.NONE);
		composite.setLayout(new FillLayout(SWT.HORIZONTAL));
		GridData gd_composite = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 4);
		gd_composite.widthHint = 444;
		composite.setLayoutData(gd_composite);
		
		tableViewer = new TableViewer(composite, SWT.BORDER | SWT.FULL_SELECTION);
		table = tableViewer.getTable();
		table.setFont(SWTResourceManager.getFont("Segoe UI", 9, SWT.NORMAL));
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		
		TableViewerColumn tableViewerColumnNom = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerColumnNom.setLabelProvider(new ColumnLabelProvider() {
			public Image getImage(Object element) {
				// TODO Auto-generated method stub
				return null;
			}
			public String getText(Object element) {
				// TODO Auto-generated method stub
				return element == null ? "" : (element instanceof URL?((URL)element).getName():element.toString());
			}
		});
		TableColumn tblclmnNom = tableViewerColumnNom.getColumn();
		tblclmnNom.setMoveable(true);
		tblclmnNom.setWidth(100);
		tblclmnNom.setText("Nom");
		
		TableViewerColumn tableViewerColumnAdresse = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerColumnAdresse.setLabelProvider(new ColumnLabelProvider() {
			public Image getImage(Object element) {
				// TODO Auto-generated method stub
				return null;
			}
			public String getText(Object element) {
				// TODO Auto-generated method stub
				return element == null ? "" : (element instanceof URL?((URL)element).getPath():element.toString());
			}
		});
		
		TableColumn tblclmnAdresse = tableViewerColumnAdresse.getColumn();
		tblclmnAdresse.setWidth(359);
		tblclmnAdresse.setText("Adresse");
		tableViewer.setContentProvider(ArrayContentProvider.getInstance());
		
		btnAddURL = new Button(root, SWT.NONE);
		btnAddURL.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		btnAddURL.setText("Ajouter");
		new Label(root, SWT.NONE);
		
		btnModify = new Button(root, SWT.NONE);
		btnModify.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		btnModify.setText("Modifier");
		new Label(root, SWT.NONE);
		
		btnDelete = new Button(root, SWT.NONE);
		btnDelete.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		btnDelete.setText("Supprimer");
		new Label(root, SWT.NONE);
		new Label(root, SWT.NONE);
		new Label(root, SWT.NONE);
		comboViewerParentFamily.setLabelProvider(new LabelProvider() {
			
			@Override
			public String getText(Object element) {
				if(element instanceof ArticleFamily) {
					ArticleFamily family =(ArticleFamily)element;
					String name=family.getName();
					while(family.getParentFamily()!=null) {
						
						family =family.getParentFamily();
						 name=family.getName()+"\\"+name;
					}
					return name;
				}
				
				return super.getText(element);
			}
		});
		comboViewerParentFamily.setContentProvider(new IStructuredContentProvider() {
			
			@Override
			public Object[] getElements(Object inputElement) {
				List<ArticleFamily> families = new ArrayList<ArticleFamily>();
				if (inputElement instanceof ArticleFamilyGroup) {
					ArticleFamilyGroup familyGroup = (ArticleFamilyGroup) inputElement;
					for (ArticleFamily family : familyGroup.getFamilles()) {
						families.add(family);
						getfamilies(family, families);
					}
				}
				return families.toArray();
			}

			private void getfamilies(ArticleFamily family,List<ArticleFamily> families) {
				for(ArticleFamily subfamily:family.getFamilies()) {
					families.add(subfamily);
					getfamilies(subfamily,families);
				}
			}
		});
		comboViewerParentFamily.setInput(ResourceManagers.getIntance().getApplication().getArticleFamilies());

		container.setContent(root);
		container.setMinSize(root.computeSize(SWT.DEFAULT, SWT.DEFAULT));

		String titleWindow = "d'Accessoire";
		if(this.article instanceof Accessoire) {
			titleWindow="Accessoire";
		}
		if(this.article instanceof Quincaillerie) {
			titleWindow="du Quincaillerie";
		}


		this.shell.setText("Editeur " + titleWindow);
		parent.requestLayout();
		ControlAdapter adaptor=new ControlAdapter() {

			@Override
			public void controlResized(ControlEvent e) {
				 Rectangle area2= ArticleEditorWindow.this.getShell().getClientArea();
				 container.setBounds(area2);
			}
			
		};
		parent.addControlListener(adaptor);
		root.addControlListener(adaptor);
		getShell().addControlListener(adaptor);
		parent.requestLayout();
		m_bindingContext = initDataBindings();
		ArticleFamily family = null;
		if (this.article instanceof Accessoire) {
			family = ((Accessoire) this.article).getParentFamily();
		}
		if (this.article instanceof Quincaillerie) {
			family = ((Quincaillerie) this.article).getParentFamily();
		}
		if (family != null) {
			comboViewerParentFamily.setSelection(new StructuredSelection(family));
		}
		if (article.getImage()!=null && article.getImage().getPath() != null && !article.getImage().getPath().isEmpty()) {
			String imagePath = article.getImage().getPath();
			if (!ImageLoaderCache.isValidImagePath(imagePath)) {
				imagePath = article.getImage().getOriginalPath();
				if (!ImageLoaderCache.isValidImagePath(imagePath)) {
					imagePath = null;
				}
			}
			// Dispose the previous preview image
			Image old = labelImage.getImage();
			if (old != null && !old.isDisposed()) {
				old.dispose();
			}
			if (imagePath != null) {
				Image newImage = ImageLoaderCache.getInstance().loadImage(imagePath, 200, 200,false);
				labelImage.setImage(newImage);
			} else {
				// Create a new Image with the desired dimensions
				Image image = new Image(Display.getCurrent(), 200, 200);

				// Create a GC (Graphics Context) to draw on the image
				GC gc = new GC(image);

				// Set the background color of the image
				Color backgroundColor = Display.getCurrent().getSystemColor(SWT.COLOR_TRANSPARENT);
				gc.setBackground(backgroundColor);

				// Fill the entire image with the background color
				gc.fillRectangle(0, 0, 200, 200);
				gc.dispose();

				labelImage.setImage(image);
			}
		}

		addControl(); 
		return container;
	}
	public void addControl() {
		btnAddURL.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				URL url = ParamFactory.eINSTANCE.createURL();
				UrlEditorWindow window = new UrlEditorWindow(getShell(), MechanicDesignCreator.create,
						url);
				int returnCode = window.open();
				if (returnCode == Window.OK) {
					article.getUrls().add(url);
					tableViewer.refresh();
				}
			}
		});
		btnModify.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				URL url = (URL) tableViewer.getStructuredSelection().getFirstElement();
				if(url!=null) {
					UrlEditorWindow window = new UrlEditorWindow(getShell(), MechanicDesignCreator.update,url);
					int returnCode = window.open();
					if (returnCode == Window.OK) {
						tableViewer.refresh();
					}
				}
				
			}
		});
		btnDelete.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				URL url = (URL) tableViewer.getStructuredSelection().getFirstElement();
				if(url!=null) {
					boolean confirm=MessageDialog.openConfirm(getShell(), "Supprimer URL", "voulez vous suupprimer l'url "+url.getName()+":"+url.getPath());
					if (confirm) {
						article.getUrls().remove(url);
						tableViewer.refresh();
					}
				}
				
			}
		});
		btnChooseImage.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				ImageChooserDialog chooserDialog= new ImageChooserDialog(root.getShell(),lblImage.getText());
				chooserDialog.setLocalPath(WorkspaceConfiguration.getAccessoireImagesPath());
				
				int chooseImage=chooserDialog.open();
				if(chooseImage==Window.OK) {
					String imageOriginalPath=chooserDialog.getImageUri();
					if(article.getImage().getOriginalPath()==null||!imageOriginalPath.contentEquals(article.getImage().getOriginalPath())) {
						lblImage.setText(imageOriginalPath);
						Image img=null;
						String imgName=null;
						if(ImageLoaderCache.isValidImagePath(imageOriginalPath))
						{
							img=ImageLoaderCache.createImageFromPathOrUrl(imageOriginalPath);
							File imgfile=new File(imageOriginalPath);
							imgName=imgfile.getName();
						
						}else if(ImageLoaderCache.isValidImageUrl(imageOriginalPath))
						{
							img=ImageLoaderCache.createImageFromPathOrUrl(imageOriginalPath);
							imgName=ImageLoaderCache.getImageNameFromURL(imageOriginalPath);
							
						}
						if(img!=null && imgName!=null && !imgName.isEmpty()) {
							String imagePath=WorkspaceConfiguration.getAccessoireImagesPath()+File.separator+imgName;
							ImageLoaderCache.getInstance().saveImageToFile(img, imagePath);
							article.getImage().setName(imgName);
							article.getImage().setOriginalPath(imageOriginalPath);
							article.getImage().setPath(imagePath);
							// Dispose the previous preview image
							Image old = labelImage.getImage();
							if (old != null && !old.isDisposed()) {
								old.dispose();
							}
							labelImage.setImage(ImageLoaderCache.getInstance().loadImage(imagePath, 200, 200,false));
						}else {
							MessageDialog.openError(root.getShell(), "Erreur", "Le fichier choisi est une image invalide.");
						}
						img.dispose();

					}
									
				}
			}
		});
		labelImage.addDisposeListener(e -> {
			Image img = labelImage.getImage();
			if (img != null && !img.isDisposed()) {
				img.dispose();
			}
		});
	}
	@Override
	public boolean terminer() {
		if(!super.terminer()) {
			return false;
		}
		if(this.article instanceof Accessoire) {
			((Accessoire) this.article).setParentFamily((ArticleFamily) comboViewerParentFamily.getStructuredSelection().getFirstElement());
			if(getUpdateMode()==EditorWindow.create) {
				ResourceManagers.getIntance().getAccessoireGroup().getAccessoires().add((Accessoire) this.article);
				
			}
		}
		if(this.article instanceof Quincaillerie) {
			((Quincaillerie) this.article).setParentFamily((ArticleFamily) comboViewerParentFamily.getStructuredSelection().getFirstElement());
			if(getUpdateMode()==EditorWindow.create) {
				ResourceManagers.getIntance().getQuincailleriesGroup().getQuincailleries().add((Quincaillerie) this.article);
			}
		}
		ResourceManagers.getIntance().saveLibraryResource();
		labelImage.getImage().dispose();
		finish();
		return true;
	}
	
	@Override
	public boolean check() {
		errorExist=false;
		errorMessage="";
		String name =txtName.getText().trim();
		if(name==null || name.isEmpty()) {
			errorExist=true;
			errorMessage="Le nom est obligatoire";
		}
		String priceS=txtPrice.getText();
		try {
			Double priceD =Double.valueOf(priceS);
			if(priceD<=0) {
				errorExist=true;
				errorMessage="Le prix doit être supérieur à 0";
			}
		} catch (Exception e) {
			errorExist=true;
			errorMessage="Le prix est obligatoire";
		}
		Object family = comboViewerParentFamily.getStructuredSelection().getFirstElement();
		if(family==null || !(family instanceof ArticleFamily)){
			errorExist=true;
			errorMessage="Le famille Article est obligatoire";
		}
		return !errorExist;
	}
	public ScrolledComposite getContainer() {
		return container;
	}

	public void setContainer(ScrolledComposite container) {
		this.container = container;
	}

	public Composite getRoot() {
		return root;
	}

	public void setRoot(Composite root) {
		this.root = root;
	}
	
	@Override
	protected void cancel() {
		this.article.setName(this.articleOrigin.getName());
		this.article.setCode(this.articleOrigin.getCode());
		this.article.setPrix(this.articleOrigin.getPrix());
		this.article.setImage(this.articleOrigin.getImage());
		this.article.getUrls().clear();
		this.article.getUrls().addAll(this.articleOrigin.getUrls());
		
	}

	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTxtNameObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtName);
		IObservableValue nameAccessoireObserveValue = BeanProperties.value("name").observe(article);
		bindingContext.bindValue(observeTextTxtNameObserveWidget, nameAccessoireObserveValue, null, null);
		//
		IObservableValue observeTextTxtCodeObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtCode);
		IObservableValue codeAccessoireObserveValue = BeanProperties.value("code").observe(article);
		bindingContext.bindValue(observeTextTxtCodeObserveWidget, codeAccessoireObserveValue, null, null);
		//
		IObservableValue observeTextTxtPriceObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtPrice);
		IObservableValue prixAccessoireObserveValue = BeanProperties.value("prix").observe(article);
		UpdateValueStrategy strategy = new UpdateValueStrategy();
		strategy.setConverter(new DoubleToStringConvertor());
		UpdateValueStrategy strategy_1 = new UpdateValueStrategy();
		strategy_1.setConverter(new NumericConvertor());
		bindingContext.bindValue(observeTextTxtPriceObserveWidget, prixAccessoireObserveValue, strategy, strategy_1);
		//
		IObservableList urlsArticleObserveList = BeanProperties.list("urls").observe(article);
		tableViewer.setInput(urlsArticleObserveList);
		//
		IObservableValue observeTextLblImageObserveWidget_1 = WidgetProperties.text().observe(lblImage);
		IObservableValue imageoriginalPathArticleObserveValue = PojoProperties.value("image.originalPath").observe(article);
		bindingContext.bindValue(observeTextLblImageObserveWidget_1, imageoriginalPathArticleObserveValue, null, null);
		//
		return bindingContext;
	}
	@Override
	protected boolean isMaximized() {
		// TODO Auto-generated method stub
		return false;
	}
	@Override
	protected Point getInitialSize() {
		
		return new Point(1200, 720);
	}
	@Override
	protected void constrainShellSize() {
		// TODO Auto-generated method stub
		super.constrainShellSize();
	}
}
