package reporting.htmlReporting.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HtmlTableElement extends HtmlElement {
	private String Title;

	private boolean showTitle =true;
	private boolean showHeader=true;
	private boolean repeatTitle=false;
	private boolean repeatHeader=true;
	short rowsPerPage=50;
	short firstPageRowscount=40;
	private Map<String ,Map<String, HtmlAttribute>> columns = new HashMap<String ,Map<String, HtmlAttribute>>();
	private Map<String,String> columnsLabels=new HashMap<String, String>(); 
	List<HtmlTableRowElement> rows=new ArrayList<HtmlTableRowElement>();
	String[] properties; 
	private List<Map<String,String>> values=new ArrayList<Map<String,String>>();
	public HtmlTableElement() {
		super("table");		
	}
	
	
	public HtmlTableRowElement createTitleRow() {
		HtmlTableRowElement titleRow=new HtmlTableRowElement(this,true);
		titleRow.setOrder(this.order+1);

		titleRow.appendClass("tableTitle");
		HtmlTableCell cell=new HtmlTableCell(titleRow);
		cell.setColspan(properties.length);
		cell.setText(Title);
		
		titleRow.appendNode(cell);
		
		return titleRow;
	}
	public HtmlTableRowElement createHeaderRow() {
		HtmlTableRowElement titleRow=new HtmlTableRowElement(this,true);
		titleRow.appendClass("tableheader");
		titleRow.setOrder(this.order+1);
		for(String key:properties) {
			HtmlTableCell cell=new HtmlTableCell(titleRow);
			cell.setText(columnsLabels.get(key));
			Map<String, HtmlAttribute> column=columns.get(key);
			if(column!=null && !column.isEmpty()) {
				for(String attr:column.keySet()) {
					cell.appendAttribute(attr, column.get(attr));
				}
			}
			titleRow.appendNode(cell);
		}
		
		return titleRow;
	}
	@Override
	public List<HtmlNode> getChildNodes() {
		return super.getChildNodes();
	}

	protected void generateContent() {
		StringBuilder sb=new StringBuilder();
		
		List<HtmlTableRowElement> tempList=new ArrayList<HtmlTableRowElement>();
		tempList.addAll(getRows());
		int i=1;
		if(tempList.size()>firstPageRowscount) {
			generateTableForRows(tempList.subList(0, firstPageRowscount-1), sb,i);
			tempList=tempList.subList(firstPageRowscount, tempList.size()-1);
			i++;
			while(tempList.size()>rowsPerPage) {
				
				generateTableForRows(tempList.subList(0, rowsPerPage-1), sb,i);
				tempList=tempList.subList(firstPageRowscount, tempList.size()-1);
				i++;
			}
			if(!tempList.isEmpty()) {
				generateTableForRows(tempList, sb,i);
			}
		}
		content=sb.toString();
		content.trim();
	}
	private void generateTableForRows(List<HtmlTableRowElement> rows,StringBuilder sb,int pageNumber) {
		sb.append(getSpaceTab(getOrder()));

		sb.append("<"+getName());
		
		if(getAttributes()!=null && !getAttributes().isEmpty()) {
			for(String child:getAttributes().keySet()) {
				HtmlAttribute attibute=getAttributes().get(child);
				
				sb.append(attibute.getContent());
			}
		}
		sb.append("> \n ");
		if(pageNumber>1) {
			if(repeatTitle)
			{
				sb.append(createTitleRow().getContent());
			}
			if(repeatHeader)
			{
				sb.append(createHeaderRow().getContent());
			}
		}else {
			sb.append(createTitleRow().getContent());
			sb.append(createHeaderRow().getContent());
		}
		
		if(!rows.isEmpty()) {
			for(HtmlNodeImpl child:rows) {
				child.setOrder(this.order+1);
				sb.append(child.getContent());
			}
		}
		sb.append(getSpaceTab(order));
		if(this.name.contentEquals("content")) {
			sb.append("</div>\n");
		}else {
			sb.append("</"+getName()+">\n");
		}
		sb.append(getSpaceTab(order));
		sb.append(HtmlPageSeparator.getInstance().getContent());
	}
	
	public String getTitle() {
		return Title;
	}

	public void setTitle(String title) {
		Title = title;
	}

	public boolean isShowTitle() {
		return showTitle;
	}

	public void setShowTitle(boolean showTitle) {
		this.showTitle = showTitle;
	}

	public boolean isShowHeader() {
		return showHeader;
	}

	public void setShowHeader(boolean showHeader) {
		this.showHeader = showHeader;
	}

	public boolean isRepeatTitle() {
		return repeatTitle;
	}


	public void setRepeatTitle(boolean repeatTitle) {
		this.repeatTitle = repeatTitle;
	}


	public boolean isRepeatHeader() {
		return repeatHeader;
	}


	public void setRepeatHeader(boolean repeatHeader) {
		this.repeatHeader = repeatHeader;
	}


	public String[] getProperties() {
		return properties;
	}


	public void setProperties(String[] properties, String[] labels) {
		this.properties = properties;
		for(int i=0;i<properties.length;i++) {
			columnsLabels.put(properties[i], labels[i]);
			columns.put(properties[i], new HashMap<String, HtmlAttribute>());
		}
	}


	public short getRowsPerPage() {
		return rowsPerPage;
	}

	public void setRowsPerPage(short rowsPerPage) {
		this.rowsPerPage = rowsPerPage;
	}

	public short getFirstPageRowscount() {
		return firstPageRowscount;
	}

	public void setFirstPageRowscount(short firstPageRowscount) {
		this.firstPageRowscount = firstPageRowscount;
	}
	
	public Map<String, Map<String, HtmlAttribute>> getColumns() {
		return columns;
	}


	public void setColumns(Map<String, Map<String, HtmlAttribute>> columns) {
		this.columns = columns;
	}


	public Map<String, String> getColumnsLabels() {
		return columnsLabels;
	}


	public void setColumnsLabels(Map<String, String> columnsLabels) {
		this.columnsLabels = columnsLabels;
	}


	public List<HtmlTableRowElement> getRows() {
		return rows;
	}


	public void setRows(List<HtmlTableRowElement> rows) {
		this.rows = rows;
	}


	public void appendColumn(String key,Map<String,HtmlAttribute> attributes) {
		this.columns.put(key, attributes);
	}
	
	public void appendColumnClasses(String columnKey,String... classes) {
			Map<String, HtmlAttribute> column=columns.get(columnKey);
			if(column!=null) {
				HtmlAttribute classAttribute =column.get("class"); 
				if(classAttribute!=null)
				{
					classAttribute.appendSegments(classes);
				}else {
					classAttribute =new HtmlAttribute();
					classAttribute.setName("class");
					classAttribute.appendSegments(classes);
					column.put("class", classAttribute);
				}
			}else {
				column =new HashMap<String, HtmlAttribute>();
				HtmlAttribute classAttribute =new HtmlAttribute();
				classAttribute.setName("class");
				classAttribute.appendSegments(classes);
				column.put("class", classAttribute);
				columns.put(columnKey, column);
			}
	}
	
	public void addColumn(String key,String label)
	{
		columns.put(key, new HashMap<String, HtmlAttribute>());
		columnsLabels.put(key, label);
	}


	public List<Map<String, String>> getValues() {
		return values;
	}


	public void setValues(List<Map<String, String>> values) {
		this.values = values;
	}
	
	public HtmlTableRowElement appendRow(Map<String,String> row) {
		values.add(row);
		HtmlTableRowElement titleRow=new HtmlTableRowElement(this,true);
		titleRow.setOrder(this.order+1);
		for(String key:properties) {
			HtmlTableCell cell=new HtmlTableCell(titleRow);
			cell.setText(row.get(key));
			Map<String, HtmlAttribute> column=columns.get(key);
			if(column!=null && !column.isEmpty()) {
				for(String attr:column.keySet()) {
					cell.appendAttribute(attr, column.get(attr));
				}
			}
			titleRow.appendNode(cell);
		}
		rows.add(titleRow);
		return titleRow; 
	}
}
