package dressing.ui;

import java.util.List;
import java.util.UUID;

import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import dressing.config.persistence.ResourceManagers;
import dressing.model.ModelProvider;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.ListEditorWindow;
import dressing.ui.util.StringViewerComparator;
import param.Chant;
import param.Fournisseur_fabricant;
import param.Material;
import param.ParamFactory;

public class FournisseurListWindow extends ListEditorWindow {

	IEventBroker eventBroker;
	public FournisseurListWindow(Shell parentShell, IEventBroker eventBroker) {
		super(parentShell);
		this.eventBroker=eventBroker;
	}

	@Override
	protected Composite createClientArea(Composite parent,int style) {
		Composite clientArea = super.createClientArea(parent, style|SWT.MULTI);
		getShell().setText("Liste des Fabricants/Fournisseurs");
		return clientArea;
	}
	
	public void createColums(TableViewer tableViewer) {
		ColumnLabelProvider nameLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Fournisseur_fabricant ) {
					return ((Fournisseur_fabricant)element).getName();
				}
				return "";
			}
		};
		createColumn(tableViewer, "Nom", true, null, SWT.LEFT, nameLabelProvider, new StringViewerComparator(nameLabelProvider));
		//
		ColumnLabelProvider codeLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Fournisseur_fabricant ) {
					return ((Fournisseur_fabricant)element).getCode();
				}
				return "";
			}
		};
		createColumn(tableViewer, "Code", true, null, SWT.LEFT, codeLabelProvider, new StringViewerComparator(codeLabelProvider));
		//
		ColumnLabelProvider countryLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Fournisseur_fabricant ) {
					return ((Fournisseur_fabricant)element).getCountry()!=null ?((Fournisseur_fabricant)element).getCountry().getName():"";
				}
				return "";
			}
		};
		createColumn(tableViewer, "Pays", true, null, SWT.LEFT, countryLabelProvider, new StringViewerComparator(countryLabelProvider));
		//
		ColumnLabelProvider numTelLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Fournisseur_fabricant ) {
					return ((Fournisseur_fabricant)element).getNumTel();
				}
				return "";
			}
		};
		createColumn(tableViewer, "Téléphone", true, null, SWT.LEFT, numTelLabelProvider, new StringViewerComparator(numTelLabelProvider));
		//
		ColumnLabelProvider mailLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Fournisseur_fabricant ) {
					return ((Fournisseur_fabricant)element).getEmail();
				}
				return "";
			}
		};
		createColumn(tableViewer, "@Email", true, null, SWT.LEFT, mailLabelProvider, new StringViewerComparator(mailLabelProvider));
		//
		ColumnLabelProvider mdfLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Fournisseur_fabricant ) {
					return ((Fournisseur_fabricant)element).isPanneaux()?"Oui":"Non";
				}
				return "";
			}
		};
		createColumn(tableViewer, "Panneaux" , true, null, SWT.CENTER, mdfLabelProvider, new StringViewerComparator(mdfLabelProvider));

		ColumnLabelProvider chantLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Fournisseur_fabricant ) {
					return ((Fournisseur_fabricant)element).isChant()?"Oui":"Non";
				}
				return "";
			}
		};
		createColumn(tableViewer, "Chant" , true, null, SWT.CENTER, chantLabelProvider, new StringViewerComparator(chantLabelProvider));
		//
		ColumnLabelProvider accessoiresLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Fournisseur_fabricant ) {
					return ((Fournisseur_fabricant)element).isAccessoire()?"Oui":"Non";
				}
				return "";
			}
		};
		createColumn(tableViewer, "Accessoires" , true, null, SWT.CENTER, accessoiresLabelProvider, new StringViewerComparator(accessoiresLabelProvider));
		
	}

	@Override
	protected void Add() {
		Fournisseur_fabricant frs=ParamFactory.eINSTANCE.createFournisseur_fabricant();
		frs.setName("");
		FournisseurEditorWindow materialEditorWindow = new FournisseurEditorWindow(shell,frs,EditorWindow.create);
		materialEditorWindow.create();
		int ret=materialEditorWindow.open();
		if(ret==Window.OK) {
			refresh();
		}
	}

	@Override
	protected void Modify() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof Fournisseur_fabricant) {
			FournisseurEditorWindow mechanicDesignWindow = new FournisseurEditorWindow(shell,(Fournisseur_fabricant) selection.getFirstElement(),EditorWindow.update);
			mechanicDesignWindow.create();
			int ret=mechanicDesignWindow.open();
			if(ret==Window.OK) {
				refresh();
			}
		}
	}

	@Override
	protected void delete() {
		boolean ret = MessageDialog.openConfirm(shell, "Confirmation de supression","Voulez vous supprimer les composant sélectionner" );
		if(ret) {
			IStructuredSelection selection=tableViewer.getStructuredSelection();
			if(selection!=null&& !selection.isEmpty()) {
				List selections=selection.toList();
				for(Object obj:selections) {
					if(obj!=null && obj instanceof Fournisseur_fabricant) {
						ResourceManagers.getIntance().getGestion().getFabricants().getFabricants().remove(obj);
						ResourceManagers.getIntance().saveGestion();
					}
				}
				refresh();
			}
		}
		

	}

	@Override
	protected void view() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof Material) {
			FournisseurEditorWindow mechanicDesignWindow = new FournisseurEditorWindow(shell,(Fournisseur_fabricant) selection.getFirstElement(),EditorWindow.View);
			mechanicDesignWindow.create();
			mechanicDesignWindow.open();
			
		}

	}

	@Override
	public List<?> getInput() {
		return ResourceManagers.getIntance().getGestion().getFabricants().getFabricants();
	}

	@Override
	protected ViewerFilter createListFilter() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	protected Composite createSearchArea(Composite parent, int style) {
		// TODO Auto-generated method stub
		return null;
	}

}
