package dressing.model.persistence.dpos;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import com.badlogic.gdx.math.Vector3;
import dressing.mathutils.Edge;
import gdxapp.Commun.Fleche;
import gdxapp.Commun.Measure;
import gdxapp.object3d.WorldObject;
import gdxapp.scenes.Scene;
import gdxapp.scenes.ScenePreferences;
import gdxapp.screens.wall.WallFragment;
import gdxapp.ui.Note;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="scene")
public class SceneDPO implements DPO<Scene> {
	
    private ScenePreferences preferences;
    
	private ArrayList<WorldObject> sceneObjects;
	private ArrayList<Note> notes;
	private ArrayList<Measure> measures;
	private List<WallFragment> fragments;
	private HashMap<WorldObject,Vector3> constraints;
	private HashMap<WorldObject,Vector3> doors;
	private ArrayList<Fleche> fleches;
    
	@Override
	public DPO<Scene> from(Scene scene) {
		setPreferences(scene.getPreferences());
		setSceneObjects(scene.getSceneObjects());
		setNotes(scene.getNotes());
		setMeasures(scene.getMeasures());
		setFragments(scene.getFragments());
		setConstraints(scene.getConstraints());
		setDoors(scene.getDoors());
		setFleches(scene.getFleches());
		return this;
	}

	
	@Override
	public Scene get() {
		Scene scene = new Scene();
		scene.setPreferences(preferences);
		scene.setSceneObjects(sceneObjects);
		scene.setNotes(notes);
		scene.setMeasures(measures);
		if(fragments != null && !fragments.isEmpty()) {
			if(!(fragments.get(0) instanceof WallFragment)) {
				fragments.clear();
				if(constraints != null)
					constraints.clear();
				if(doors != null)
					doors.clear();
			}
		}
		scene.setFragments(fragments);
		scene.setConstraints(constraints);
		scene.setDoors(doors);
		scene.setFleches(fleches);
		return scene;
	}

	//getters and setters
	public ScenePreferences getPreferences() {
		return preferences;
	}


	public void setPreferences(ScenePreferences preferences) {
		this.preferences = preferences;
	}


	public ArrayList<WorldObject> getSceneObjects() {
		return sceneObjects;
	}


	public void setSceneObjects(ArrayList<WorldObject> sceneObjects) {
		this.sceneObjects = sceneObjects;
	}


	public ArrayList<Note> getNotes() {
		return notes;
	}


	public void setNotes(ArrayList<Note> notes) {
		this.notes = notes;
	}


	public ArrayList<Measure> getMeasures() {
		return measures;
	}


	public void setMeasures(ArrayList<Measure> measures) {
		this.measures = measures;
	}


	public List<WallFragment> getFragments() {
		return fragments;
	}


	public void setFragments(List<WallFragment> fragments) {
		this.fragments = fragments;
	}


	public HashMap<WorldObject, Vector3> getConstraints() {
		return constraints;
	}


	public void setConstraints(HashMap<WorldObject, Vector3> constraints) {
		this.constraints = constraints;
	}


	public HashMap<WorldObject, Vector3> getDoors() {
		return doors;
	}


	public void setDoors(HashMap<WorldObject, Vector3> doors) {
		this.doors = doors;
	}


	public ArrayList<Fleche> getFleches() {
		return fleches;
	}


	public void setFleches(ArrayList<Fleche> fleches) {
		this.fleches = fleches;
	}
	
	
}
