package dressing.ui.util;

import org.eclipse.swt.widgets.Composite;

import dressing.model.ModelProvider;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import dressing.ui.project.GeometricObjectSettingComposite;
import gdxapp.object3d.GeometryObject;
import gdxapp.shaders.PbrMaterial;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Combo;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale.Category;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;

public class GeometryObjectSettingWindowComposite extends Composite{

	private GeometryObject geometryObject;
	
	private GeometricObjectConfigWindow window;
	private GeometricObjectSettingComposite settingComposite;

	private ComboViewer cmbVierwerCategory;
	
	
	public GeometryObjectSettingWindowComposite(Composite parent, int style, GeometricObjectConfigWindow geometricObjectConfigWindow) {
		super(parent, style);
		this.window = geometricObjectConfigWindow;
		setLayout(new GridLayout(1, false));
		
		Composite compTop = new Composite(this, SWT.NONE);
		compTop.setLayout(new GridLayout(2, false));
		compTop.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		
		Label lblNature = new Label(compTop, SWT.NONE);
		lblNature.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblNature.setText("Nature: ");
		
		cmbVierwerCategory = new ComboViewer(compTop, SWT.NONE);
		Combo combo = cmbVierwerCategory.getCombo();
		combo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		CATEGORY[] cats = {CATEGORY.FLOOR, CATEGORY.MARBLE, CATEGORY.CEILING};
		cmbVierwerCategory.setContentProvider(ArrayContentProvider.getInstance());
		cmbVierwerCategory.setLabelProvider(new LabelProvider() {
			@Override
			public String getText(Object element) {
				if(element instanceof CATEGORY)
					return ((CATEGORY) element).getDisplayName();
				return super.getText(element);
			}
		});
		
		cmbVierwerCategory.addSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				CATEGORY cat = (CATEGORY) cmbVierwerCategory.getStructuredSelection().getFirstElement();
				List<PbrMaterial> materials=ModelProvider.getMaterialsByCategory(cat);
				materials.sort(new Comparator<PbrMaterial>() {

					@Override
					public int compare(PbrMaterial o1, PbrMaterial o2) {
						
						return o1.getName().compareTo(o2.getName());
					}
				});
				settingComposite.setMaterialsList(materials);
			}
		});
		cmbVierwerCategory.setInput(cats);
		
		Composite compCenter = new Composite(this, SWT.NONE);
		compCenter.setLayout(new GridLayout(1, false));
		compCenter.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
				
		settingComposite = new GeometricObjectSettingComposite(compCenter, SWT.NONE, this.geometryObject, ModelProvider.getMaterials());
		settingComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 0, 0));
		
		Composite compBottom = new Composite(this, SWT.NONE);
		compBottom.setLayout(new GridLayout(2, false));
		compBottom.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		
		Button btnAnnuler = new Button(compBottom, SWT.NONE);
		btnAnnuler.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				cancel();
			}
		});
		btnAnnuler.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, true, false, 1, 1));
		btnAnnuler.setText("Annuler");
		
		Button btnModifier = new Button(compBottom, SWT.NONE);
		btnModifier.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				updateGeometry();
			}
		});
		btnModifier.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		btnModifier.setText("Modifier");
		pack();
			
	}

	protected void updateGeometry() {
		settingComposite.apply();
		window.updateObject();
	}

	protected void cancel() {
		window.cancel();
	}

	public GeometryObject getGeometryObject() {
		return geometryObject;
	}

	public void setGeometryObject(GeometryObject geometryObject) {
		this.geometryObject = geometryObject;
		CATEGORY cat = CATEGORY.valueOf((String) this.geometryObject.getUserData());
		cmbVierwerCategory.setSelection(new StructuredSelection(cat));
		this.settingComposite.setWorldObject(geometryObject);
		
	}
	
	
}
