/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.dnd;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.internal.navigator.CustomAndExpression;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.NavigatorSafeRunnable;
import org.eclipse.ui.internal.navigator.dnd.SkeletonCommonDropAssistant;
import org.eclipse.ui.internal.navigator.extensions.INavigatorContentExtPtConstants;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;

public final class CommonDropAdapterDescriptor
implements INavigatorContentExtPtConstants {
    private final IConfigurationElement element;
    private final INavigatorContentDescriptor contentDescriptor;
    private Expression dropExpr;

    CommonDropAdapterDescriptor(IConfigurationElement aConfigElement, INavigatorContentDescriptor aContentDescriptor) {
        this.element = aConfigElement;
        this.contentDescriptor = aContentDescriptor;
        this.init();
    }

    private void init() {
        IConfigurationElement[] children = this.element.getChildren("possibleDropTargets");
        if (children.length == 1) {
            this.dropExpr = new CustomAndExpression(children[0]);
        }
    }

    public boolean isDragElementSupported(Object anElement) {
        return this.contentDescriptor.isPossibleChild(anElement);
    }

    public boolean areDragElementsSupported(IStructuredSelection aSelection) {
        if (aSelection.isEmpty()) {
            return false;
        }
        return this.contentDescriptor.arePossibleChildren(aSelection);
    }

    public boolean isDropElementSupported(Object anElement) {
        if (this.dropExpr != null && anElement != null) {
            IEvaluationContext context = NavigatorPlugin.getEvalContext(anElement);
            return NavigatorPlugin.safeEvaluate(this.dropExpr, context) == EvaluationResult.TRUE;
        }
        return false;
    }

    public CommonDropAdapterAssistant createDropAssistant() {
        final CommonDropAdapterAssistant[] retValue = new CommonDropAdapterAssistant[1];
        SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(this.element){

            @Override
            public void run() throws Exception {
                retValue[0] = (CommonDropAdapterAssistant)CommonDropAdapterDescriptor.this.element.createExecutableExtension("class");
            }
        });
        if (retValue[0] != null) {
            return retValue[0];
        }
        return SkeletonCommonDropAssistant.INSTANCE;
    }

    public INavigatorContentDescriptor getContentDescriptor() {
        return this.contentDescriptor;
    }
}

