package dressing.cam.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.CoordinateSystem;
import dressing.mathutils.Vector4;
import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.model.types.Orientation;

public class SystemCoordinateSwitcher {
	
	
	private Matrix4 machineTransform;

	public Vector3 toMachineCoordinate(Vector3 worldPoint) {
		Vector3 image = worldPoint.cpy().mul(this.machineTransform);
		return image;
	}
	

	
	void init(Piece2D piece) {
		
		ArrayList<CoordinateSystem> systems = CoordinateSystem.getMachineCoordSystem(piece);
		Matrix4 transform = null;
		
		Orientation orientation = piece.getPieceOrientation();
		
		switch(orientation) {
		case HORIZONTAL:
			transform = systems.get(1).transform;
			break;
		case VERTICAL:
			transform = systems.get(5).transform;
			break;
		case PROUFOUND:
			transform = systems.get(1).transform;
			break;
		default:
			transform = systems.get(0).transform;
			break;
		}
		
		this.machineTransform = transform;
	}
	
	
	
	
	public static void main(String[] args) {
		
	}



Matrix4 initMat(Piece2D piece) {
		
		ArrayList<CoordinateSystem> systems = CoordinateSystem.getMachineCoordSystem(piece);
		Matrix4 transform = null;
		
		Orientation orientation = piece.getPieceOrientation();
		
		switch(orientation) {
		case HORIZONTAL:
			transform = systems.get(1).transform;
			break;
		case VERTICAL:
			transform = systems.get(5).transform;
			break;
		case PROUFOUND:
			transform = systems.get(1).transform;
			break;
		default:
			transform = systems.get(0).transform;
			break;
		}
		
	  return  transform;
	}
}
