/*
 * Created by JFormDesigner on Fri Jan 03 00:36:40 CET 2025
 */

package utils;

import java.awt.*;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.swing.*;
import javax.swing.border.TitledBorder;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

import dressing.config.WorkspaceConfiguration;
import dressing.io.IOUtilities;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import info.clearthought.layout.*;
//import net.sf.json.JSONArray;
//import net.sf.json.JSONObject;

/**
 * @author Jihed
 */
public class DragDropFolder extends JFrame {

	private Map<File, JComboBox<String>> fileSelectionMap = new HashMap<>();
	private Set<String> selectedTypes = new HashSet<>();
	private final String[] typeOptions = { "", "base_color_map", "normal_map", "roughness_map","metalness_map", "ao" };
	private final String defaultPath="C:\\ProgramData\\supercad\\materials.json";
	private File jsonOutputFile = null;
	private List<File> materials=new ArrayList<File>();
	public static void main(String[] args) {
		SwingUtilities.invokeLater(DragDropFolder::new);
	}

	public DragDropFolder() {
		initComponents();

		dropPanel.setBorder(new TitledBorder("Drag & Drop a Folder Here"));
		dropPanel.setPreferredSize(new Dimension(350, 80));
		new DropTarget(dropPanel, new DropTargetAdapter() {
			@Override
			public void drop(DropTargetDropEvent dtde) {
				try {
					dtde.acceptDrop(DnDConstants.ACTION_COPY);
					List<File> droppedFiles = (List<File>) dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
					if (!droppedFiles.isEmpty() && droppedFiles.get(0).isDirectory()) {
						File folder = droppedFiles.get(0);
						boolean islistMaterial=true;
						for (File file : folder.listFiles()) {
							if (file.isFile()) {
								islistMaterial=false;
							}else {
								materials.add(file);
							}
						}
						if(islistMaterial&& !materials.isEmpty()) {
							folder=materials.get(0);
							materials.remove(folder);
						}
						pathField.setText(folder.getAbsolutePath());
						listFiles(folder);
						if(folder.exists()) {
							nameField.setText(folder.getName());
						}
					}
				} catch (Exception ex) {
					ex.printStackTrace();
				}
			}
		});

		generateJsonButton.addActionListener(this::generateJson);
		browseButton.addActionListener(this::selectJsonFiel);
		resetButton.addActionListener(this::reset);
		
		for (CATEGORY cateogry : CATEGORY.values()) {
			categoryCombo.addItem(cateogry.name());

		}
		jsonPathField.setText(defaultPath);
		jsonOutputFile =new File(defaultPath);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setSize(800, 600);
		this.setVisible(true);

	}

	private void listFiles(File folder) {
		filePanel.removeAll();
		fileSelectionMap.clear();
		selectedTypes.clear();

		for (File file : folder.listFiles()) {
			if (file.isFile()) {
				JPanel fileEntry = new JPanel(new FlowLayout());
				JLabel fileLabel = new JLabel(file.getName());
				JComboBox<String> fileTypeSelector = new JComboBox<>(typeOptions);
				
				fileTypeSelector.addItemListener(e -> {
					if (e.getStateChange() == ItemEvent.SELECTED) {
						selectedTypes.add(e.getItem().toString());
//                        updateSelections();
					} else if (e.getStateChange() == ItemEvent.DESELECTED) {
						selectedTypes.remove(e.getItem().toString());
//                        updateSelections();
					}
				});
				if(file.getName().toUpperCase().contains("COLOR")|| file.getName().toUpperCase().contains("ALBEDO")) {
					fileTypeSelector.setSelectedItem(typeOptions[1]);
				}else if(file.getName().toUpperCase().contains("NORMAL")) {
					fileTypeSelector.setSelectedItem(typeOptions[2]);
				}else if(file.getName().toUpperCase().contains("ROUGHNESS")) {
					fileTypeSelector.setSelectedItem(typeOptions[3]);
				}else if(file.getName().toUpperCase().contains("METAL")) {
					fileTypeSelector.setSelectedItem(typeOptions[4]);
				}else if(file.getName().toUpperCase().contains("AO")||file.getName().toUpperCase().contains("AMBIENTOCCLUSION")) {
					fileTypeSelector.setSelectedItem(typeOptions[5]);
				}
				fileSelectionMap.put(file, fileTypeSelector);

				JLabel iconLabel = new JLabel();
				if (file.getName().matches(".*\\.(png|jpg|jpeg|gif|bmp)$")) {
					ImageIcon icon = new ImageIcon(new ImageIcon(file.getAbsolutePath()).getImage().getScaledInstance(50, 50, Image.SCALE_SMOOTH));
					iconLabel.setIcon(icon);
				}

				fileEntry.add(iconLabel);
				fileEntry.add(fileLabel);
				fileEntry.add(fileTypeSelector);
				filePanel.add(fileEntry);
			}
		}
		filePanel.revalidate();
		filePanel.repaint();
	}

	private void selectJsonFiel(ActionEvent e) {
		JFileChooser fileChooser = new JFileChooser();
		fileChooser.setSelectedFile(jsonOutputFile);
		int returnValue = fileChooser.showOpenDialog(null);

		if (returnValue == JFileChooser.APPROVE_OPTION) {
			File selectedFile = fileChooser.getSelectedFile();
			jsonPathField.setText(selectedFile.getAbsolutePath());
			jsonOutputFile = selectedFile;
		}

	}

	private void reset(ActionEvent e) {
		filePanel.removeAll();
		fileSelectionMap.clear();
		selectedTypes.clear();
		nameField.setText("");
		pathField.setText("");
//		categoryCombo.setSelectedIndex(0);
//		jsonPathField.setText("");
//		jsonOutputFile = null;
		filePanel.revalidate();
		filePanel.repaint();
		if(!materials.isEmpty()) {
			File folder=materials.get(0);
			materials.remove(folder);
			pathField.setText(folder.getAbsolutePath());
			listFiles(folder);
			if(folder.exists()) {
				nameField.setText(folder.getName());
			}
		}
	}

	private void generateJson(ActionEvent e) {
		JSONObject json = new JSONObject();
		json.put("name", nameField.getText());
		json.put("category", categoryCombo.getSelectedItem());
		File folder=new File(WorkspaceConfiguration.MATERIALS_FOLDER+File.separator+nameField.getText());
		folder.mkdirs();
		for (Map.Entry<File, JComboBox<String>> entry : fileSelectionMap.entrySet()) {
			String selectedType = (String) entry.getValue().getSelectedItem();
			if (!selectedType.isEmpty()) {
				String path=entry.getKey().getAbsolutePath();
				File destpathfile=new File(folder,entry.getKey().getName().trim());
				try {
					IOUtilities.copyFileUsingChannel(entry.getKey(), destpathfile);
					path=destpathfile.getAbsolutePath();
				} catch (IOException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}
				json.put(selectedType, path);
			}
		}
//		JSONArray jsonArray = new JSONArray();
		JSONParser jsonParser = new JSONParser();
		JSONArray jsonArray = new JSONArray();
		
		if (jsonOutputFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(jsonOutputFile))) {
                StringBuilder content = new StringBuilder();
                String line;
                while ((line = reader.readLine()) != null) {
                    content.append(line);
                }
//                jsonArray =  JSONArray.fromObject(content.toString());
                jsonArray =  (JSONArray) jsonParser.parse(content.toString());
            } catch (Exception ex) {
                ex.printStackTrace();
            }
		}else {
            JOptionPane.showMessageDialog(this, "File doesn't exisit", "File Check", JOptionPane.INFORMATION_MESSAGE);
			System.out.println(jsonArray);
		}
		jsonArray.add(json);

        try (FileWriter file = new FileWriter(jsonOutputFile)) {
            file.write(jsonArray.toString());
            JOptionPane.showMessageDialog(this, "JSON Updated Successfully!\nSaved to " + jsonOutputFile.getAbsolutePath());
        } catch (IOException ex) {
            ex.printStackTrace();
        }
        if(!materials.isEmpty()) 
        {
        	reset(null);
        }

	}

	private void initComponents() {
		// JFormDesigner - Component initialization - DO NOT MODIFY  //GEN-BEGIN:initComponents  @formatter:off
		// Generated using JFormDesigner Evaluation license - FRS
		panel1 = new JPanel();
		label1 = new JLabel();
		nameField = new JTextField();
		panel2 = new JPanel();
		label2 = new JLabel();
		categoryCombo = new JComboBox<>();
		panel3 = new JPanel();
		label3 = new JLabel();
		jsonPathField = new JTextField();
		browseButton = new JButton();
		pathField = new JTextField();
		filePanel = new JPanel();
		dropPanel = new JPanel();
		generateJsonButton = new JButton();
		resetButton = new JButton();

		//======== this ========
		setTitle("Drag & Drop Folder Explorer");
		Container contentPane = getContentPane();
		contentPane.setLayout(new TableLayout(new double[][] {
			{TableLayout.FILL, TableLayout.FILL},
			{TableLayout.PREFERRED, TableLayout.PREFERRED, TableLayout.FILL, TableLayout.PREFERRED}}));
		((TableLayout)contentPane.getLayout()).setHGap(5);
		((TableLayout)contentPane.getLayout()).setVGap(5);

		//======== panel1 ========
		{
			panel1.setBorder (new javax. swing. border. CompoundBorder( new javax .swing .border .TitledBorder (new javax. swing. border. EmptyBorder
			( 0, 0, 0, 0) , "JFor\u006dDesi\u0067ner \u0045valu\u0061tion", javax. swing. border. TitledBorder. CENTER, javax. swing. border
			. TitledBorder. BOTTOM, new java .awt .Font ("Dia\u006cog" ,java .awt .Font .BOLD ,12 ), java. awt
			. Color. red) ,panel1. getBorder( )) ); panel1. addPropertyChangeListener (new java. beans. PropertyChangeListener( ){ @Override public void
			propertyChange (java .beans .PropertyChangeEvent e) {if ("bord\u0065r" .equals (e .getPropertyName () )) throw new RuntimeException( )
			; }} );
			panel1.setLayout(new TableLayout(new double[][] {
				{TableLayout.MINIMUM, TableLayout.FILL},
				{TableLayout.PREFERRED}}));
			((TableLayout)panel1.getLayout()).setHGap(5);
			((TableLayout)panel1.getLayout()).setVGap(5);

			//---- label1 ----
			label1.setText("Name :");
			panel1.add(label1, new TableLayoutConstraints(0, 0, 0, 0, TableLayoutConstraints.FULL, TableLayoutConstraints.FULL));
			panel1.add(nameField, new TableLayoutConstraints(1, 0, 1, 0, TableLayoutConstraints.FULL, TableLayoutConstraints.FULL));
		}
		contentPane.add(panel1, new TableLayoutConstraints(0, 0, 0, 0, TableLayoutConstraints.FULL, TableLayoutConstraints.FULL));

		//======== panel2 ========
		{
			panel2.setLayout(new TableLayout(new double[][] {
				{TableLayout.PREFERRED, TableLayout.FILL},
				{TableLayout.PREFERRED}}));
			((TableLayout)panel2.getLayout()).setHGap(5);
			((TableLayout)panel2.getLayout()).setVGap(5);

			//---- label2 ----
			label2.setText("Category :");
			panel2.add(label2, new TableLayoutConstraints(0, 0, 0, 0, TableLayoutConstraints.FULL, TableLayoutConstraints.FULL));
			panel2.add(categoryCombo, new TableLayoutConstraints(1, 0, 1, 0, TableLayoutConstraints.FULL, TableLayoutConstraints.FULL));
		}
		contentPane.add(panel2, new TableLayoutConstraints(1, 0, 1, 0, TableLayoutConstraints.FULL, TableLayoutConstraints.FULL));

		//======== panel3 ========
		{
			panel3.setLayout(new TableLayout(new double[][] {
				{TableLayout.PREFERRED, TableLayout.FILL, TableLayout.PREFERRED},
				{TableLayout.PREFERRED}}));
			((TableLayout)panel3.getLayout()).setHGap(5);
			((TableLayout)panel3.getLayout()).setVGap(5);

			//---- label3 ----
			label3.setText("Json output :");
			panel3.add(label3, new TableLayoutConstraints(0, 0, 0, 0, TableLayoutConstraints.FULL, TableLayoutConstraints.FULL));
			panel3.add(jsonPathField, new TableLayoutConstraints(1, 0, 1, 0, TableLayoutConstraints.FULL, TableLayoutConstraints.FULL));

			//---- browseButton ----
			browseButton.setText("...");
			panel3.add(browseButton, new TableLayoutConstraints(2, 0, 2, 0, TableLayoutConstraints.FULL, TableLayoutConstraints.FULL));
		}
		contentPane.add(panel3, new TableLayoutConstraints(0, 1, 0, 1, TableLayoutConstraints.FULL, TableLayoutConstraints.FULL));
		contentPane.add(pathField, new TableLayoutConstraints(1, 1, 1, 1, TableLayoutConstraints.FULL, TableLayoutConstraints.FULL));

		//======== filePanel ========
		{
			filePanel.setLayout(new BoxLayout(filePanel, BoxLayout.Y_AXIS));
		}
		contentPane.add(filePanel, new TableLayoutConstraints(0, 2, 0, 2, TableLayoutConstraints.FULL, TableLayoutConstraints.FULL));

		//======== dropPanel ========
		{
			dropPanel.setLayout(null);

			{
				// compute preferred size
				Dimension preferredSize = new Dimension();
				for(int i = 0; i < dropPanel.getComponentCount(); i++) {
					Rectangle bounds = dropPanel.getComponent(i).getBounds();
					preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
					preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
				}
				Insets insets = dropPanel.getInsets();
				preferredSize.width += insets.right;
				preferredSize.height += insets.bottom;
				dropPanel.setMinimumSize(preferredSize);
				dropPanel.setPreferredSize(preferredSize);
			}
		}
		contentPane.add(dropPanel, new TableLayoutConstraints(1, 2, 1, 2, TableLayoutConstraints.FULL, TableLayoutConstraints.FULL));

		//---- generateJsonButton ----
		generateJsonButton.setText("Generate JSON");
		contentPane.add(generateJsonButton, new TableLayoutConstraints(0, 3, 0, 3, TableLayoutConstraints.FULL, TableLayoutConstraints.FULL));

		//---- resetButton ----
		resetButton.setText("Reset");
		contentPane.add(resetButton, new TableLayoutConstraints(1, 3, 1, 3, TableLayoutConstraints.FULL, TableLayoutConstraints.FULL));
		pack();
		setLocationRelativeTo(getOwner());
		// JFormDesigner - End of component initialization  //GEN-END:initComponents  @formatter:on
	}

	// JFormDesigner - Variables declaration - DO NOT MODIFY  //GEN-BEGIN:variables  @formatter:off
	// Generated using JFormDesigner Evaluation license - FRS
	private JPanel panel1;
	private JLabel label1;
	private JTextField nameField;
	private JPanel panel2;
	private JLabel label2;
	private JComboBox<String> categoryCombo;
	private JPanel panel3;
	private JLabel label3;
	private JTextField jsonPathField;
	private JButton browseButton;
	private JTextField pathField;
	private JPanel filePanel;
	private JPanel dropPanel;
	private JButton generateJsonButton;
	private JButton resetButton;
	// JFormDesigner - End of variables declaration  //GEN-END:variables  @formatter:on
}
