package gdxapp.object3d;

import java.util.ArrayList;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.Sphere;

public class SphericVolume {
	
	private ArrayList<Sphere> spheres;
	
	public void fillVolume(RotatedBoundingBox bounds) {
		Vector3 center = new Vector3();
		bounds.getCenter(center);
		Vector3 dimensions = new Vector3();
		bounds.getDimensions(dimensions);
		float centralBallDimensions = Math.min(Math.min(dimensions.x, dimensions.y), dimensions.z);
		Vector3 space = dimensions.cpy().sub(centralBallDimensions).scl(0.5f);
		
		Vector3 filledDirection;
		//pick a direction
		if(space.x < 0.0001f) {
			filledDirection = Vector3.X;
		}else if(space.y < 0.0001f) {
			filledDirection = Vector3.Y;
		}else {
			filledDirection = Vector3.Z;
		}
		Vector3 dirs[] = new Vector3[2];
		dirs[0].set(filledDirection.z, filledDirection.x, filledDirection.y);
		dirs[0].set(filledDirection.y, filledDirection.z, filledDirection.x);
		Sphere centralSphere = new Sphere(new Vector3(), centralBallDimensions/2.f);
		Vector3 halfDims = dimensions.cpy().scl(.5f);
		spheres.add(centralSphere);
		

		
		
	}

}
