package dressing.ui.printreport;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JPanel;

import dressing.model.Piece2D;
import tech.frsdev.shapes2D.Piece2DDraw;

public class Panel extends JPanel implements Printable {
	List<Piece2D> piece;
	List<Piece2DDraw> piecedraw;

	@Override
	public int print(Graphics gr, PageFormat pageFormat, int pageIndex) throws PrinterException {
		// TODO Auto-generated method stub
		if (pageIndex >= piecedraw.size()) {
			return NO_SUCH_PAGE;
		}
		// gr.drawLine(0, 5, 20, 30);
		// gr.drawLine(0, 0, 20, 30);
		// gr.drawString("hello i'm here", 5, 20);
		// gr.setColor(new Color(0.5f, 0.2f, 0.6f));
		// gr.drawRect(5, 25, 400, 200);
		// piecedraw.draw((Graphics2D) graphics);
		Graphics2D g2d = (Graphics2D) gr;
		AffineTransform oldTransform = g2d.getTransform();
		// g2d.scale(zoom, zoom);
		gr.setColor(Color.BLACK);

		g2d.translate(20, 50);
		piecedraw.get(pageIndex).draw(g2d);

		// piecedraw.get(pageIndex).redifine();
		Piece2DDraw p2ddraw = null;
		try {
			p2ddraw = (Piece2DDraw) piecedraw.get(pageIndex).clone();
		} catch (CloneNotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if (p2ddraw != null) {
			g2d.translate(400, 0);
			p2ddraw.setViewPerspective(Piece2DDraw.getSecondaryPrespective(piecedraw.get(pageIndex).getPiece()));
			p2ddraw.redifine();
			p2ddraw.draw(g2d);
			// validate();
			// repaint();
			g2d.translate(-400, 0);
		}
    	
		g2d.translate(-20, -50);
		//
		g2d.translate(420 , 400 );
		BasicStroke strongstrk  = new BasicStroke(2.0f);
    	BasicStroke finestrk  = new BasicStroke(0.5f);
    	BasicStroke verfinestrk  = new BasicStroke(0.3f);
    	g2d.setStroke(strongstrk);
		g2d.drawRect(0, 0,400 , 180);
//		g2d.setStroke(finestrk);
		g2d.drawString("Pièce : "+piece.get(pageIndex).getName(),15,  15 );
		g2d.drawString("Caisson : "+piece.get(pageIndex).getRootCaisson().getName(),15,  35 );
		g2d.drawString("Dressing : "+piece.get(pageIndex).getRoot().getName(),15,  55 );
		g2d.drawString("Materieaux : "+piece.get(pageIndex).getMaterial().getName(),15,  75 );
		g2d.drawString("Epaisseur : "+piece.get(pageIndex).getMaterial().getEpaisseur(),15,  95 );
		
		g2d.drawRect(-400, 100,200 , 50);
		g2d.drawString("Société : Perla cuisine",-380,  130 );
		
		g2d.translate(-420 , -400 );

		


		
		return PAGE_EXISTS;
	}

	public Panel(List<Piece2D> piece2) {
		super();
		this.piece = piece2;
		piecedraw = new ArrayList<Piece2DDraw>();
		for (Piece2D piece : piece2) {
			Piece2DDraw piecedraw1 = new Piece2DDraw(piece, 420, 300);
			piecedraw1.setViewPerspective(Piece2DDraw.getPrimaryPrespective(piece));
			piecedraw.add(piecedraw1);
			piecedraw1.redifine();
			validate();
			repaint();
		}

	}

}
