package gdxapp.object3d;

import java.io.IOException;
import java.util.UUID;

import dressing.model.ModelProvider;
import dressing.model.persistence.dpos.ModeledObjectDPO;
import dressing.model.persistence.mappers.Persistable;

@Persistable(persistableForm = ModeledObjectDPO.class)
public class ModeledObject extends WorldObject{
	
	public ModeledObject() {
		type = ObjectType.MODELED;
	}
	
	@Override
	public ObjectModel getModel() {
		if(model == null)
			model = ModelProvider.get3DObjectModel(uuid);
		return model;
	}
	
	public float getElevation() {
		return getModel().getInfo().getElevation();
	}

	@Override
	public ModeledObject clone() {
		ModeledObject clone = null;
		if(this.model != null) {
			try {
				clone = WorldObjectFactory.getFactory().createObjectFromModel(model.clone());
			} catch (IOException e) {
				e.printStackTrace();
			}
		}else {
			clone = new ModeledObject();
		}
		clone.setRealWorldDimension(getRealWorldDimension().cpy());
		clone.setRealWorldPosition(getRealWorldPosition().cpy());
		clone.setModel(this.getModel().clone());
		clone.setUuid(getUuid());
		clone.setSceneId(UUID.randomUUID());
		return clone;
	}

	
	
}
