package dressing.ui.engine3d;

import org.eclipse.swt.widgets.Composite;

import java.beans.PropertyChangeSupport;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import dressing.config.UserPreference;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;

public class CameraSettingComposite extends Composite {

	private Runnable onFinish;
	private Runnable onCancel;
	private PropertyChangeSupport pcs;

	public CameraSettingComposite(Composite parent, Runnable onFinish, Runnable onCancel) {
		super(parent, SWT.NONE);
		this.onFinish = onFinish;
		this.onCancel = onCancel;
		setLayout(new GridLayout(1, false));
		
		Composite settingComposite = new Composite(this, SWT.NONE);
		settingComposite.setLayout(new GridLayout(5, false));
		settingComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		Label lblMoveForward = new Label(settingComposite, SWT.NONE);
		lblMoveForward.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		lblMoveForward.setText("Move Forward");
		
		Text text = new Text(settingComposite, SWT.BORDER);
		text.addKeyListener(new KeyAdapter() {
			@Override
			public void keyPressed(KeyEvent e) {
				if((e.stateMask & SWT.CTRL) != 0) {
					text.setText("CTRL+" +   SWTKeyToString( e.keyCode));
				}
			}
		});
		text.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label label = new Label(settingComposite, SWT.NONE);
		
		Label lblMoveBackward = new Label(settingComposite, SWT.NONE);
		lblMoveBackward.setText("Move Backward");
		
		Text text_1 = new Text(settingComposite, SWT.BORDER);
		text_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblMoveRight = new Label(settingComposite, SWT.NONE);
		lblMoveRight.setText("Move Right");
		
		Text text_2 = new Text(settingComposite, SWT.BORDER);
		text_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		new Label(settingComposite, SWT.NONE);
		
		Label lblMoveLeft = new Label(settingComposite, SWT.NONE);
		lblMoveLeft.setText("Move Left");
		
		Text text_3 = new Text(settingComposite, SWT.BORDER);
		text_3.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblLookRight = new Label(settingComposite, SWT.NONE);
		lblLookRight.setText("Look Right");
		
		Text text_4 = new Text(settingComposite, SWT.BORDER);
		text_4.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		new Label(settingComposite, SWT.NONE);
		
		Label lblLookLeft = new Label(settingComposite, SWT.NONE);
		lblLookLeft.setText("Look Left");
		
		Text text_5 = new Text(settingComposite, SWT.BORDER);
		text_5.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblLookUp = new Label(settingComposite, SWT.NONE);
		lblLookUp.setText("Look Up");
		
		Text text_6 = new Text(settingComposite, SWT.BORDER);
		text_6.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		new Label(settingComposite, SWT.NONE);
		
		Label lblLookDown = new Label(settingComposite, SWT.NONE);
		lblLookDown.setText("Look Down");
		
		Text text_7 = new Text(settingComposite, SWT.BORDER);
		text_7.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblMouseSensitivity = new Label(settingComposite, SWT.NONE);
		lblMouseSensitivity.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 2, 1));
		lblMouseSensitivity.setText("Mouse Sensitivity");
		new Label(settingComposite, SWT.NONE);
		
		Scale scale = new Scale(settingComposite, SWT.NONE);
		scale.setMaximum(10);
		scale.setMinimum(1);
		int value = UserPreference.getPreference().getScenePreferences().getCameraSensitivity();
		scale.setSelection(value);
		scale.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 2, 1));
		
		new Label(settingComposite, SWT.NONE);
		new Label(settingComposite, SWT.NONE);
		new Label(settingComposite, SWT.NONE);
		new Label(settingComposite, SWT.NONE);
		new Label(settingComposite, SWT.NONE);
		new Label(settingComposite, SWT.NONE);
		new Label(settingComposite, SWT.NONE);
		new Label(settingComposite, SWT.NONE);
		new Label(settingComposite, SWT.NONE);
		new Label(settingComposite, SWT.NONE);
		
		Composite btnComposite = new Composite(this, SWT.NONE);
		btnComposite.setLayout(new GridLayout(2, true));
		btnComposite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Button btnAnnuler = new Button(btnComposite, SWT.NONE);
		btnAnnuler.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, true, false, 1, 1));
		btnAnnuler.setBounds(0, 0, 90, 30);
		btnAnnuler.setText("Annuler");
		btnAnnuler.addMouseListener(new MouseAdapter() {

			@Override
			public void mouseUp(MouseEvent e) {
				onCancel.run();
			}
			
		});
		
		Button btnEnregistrer = new Button(btnComposite, SWT.NONE);
		btnEnregistrer.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				int cameraSpeed = scale.getSelection();
				UserPreference.getPreference().getScenePreferences().setCameraSensitivity(cameraSpeed);
				UserPreference.getPreference().save();
				onFinish.run();
			}
		});
		btnEnregistrer.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		btnEnregistrer.setText("Enregistrer");
	}
	
	
	private String SWTKeyToString(int keyCode) {
		switch (keyCode) {
		case SWT.ESC:
			return "Esc";
		case SWT.TAB:
			return "Tab";
		case SWT.SPACE:
			return "Space";
		case SWT.ARROW_UP:
			return "Up";
		case SWT.ARROW_DOWN:
			return "Down";
		case SWT.ARROW_LEFT:
			return "Left";
		case SWT.ARROW_RIGHT:
			return "Right";
		case SWT.HOME:
			return "Home";
		case SWT.END:
			return "End";
		case SWT.PAGE_UP:
			return "PageUp";
		case SWT.PAGE_DOWN:
			return "PageDown";
		case SWT.INSERT:
			return "Insert";
		case SWT.DEL:
			return "Delete";
		default:
			// For F chars
			if (keyCode >= SWT.F1 && keyCode <= SWT.F12) {
				return "F" + (keyCode - SWT.F1 + 1);
			}
			// For regular characters
			if (keyCode >= SWT.KEYPAD_0 && keyCode <= SWT.KEYPAD_9) {
				return "Num" + (keyCode - SWT.KEYPAD_0);
			}
			return Character.toString((char) keyCode).toUpperCase();
		}
	}
}
