package dressing.ui.engine3d;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;


public class CameraConfigWindow extends Window {

	private CameraSettingComposite content;
	
	private static CameraConfigWindow instance;
	
	protected CameraConfigWindow(Shell parentShell) {
		super(parentShell);
	}
	
	@Override
	protected Control createContents(Composite parent) {
		Runnable onFinish = () -> {
			CameraConfigWindow.this.close();
		};
		content = new CameraSettingComposite(parent, onFinish, onFinish);
		return content;	
	}

	public static CameraConfigWindow getInstance() {
		if(instance == null) {
			instance = new CameraConfigWindow(Display.getDefault().getActiveShell());
		}
		return instance;
	}

	
	
	
	
	

}
