package dressing.mathutils;

import com.badlogic.gdx.math.Vector2;

public class Matrix2 {
	
	final float[] values = new float[]{1.0f, 0.0f, 0.0f, 1.0f};;
    private final static int M11 = 0;
    private final static int M12 = 1;
    private final static int M21 = 2;
    private final static int M22 = 3;

    public Matrix2() {
    }
    public Matrix2(float[] values) {
        if(values.length >= 4){
            for(int i = 0; i < 4; i ++){
                this.values[i] = values[i];
            }
        }
    }

    public void set(float[] values){
        for(int i = 0; i < 4; i ++){
            this.values[i] = values[i];
        }
    }

    public Matrix2 cpy(){
        return  new Matrix2(this.values);
    }

    public Vector2 mul(Vector2 v){
        return new Vector2(values[M11] * v.x + values[M12] * v.y, values[M21] * v.x + values[M22] * v.y);
    }

    public Matrix2 inv(){
        float divider = 1/(values[M11] * values[M22] - values[M21] * values[M12]);
        float[] inverseValues = new float[4];
        inverseValues[M11] = divider * values[M22];
        inverseValues[M12] = -divider * values[M12];
        inverseValues[M21] = -divider * values[M21];
        inverseValues[M22] = divider * values[M11];
        set(inverseValues);
        return this;
    }


    @Override
    public String toString() {
        return "[" + values[M11] + ", " + values[M12] + "\n" + + values[M21] + ", " + values[M22] + "]" + "\n";
    }

}
