package reporting.htmlReporting;

import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.frs.html.JavaCodeEvaluator;

import dressing.cam.model.Util;
import dressing.config.ReportingPreferences;
import dressing.config.WorkspaceConfiguration;
import dressing.io.IOUtilities;
import dressing.config.persistence.ResourceManagers;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Kitchen;
import dressing.model.MechanicDesignCreator;
import dressing.model.ModelProvider;
import dressing.model.Piece2D;
import dressing.model.ProjectManager;
import dressing.model.Space3DFree;
import dressing.model.SuperCadProject;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;
import dressing.model.stock.ModelAccessoire;
import dressing.model.stock.ModelQuincaillerie;
import dressing.reporting.data.handle.ArticleCoupe;
import dressing.reporting.data.handle.ProjectCoupe;
import gdxapp.object3d.KitchenElement;
import gdxapp.screens.room3d.Room3DController;
import reporting.data.handle.PieceCoupe;
import utils.EmfUtils;

public class ProjectReport extends HtmlReport{
	
	
	private SuperCadProject project;
	private Map<KitchenElement, String[]> picturesPath = new HashMap<KitchenElement, String[]>();
	private List<String> wallViewsUrl;
	private final String template_path = "src/reporting/htmlReporting/templates/ProjectReport.html";
	private HashMap<DesignObject3D, ElementReport> elementsReport;
	private HashMap<ElementReport, String> links;
	private ProjectCoupe projectCoupe;
	private String screenShotURI;
	private String reportDir;
	ArrayList<ArticleCoupe> accessoires = new ArrayList<ArticleCoupe>();
	ArrayList<ArticleCoupe> quincailleries = new ArrayList<ArticleCoupe>();
	
	public ProjectReport(SuperCadProject project, String screenshot, List<String> wallViews) {
		super();
		this.project = project;
		this.wallViewsUrl = wallViews;
		this.projectCoupe = new ProjectCoupe(false, project);
		this.screenShotURI = screenshot;
		this.reportDir = project.getProjectDirectory() + File.separator + "reporting";
		createURI();
		bind();
	}

	public void createURI() {
		String host = WorkspaceConfiguration.JETTY_HOST;
		//screenshot
		File file = new File(this.screenShotURI);
		this.screenShotURI = host + "/" + file.getName();		
		//elements pictures
		picturesPath.clear();
		for(KitchenElement element: ProjectManager.getManager().getCurrentScene().getKitchenElements()) {
			String[] paths= new String[2];
			File  imgFile  = new File(element.getPathToBackImage());
			paths[0] = host + File.separator + imgFile.getName();
			imgFile = new File(element.getPathToFrontImage());
			paths[1] = host + File.separator + imgFile.getName();
			picturesPath.put(element, paths);
		}
	}
	

	public void bind() {
		File logoFile =new File(ResourceManagers.getIntance().getPreference().getConfig().getLogoPath());
		File logoDestination = new File(reportDir + File.separator + "logo.png"); 
		try {
			IOUtilities.copyFileUsingChannel(logoFile, logoDestination);
			binding.put("$logo$", WorkspaceConfiguration.JETTY_HOST + "/" + logoDestination.getName());
		} catch (IOException e) {
			e.printStackTrace();
		}
		boolean isShowAccessoire = ReportingPreferences.getInstance().getBoolean("report.accessoire", false);
		boolean isShowQuicaillerie = ReportingPreferences.getInstance().getBoolean("report.quicaillerie", false);
		boolean isShowCost = ReportingPreferences.getInstance().getBoolean("report.showcost", false);
		boolean isShowFacades = ReportingPreferences.getInstance().getBoolean("report.showFacades", false);
		boolean isShowPieces = ReportingPreferences.getInstance().getBoolean("report.showPieces", false);
		boolean isShowFakeFaces = ReportingPreferences.getInstance().getBoolean("report.showFakeFaces", true);

		if(isShowAccessoire || isShowQuicaillerie) {
			generateAccessoiresAndQuincailleries();
			replaceAccessoiresImages();
		}
		this.binding.put("$isShowAccessoire$", isShowAccessoire);
		this.binding.put("$isShowQuicaillerie$", isShowQuicaillerie);
		this.binding.put("$isShowCost$", isShowCost);
		this.binding.put("$isShowPieces$", isShowPieces);
		this.binding.put("$isShowFakeFaces$", isShowFakeFaces);

		binding.put("$project$", this.project);
		binding.put("$creation_date$", this.project.getCreationDate().toLocalDate());
		binding.put("$faceUrls$", wallViewsUrl);
		binding.put("$accessories$", accessoires);
		binding.put("$quincailleries$", quincailleries);
		this.binding.put("$projectCoupe$", projectCoupe);
		List<DesignObject3D> elements = new ArrayList<DesignObject3D>( this.project.getKitchens().get(0).getElements());
		ArrayList<DesignObject3D> fakeFacades = new ArrayList<DesignObject3D>();
		for(DesignObject3D design: elements) {
			String type =  EmfUtils.getDesignCaissonType(design);
			if(type.equals("FAUSSE_FACADE"))
				fakeFacades.add(design);
		}
		elements.removeAll(fakeFacades);
		
		List<Piece2D> facades=new ArrayList<Piece2D>();
		List<PieceCoupe> facedesCoupe=new ArrayList<PieceCoupe>();
		if(isShowFacades) {
			
			for(DesignObject3D design: elements) {
				for(Piece2D piece:design.getListPieces())
				if(piece.getPiecetype().isFacade())
					facades.add(piece);
			}
			facedesCoupe = Util.compactPieces2D(facades);
			
		}
		
		binding.put("$facades$", facedesCoupe);
		this.binding.put("$isShowFacades$", isShowFacades);
		Map<DesignObject3D,List<PieceCoupe>> elementsPieces =new HashMap<DesignObject3D, List<PieceCoupe>>();
		if(isShowPieces) {
			for(DesignObject3D design: elements) {
				List<Piece2D> pieces=design.getListPieces();
				List<PieceCoupe> piecesCoupe=new ArrayList<PieceCoupe>();
				piecesCoupe= Util.compactPieces2D(pieces);
				elementsPieces.put(design, piecesCoupe);
			}
		}
		binding.put("$elementsPieces$", elementsPieces);

		binding.put("$elements$", elements);
		binding.put("$fake_facades$", fakeFacades);
		binding.put("$capture$", this.screenShotURI);
		elementsReport = new HashMap<DesignObject3D, ElementReport>();
		links = new HashMap<ElementReport, String>();
		String tmpFolderPath = "elements";
		for(KitchenElement element: project.getKitchens().get(0).getScene().getKitchenElements()) {
			ElementReport eltReport = new ElementReport(element);
			eltReport.setReportDir(reportDir);
			try {
				eltReport.setPathToBackImg(picturesPath.get(element)[0]);
				eltReport.setPathToFrontImg(picturesPath.get(element)[1]);
			}catch (Exception e) {
				System.out.println("error in fetching element pictures!");
			}
			eltReport.bind();
			eltReport.generate(false);
			elementsReport.put(element.getDesignObject(), eltReport);
			UUID id = UUID.randomUUID();
			String path = tmpFolderPath + File.separator + id + ".html";
			links.put(eltReport, path);
		}
		binding.put("$reports$", elementsReport);
		binding.put("$links$", links);
		binding.put("$kitchen$",  project.getKitchens().get(0));
	}

	private void replaceAccessoiresImages() {
		for(ArticleCoupe acc:accessoires) {
			putAccesoireImgInServer(acc);
		}
		for(ArticleCoupe acc:quincailleries) {
			putAccesoireImgInServer(acc);
		}
	}

	private void putAccesoireImgInServer(ArticleCoupe acc) {
		if(acc.isImageExist()) {
			File origin=new File(acc.getImagePath());
			File imgDestination = new File(reportDir + File.separator +"acc_"+ origin.getName()); 
			try {
				IOUtilities.copyFileUsingChannel(origin, imgDestination);
				acc.setImagePath(WorkspaceConfiguration.JETTY_HOST + "/" + imgDestination.getName());
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}

	@Override
	public void loadTemplate() {
		loadTemplateFile(this.template_path);
	}

	@Override
	public void writeAndDisplay() {
		String rootFolder = ProjectManager.getManager().getCurrentProjectDirectory() + File.separator + "reporting";
		String path = rootFolder + File.separator + "debitage";
		if(path!= null && !path.isEmpty()) {
			path +=".html";
			File file = new File(path);
			File tmpFolder;
			try {
				file.createNewFile();
				tmpFolder = file.getParentFile();
				tmpFolder.mkdir();
				writeElementReports(tmpFolder);
				FileOutputStream fos = new FileOutputStream(file);
				fos.write(doc.toString().getBytes());
				fos.close();
				String fileURI = WorkspaceConfiguration.JETTY_HOST + "/" + file.getName();
				System.out.println(fileURI);
				JettyServer.getInstance().restart(rootFolder);
				URI url = new URI(fileURI);
				Desktop.getDesktop().browse(url);
			}catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	private void writeElementReports(File tmpFolder) {
		for(KitchenElement element: project.getKitchens().get(0).getScene().getKitchenElements() ) {
			ElementReport report = elementsReport.get(element.getDesignObject());
			String path = tmpFolder.getAbsolutePath() + File.separator +  links.get(report);
			try {
				File file = new File(path);
				file.getParentFile().mkdirs();
				file.createNewFile();
				FileOutputStream fos = new FileOutputStream(file);
				fos.write(report.getDoc().toString().getBytes());
				fos.close();
			}catch (Exception e) {
				System.out.println("failed to write element report");
				continue;
			}
		}
	}
	private void generateAccessoiresAndQuincailleries() {
		
		Map<param.Accessoire, ArticleCoupe> articlesAccessoiresCoupe = new HashMap<param.Accessoire, ArticleCoupe>();
		Map<param.Quincaillerie, ArticleCoupe> articlesQuincailleriesCoupe = new HashMap<param.Quincaillerie, ArticleCoupe>();
		for (Kitchen kitchen : project.getKitchens()) {
			for(DesignObject3D dress :kitchen.getElements())
			{
				generateElementAccessoires(accessoires, quincailleries, articlesAccessoiresCoupe,articlesQuincailleriesCoupe, dress);
			}
		}
	}
	
	/**
	 * @param accessoires
	 * @param quincailleries
	 * @param articlesAccessoiresCoupe
	 * @param articlesQuincailleriesCoupe
	 * @param dress
	 */
	public void generateElementAccessoires(ArrayList<ArticleCoupe> accessoires, ArrayList<ArticleCoupe> quincailleries,
			Map<param.Accessoire, ArticleCoupe> articlesAccessoiresCoupe,
			Map<param.Quincaillerie, ArticleCoupe> articlesQuincailleriesCoupe, DesignObject3D dress) {
		ArrayList<ModelAccessoire> dressAccessoires = ((Space3DFree) dress).getAccessoires();
		ArrayList<ModelQuincaillerie> dressQuincailleries = ((Space3DFree) dress).getQuincailleries();

		// grouper accessoires
		for (ModelAccessoire accessoire : dressAccessoires) {
			if(accessoire.getAccessoire().getAccessoire()==null|| accessoire.getAccessoire().getAccessoire().eIsProxy()) {
				continue;
			}
			if (!articlesAccessoiresCoupe.containsKey(accessoire.getAccessoire().getAccessoire())) {
				ArticleCoupe artcoupe = new ArticleCoupe(accessoire, 1);
				articlesAccessoiresCoupe.put(accessoire.getAccessoire().getAccessoire(), artcoupe);
				accessoires.add(artcoupe);
			} else {
				ArticleCoupe artCoupe = articlesAccessoiresCoupe.get(accessoire.getAccessoire().getAccessoire());
				artCoupe.setNumber(artCoupe.getNumber() + accessoire.getNumber());
			}
		}

		// grouper quincailleries
		for (ModelQuincaillerie quicaillerie : dressQuincailleries) {
			if(quicaillerie.getQuincaillerie().getQuincaillerie()==null|| quicaillerie.getQuincaillerie().getQuincaillerie().eIsProxy()) {
				continue;
			}
			if (!articlesQuincailleriesCoupe.containsKey(quicaillerie.getQuincaillerie().getQuincaillerie())) {
				ArticleCoupe artcoupe = new ArticleCoupe(quicaillerie, 1);
				articlesQuincailleriesCoupe.put(quicaillerie.getQuincaillerie().getQuincaillerie(), artcoupe);
				quincailleries.add(artcoupe);
			} else {
				ArticleCoupe artCoupe = articlesQuincailleriesCoupe
						.get(quicaillerie.getQuincaillerie().getQuincaillerie());
				artCoupe.setNumber(artCoupe.getNumber() + quicaillerie.getNumber());
			}
		}
	}
}
