package reporting.data.handle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.badlogic.gdx.math.Vector3;

import dressing.cam.model.PlanUsinage;
import dressing.cam.model.Util;
import dressing.config.ReportingPreferences;
import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.model.Solide3D;
import dressing.model.ui.util.CommonStringExtractor;
import dressing.reporting.data.handle.DressingChantGroup;
import dressing.ui.util.StaticUiObjects;
import param.Chant;
import param.Material;

public class PieceCoupe {
	
	List<Piece2D> pieces=new ArrayList<Piece2D>();
	String name;

	private int qty=1;
	private double epaisseur;
	int number;
	private BigDecimal pieceL;
	private BigDecimal pieceH;
	private Vector3 dim;
	private String sLongeur;
	private String sLargeur;
	private String SEppaisseur;
	private String material;
	private Material materialpiece;
	private Map<PlanUsinage,Chant> chants;

	public PieceCoupe(String name,Piece2D piece) {
		super();
		this.name = name;
		boolean isSenseFil = ReportingPreferences.getInstance().getProperty("report.SenseFil", true);
		boolean ispredebitchant = ReportingPreferences.getInstance().getProperty("report.predebitchant", true);
		boolean isSenseFilInverse = ReportingPreferences.getInstance().getProperty("report.SenseFilInverse", false);
		dim = Util.getMaterialDependentDimention(piece, isSenseFil, ispredebitchant,isSenseFilInverse);
		this.pieceL =new BigDecimal(dim.x,Util.context) ;
		this.pieceH = new BigDecimal(dim.y,Util.context) ;
		this.material = piece.getMaterial().getName();
		this.epaisseur=dim.z;
		this.materialpiece=piece.getMaterial();
		this.sLongeur=StaticUiObjects.decimalCotationFormat.format(this.pieceL.doubleValue()).replace(",", ".");
		this.sLargeur=StaticUiObjects.decimalCotationFormat.format(this.pieceH.doubleValue()).replace(",", ".");
		this.SEppaisseur=StaticUiObjects.decimalCotationFormat.format(this.epaisseur).replace(",", ".");
		//
		this.sLongeur=cleanDecimal(sLongeur);
		this.sLargeur=cleanDecimal(sLargeur);
		this.SEppaisseur=cleanDecimal(SEppaisseur);
		//
		
		this.chants=Util.getChants(piece, this.pieceL.compareTo(new BigDecimal(Util.getPieceL(piece, piece.getPrimaryPrespective()), Util.context))!=0);
		this.pieces.add(piece);
	}
	public List<Piece2D> getPieces() {
		return pieces;
	}
	public void setPieces(List<Piece2D> pieces) {
		this.pieces = pieces;
	}
	public String getName() {
		return name;
	}
	public String cleanDecimal(String input) {
	    if (input.endsWith(".0")) {
	        return input.substring(0, input.length() - 2);
	    }
	    return input;
	}
	public String getcompactedName() {
		List<String[]> nameparts=new ArrayList<String[]>();
		if(pieces.size()>1) {
			for(Solide3D piece:pieces) {
				nameparts.add(((DesignObject3D) piece).getName().split(" "));
			}
			String[] compactedArray=CommonStringExtractor.extractCommonStrings(nameparts);
			String compoactedname=compactedArray.length>0?String.join(" ",compactedArray ):name;
			return compoactedname;
			
		}else {
			return name;
		}
	}
	public void setName(String name) {
		this.name = name;
	}

	public BigDecimal getPieceL() {
		return pieceL;
	}
	public void setPieceL(BigDecimal pieceL) {
		this.pieceL = pieceL;
	}
	public BigDecimal getPieceH() {
		return pieceH;
	}
	public void setPieceH(BigDecimal pieceH) {
		this.pieceH = pieceH;
	}
	public Vector3 getDim() {
		return dim;
	}
	public void setDim(Vector3 dim) {
		this.dim = dim;
	}
	public String getsLongeur() {
		return sLongeur;
	}
	public void setsLongeur(String sLongeur) {
		this.sLongeur = sLongeur;
	}
	public String getsLargeur() {
		return sLargeur;
	}
	public void setsLargeur(String sLargeur) {
		this.sLargeur = sLargeur;
	}
	public String getSEppaisseur() {
		return SEppaisseur;
	}
	public void setSEppaisseur(String sEppaisseur) {
		SEppaisseur = sEppaisseur;
	}

	public void setChants(Map<PlanUsinage, Chant> chants) {
		this.chants = chants;
	}
	public String getMaterial() {
		return material;
	}
	public void setMaterial(String material) {
		this.material = material;
	}
	public int getQty() {
		return qty;
	}
	public void setQty(int qty) {
		this.qty = qty;
	}
	
	public Material getMaterialpiece() {
		return materialpiece;
	}
	public void setMaterialpiece(Material materialpiece) {
		this.materialpiece = materialpiece;
	}
	public double getEpaisseur() {
		return epaisseur;
	}
	public void setEpaisseur(double epaisseur) {
		this.epaisseur = epaisseur;
	}
	public boolean contains(Piece2D piece) {
		boolean isSenseFil = ReportingPreferences.getInstance().getProperty("report.SenseFil", true);
		boolean ispredebitchant = ReportingPreferences.getInstance().getProperty("report.predebitchant", true);
		boolean isSenseFilInverse = ReportingPreferences.getInstance().getProperty("report.SenseFilInverse", false);
		Vector3 dim = Util.getMaterialDependentDimention(piece, isSenseFil, ispredebitchant,isSenseFilInverse);
		// check material and dimension
		BigDecimal l=new BigDecimal(dim.x, Util.context);
		BigDecimal h=new BigDecimal(dim.y, Util.context);

		if (!piece.getMaterial().equals(getMaterialpiece())) {
			return false;
		}
		if (l.compareTo(getPieceL()) != 0) {
			return false;
		}
		if (h.compareTo(getPieceH()) != 0) {
			return false;
		}
		Map<PlanUsinage, Chant> chants = Util.getChants(piece,
				l.compareTo(new BigDecimal(Util.getPieceL(piece, piece.getPrimaryPrespective()), Util.context)) != 0);

		// check chant left is equal or not
		if (this.chants.get(PlanUsinage.LEFT) == null) {
			if (chants.get(PlanUsinage.LEFT) != null) {
				return false;
			}
		} else if (!this.chants.get(PlanUsinage.LEFT).equals(chants.get(PlanUsinage.LEFT))) {
			return false;
		}
		// check chant right is equal or not

		if (this.chants.get(PlanUsinage.RIGHT) == null) {
			if (chants.get(PlanUsinage.RIGHT) != null) {
				return false;
			}
		} else if (!this.chants.get(PlanUsinage.RIGHT).equals(chants.get(PlanUsinage.RIGHT))) {
			return false;
		}
		// check chant Top is equal or not

		if (this.chants.get(PlanUsinage.TOP) == null) {
			if (chants.get(PlanUsinage.TOP) != null) {
				return false;
			}
		} else if (!this.chants.get(PlanUsinage.TOP).equals(chants.get(PlanUsinage.TOP))) {
			return false;
		}
		// check chant Bottom is equal or not

		if (this.chants.get(PlanUsinage.DOWN) == null) {
			if (chants.get(PlanUsinage.DOWN) != null) {
				return false;
			}
		} else if (!this.chants.get(PlanUsinage.DOWN).equals(chants.get(PlanUsinage.DOWN))) {
			return false;
		}

		if (pieces.contains(piece)) {
			return true;
		}
		return true;
	}
	public void addPiece(Piece2D piece) {
		this.qty+=1;
		this.pieces.add(piece);
	}
	public int getNumber() {
		return number;
	}

	public void setNumber(int index) {
		this.number = index;
		for(Solide3D piece:pieces) {
			((Piece2D)piece).setFichedebitNumber(index);
		}
	}
	public Map<PlanUsinage, Chant> getChants() {
		return chants;
	}


	public void addchantsToGroups(List<DressingChantGroup> chantgroups, HashMap<Chant, DressingChantGroup> chantDressingGroups) {
		for (Piece2D piece : pieces) {
			BigDecimal l=new BigDecimal(dim.x, Util.context);
			BigDecimal h=new BigDecimal(dim.y, Util.context);
			Map<PlanUsinage, Chant> chants = Util.getChants(piece,
					l.compareTo(new BigDecimal(Util.getPieceL(piece, piece.getPrimaryPrespective()), Util.context)) != 0);
			Chant chantLeft = chants.get(PlanUsinage.LEFT);
			if (chantLeft != null) {
				if (chantDressingGroups.containsKey(chantLeft)) {
					chantDressingGroups.get(chantLeft).addLength(this.pieceH.movePointLeft(3).doubleValue() );
				} else {
					DressingChantGroup chantGroup = new DressingChantGroup(chantLeft,this.pieceH.movePointLeft(3).doubleValue());
					chantgroups.add(chantGroup);
					chantDressingGroups.put(chantLeft, chantGroup);
				}
			}
			Chant chantRight = chants.get(PlanUsinage.RIGHT);
			if (chantRight != null) {
				if (chantDressingGroups.containsKey(chantRight)) {
					chantDressingGroups.get(chantRight).addLength(this.pieceH.movePointLeft(3).doubleValue());
				} else {
					DressingChantGroup chantGroup = new DressingChantGroup(chantRight,this.pieceH.movePointLeft(3).doubleValue());
					chantgroups.add(chantGroup);
					chantDressingGroups.put(chantRight, chantGroup);
				}
			}

			Chant chantTop = chants.get(PlanUsinage.TOP);
			if (chantTop != null) {
				if (chantDressingGroups.containsKey(chantTop)) {
					chantDressingGroups.get(chantTop).addLength(this.pieceL.movePointLeft(3).doubleValue());
				} else {
					DressingChantGroup chantGroup = new DressingChantGroup(chantTop,this.pieceL.movePointLeft(3).doubleValue());
					chantgroups.add(chantGroup);
					chantDressingGroups.put(chantTop, chantGroup);
				}
			}

			Chant chantBottom = chants.get(PlanUsinage.DOWN);
			if (chantBottom != null) {
				if (chantDressingGroups.containsKey(chantBottom)) {
					chantDressingGroups.get(chantBottom)
							.addLength(this.pieceL.movePointLeft(3).doubleValue());
				} else {
					DressingChantGroup chantGroup = new DressingChantGroup(chantBottom,this.pieceL.movePointLeft(3).doubleValue());
					chantgroups.add(chantGroup);
					chantDressingGroups.put(chantBottom, chantGroup);
				}
			}
		}
	}
}
