package dressing.ui.util;

import java.util.List;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wb.swt.ResourceManager;

public abstract class ListEditorWindow extends Window{

	
	public ListEditorWindow(Shell parentShell) {
		super(parentShell);
		setShellStyle(SWT.SHELL_TRIM| SWT.APPLICATION_MODAL);
		setBlockOnOpen(true);
	}

	public Shell shell;
	public List<Action> actions;
	
	protected static ListEditorWindow instance;
	protected Button btnAdd;
	protected Button btnDelete;
	protected Composite buttonAreaComposite;
	protected Composite cleantAreaComposite;
	protected Button btnModify;
	protected Button btnView;
	protected Composite clientArea;
	protected TableViewer tableViewer;
	private Table table;
	protected Composite searchArea;
	protected ViewerFilter searchFilter;
	protected Object selection=null;
	protected boolean isSelect=false;
	public List<Action> getActions() {
		return actions;
	}
	public void setActions(List<Action> actions) {
		this.actions = actions;
	}
	@Override
	protected boolean canHandleShellCloseEvent() {
		return true;
	}

	public void finish() {
		if(!this.cleantAreaComposite.isDisposed()) {
			this.cleantAreaComposite.dispose();
		}
		System.gc();
		setReturnCode(OK);
		close();
	}

	protected void fermer() {
		setReturnCode(CANCEL);
		close();
		if(!this.cleantAreaComposite.isDisposed()) {
			this.cleantAreaComposite.dispose();
		}
	}
	@Override
	protected void handleShellCloseEvent() {
		fermer();
	}

	@Override
	public void create() {
		// TODO Auto-generated method stub
		super.create();
		constrainShellSize();
		getShell().setImage(ResourceManager.getPluginImage("Dressing", "icons/icon-supercad32.jpg"));
		getShell().setMaximized(true);
	}
	/**  
	 * Create contents of the window.
	 * @return 
	 */
	protected Control createContents(Composite parent) {
		parent.setTouchEnabled(true);
		this.shell=parent.getShell();
		parent.getShell().setText("Liste");
		shell.addShellListener(getShellListener());

		Composite composite = new Composite(parent, SWT.FILL);
		composite.setTouchEnabled(true);
		composite.setLayout(new GridLayout(1, false));
		
		searchArea = createSearchArea(composite, SWT.BORDER);

		cleantAreaComposite = createClientArea(composite, SWT.FULL_SELECTION);
		GridData gd_composite_1 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
//		gd_composite_1.widthHint = 266;
//		gd_composite_1.heightHint = 192;
		cleantAreaComposite.setLayoutData(gd_composite_1);
		
		buttonAreaComposite = createButtonArea(composite);
		GridData gd_composite_2 = new GridData(SWT.RIGHT, SWT.BOTTOM, false, false, 1, 1);
		gd_composite_2.heightHint = 50;
		buttonAreaComposite.setLayoutData(gd_composite_2);
		//
		composite.setTabList(new Control[]{cleantAreaComposite, buttonAreaComposite});

		ControlAdapter adaptor=new ControlAdapter() {

			@Override
			public void controlResized(ControlEvent e) {
				 Rectangle area2= ListEditorWindow.this.getShell().getClientArea();
			     composite.setBounds(area2);
			     Rectangle area = cleantAreaComposite.getClientArea();
			     int width = area.width - 2*table.getBorderWidth();
			     Point vBarSize = table.getVerticalBar().getSize();
			      if(table.getVerticalBar().isVisible())
			      {
			    	  width -= vBarSize.x;
			      }
			      Point oldSize = table.getSize();
			      if (oldSize.x > area.width) {
			        // table is getting smaller so make the columns 
			        // smaller first and then resize the table to
			        // match the client area width
			    	table.getColumns()[0].setWidth(300);;
			    	for(int i=1;i<table.getColumnCount();i++) {
			    		table.getColumns()[i].setWidth((width-300)/(table.getColumnCount()-1));;
			    	}
			        table.setSize(area.width, area.height);
			      } else {
			        // table is getting bigger so make the table 
			        // bigger first and then make the columns wider
			        // to match the client area width
			        table.setSize(area.width, area.height);
			        table.getColumns()[0].setWidth(300);;
			        for(int i=1;i<table.getColumnCount();i++) {
			    		table.getColumns()[i].setWidth((width-300)/(table.getColumnCount()-1));;
			    	}

			      }
			}
			
		};
		parent.addControlListener(adaptor);
		composite.addControlListener(adaptor);
		getShell().addControlListener(adaptor);		
		updateButtons();
		searchFilter = createListFilter();
		if(searchFilter!=null)
		{
			tableViewer.addFilter(searchFilter);
		}
		return composite;

	}
	
	protected abstract ViewerFilter createListFilter();
	protected abstract Composite createSearchArea(Composite parent,int style);
	
	protected Composite createClientArea(Composite parent,int style) {
		clientArea = new Composite(parent, SWT.BORDER);
		clientArea.setLayout(new GridLayout(1, false));
		clientArea.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		tableViewer = new TableViewer(clientArea,style|SWT.VIRTUAL);
		table = tableViewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		tableViewer.setContentProvider(new ILazyContentProvider() {
		    private List<Object> elements;

		    @Override
		    public void updateElement(int index) {
		    	tableViewer.replace(elements.get(index), index);
		    }

		    @Override
		    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		        elements = (List<Object>) newInput;
		    }

		    @Override
		    public void dispose() {}
		});
		
		createColums(tableViewer);
		refresh();

		tableViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				updateButtons();
				
			}
		});
		tableViewer.addOpenListener(new IOpenListener() {
			
			@Override
			public void open(OpenEvent event) {
				if(isSelect()) {
					IStructuredSelection selection=tableViewer.getStructuredSelection();
					if(selection!=null && !selection.isEmpty()) {
						ListEditorWindow.this.selection=selection.getFirstElement();
						ListEditorWindow.this.finish();
					}
				}
			}
		});
		
		return clientArea;
	}
	public void refresh() {	
		table.setRedraw(false);
	    try {
	        List<Object> input = getInput();
	        tableViewer.setInput(input);
	        tableViewer.setItemCount(input.size());
	    } finally {
	        table.setRedraw(true);
	    }
	}
	public abstract List getInput();
	public abstract void  createColums(TableViewer tableViewer);
	
	public static TableViewerColumn createColumn(TableViewer tableViewer,String title,boolean moveable,Image image,int alignment,ColumnLabelProvider labelprovider,ViewerComparator columnSorter) {
		TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerColumn.setLabelProvider(labelprovider);
		TableColumn tblclmn = tableViewerColumn.getColumn();
		tblclmn.setAlignment(alignment);
		tblclmn.setMoveable(moveable);
		tblclmn.setText(title);
		tblclmn.setImage(image);
		tblclmn.addSelectionListener(new SelectionAdapter() {
		    @Override
		    public void widgetSelected(SelectionEvent e) {
		    	Table table =tableViewer.getTable();
		    	if(table.getSortColumn()==tblclmn) {
		    		int oldsortdirection =table.getSortDirection();
		    		if(oldsortdirection==SWT.DOWN) {
		    			table.setSortDirection( SWT.UP );
		    		}else {
		    			table.setSortDirection( SWT.DOWN );
		    		}
		    	}else {
		    		table.setSortDirection( SWT.DOWN );
		    	}
		        tableViewer.getTable().setSortColumn( tblclmn);
		        tableViewer.setComparator(columnSorter);
		        tableViewer.refresh();
		    }
		});
		
		return tableViewerColumn;
	}
	protected Composite createButtonArea(Composite parent) {
		Composite composite= new Composite(parent, SWT.NONE);
		GridLayout gl_composite_2 = new GridLayout(5, false);
		gl_composite_2.horizontalSpacing = 0;
		composite.setLayout(gl_composite_2);
		
		btnAdd = new Button(composite, SWT.NONE);
		btnAdd.setImage(ResourceManager.getPluginImage("Dressing", "icons/ajout.png"));
		GridData gd_btnRun = new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1);
		gd_btnRun.heightHint = 100;
		btnAdd.setLayoutData(gd_btnRun);

		btnAdd.setText("Ajouter");
		btnAdd.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				Add();
			}
			
		});
		btnModify = new Button(composite, SWT.NONE);
		btnModify.setImage(ResourceManager.getPluginImage("Dressing", "icons/icons8-edit-16.png"));
		GridData gd_btnModify = new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1);
		gd_btnModify.heightHint = 50;
		btnModify.setLayoutData(gd_btnModify);

		btnModify.setText("Modifier");
		btnModify.addSelectionListener(new SelectionAdapter() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				Modify();
			}
			
		});
		btnView = new Button(composite, SWT.NONE);
		btnView.setImage(ResourceManager.getPluginImage("Dressing", "icons/icons8-eye-16.png"));
		GridData gd_btnView = new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1);
		gd_btnView.heightHint = 50;
		btnView.setLayoutData(gd_btnView);

		btnView.setText("Voir");
		btnView.addSelectionListener(new SelectionAdapter() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				view();
			}
			
		});
		btnDelete = new Button(composite, SWT.NONE);
		btnDelete.setImage(ResourceManager.getPluginImage("Dressing", "icons/cancel_22X22.png"));
		GridData gd_btnFermer = new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1);
		gd_btnFermer.heightHint = 50;
		btnDelete.setLayoutData(gd_btnFermer);
		btnDelete.setText("Supprimer");
		
		btnDelete.addSelectionListener(new SelectionAdapter() {
		
					@Override
					public void widgetSelected(SelectionEvent e) {
						// TODO Auto-generated method stub
						delete();
					}
					
				});
		
		return composite;
	}
	public synchronized void  show() {
		if(!shell.isDisposed())
		{
			ListEditorWindow.this.shell.setVisible(true);
			ListEditorWindow.this.shell.setActive();
			ListEditorWindow.this.shell.setMaximized(true);
		}

	}
	public synchronized void hide() {
		if(!shell.isDisposed())
		{
			
			ListEditorWindow.this.shell.setVisible(false);
		}

	}
	
	public Object getSelection() {
		return selection;
	}
	public void setSelection(Object selection) {
		this.selection = selection;
	}
	public boolean isSelect() {
		return isSelect;
	}
	public void setSelect(boolean isSelect) {
		this.isSelect = isSelect;
	}
	public Shell getShell() {
		return shell;
	}
	public void setShell(Shell shell) {
		this.shell = shell;
	}
	public Button getBtnRun() {
		return btnAdd;
	}
	public void setBtnRun(Button btnRun) {
		this.btnAdd = btnRun;
	}
	public Button getBtnFermer() {
		return btnDelete;
	}
	public void setBtnFermer(Button btnFermer) {
		this.btnDelete = btnFermer;
	}
	protected abstract void Add();
	protected abstract void Modify();
	protected abstract void delete();

	protected abstract void view();
	
	protected void updateButtons() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection==null || selection.isEmpty()) {
			btnModify.setEnabled(false);
			btnView.setEnabled(false);
			btnDelete.setEnabled(false);
		}else if(selection!=null && selection.size()>1){
			btnModify.setEnabled(false);
			btnView.setEnabled(false);
			btnDelete.setEnabled(true);
		}else {
			btnModify.setEnabled(true);
			btnView.setEnabled(true);
			btnDelete.setEnabled(true);
		}
		
	}

	public void createController() {
		
	}
	@Override
	protected Point getInitialSize() {
		
		return new Point(1280, 720);
	}
	
}
