package dressing.ui.parts;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import dressing.model.DesignObject3D;
import dressing.model.Trou;
import dressing.ui.DesignObject3DComposite;
import dressing.ui.TrouPropertiesComposite;

public class PropertiesPart {

Composite dynamiceditor=null;
@Inject ESelectionService selectionService;
Object editelement =null;
Composite parentcomposite=null;
public PropertiesPart() {
}

@Inject
private MDirtyable dirty;
/**
 * Create contents of the view part.
 */

@PostConstruct
public void createControls(Composite parent) {
	
	selectionService.addSelectionListener("dressing.part.projectexplorer",new ISelectionListener() {
		
		@Override
		public void selectionChanged(MPart part, Object selection) {

				if(selection instanceof Trou) {
					changeeditortoTrou(selection);
				}else if(selection instanceof DesignObject3D)
				{
					changeeditortoDefault(selection);
				}
			
		}

	});
	
	if(editelement==null)
	{
		parentcomposite = parent;
		dynamiceditor = new Composite(parentcomposite,  SWT.NONE);			
	}


}

@PreDestroy
public void dispose() {
	if(dynamiceditor!= null)
	{
		dynamiceditor.dispose();
		editelement = null;
	}
}

@Focus
public void setFocus() {
	// TODO	Set the focus to control
}

private void changeeditortoDefault(Object selection)
{
	if(dynamiceditor!=null && !dynamiceditor.isDisposed() && dynamiceditor instanceof DesignObject3DComposite ) {
		((DesignObject3DComposite)dynamiceditor).setDesignObject3D((DesignObject3D) selection);
		editelement = selection;
	}else {
		dispose();
		editelement = selection;
		dynamiceditor = new DesignObject3DComposite(parentcomposite,  SWT.NONE,(DesignObject3D) editelement);
		dynamiceditor.pack();
		parentcomposite.requestLayout();
	}
	
}
	private void changeeditortoTrou(Object selection)
	{
		if(dynamiceditor!=null && !dynamiceditor.isDisposed() && dynamiceditor instanceof TrouPropertiesComposite ) {
			((TrouPropertiesComposite)dynamiceditor).setTrou((Trou) selection);
			editelement = selection;
		}else {
			dispose();
			editelement = selection;
			dynamiceditor = new TrouPropertiesComposite(parentcomposite,  SWT.NONE,(Trou) editelement);
			dynamiceditor.pack();
			parentcomposite.requestLayout();
		}
	
	}

}
