package dressing.ui.palette;

import java.io.File;
import java.util.Date;
import java.util.List;

import org.eclipse.jface.viewers.ArrayContentProvider;

import dressing.config.ReportingPreferences;
import dressing.config.WorkspaceConfiguration;
import dressing.config.persistence.ResourceManagers;
import dressing.model.ModelProvider;
import param.Catalog;
import param.DesignClassGroup;
import param.DesignClasse;
import param.DesignInstance;
import param.MechanicDesign;
import param.MechanicDesignGroup;
import param.ModelRoot;

public class PaletteProvider {

	private  PaletteProject palette;
	private static PaletteProvider instance;
	public static PaletteProvider getInstance() {
		synchronized(PaletteProvider.class) {
			if (instance == null) {
				instance = new PaletteProvider();
			}
			return instance;
		}
	}
	public PaletteProject getPaletteRoot() {
		if(this.palette==null) {
			createPaletteProject();
		}
		return this.palette;
	}

	public void createPaletteProject() {
		long debut =new Date().getTime();
		palette = new PaletteProject();
		boolean isdev = ReportingPreferences.getInstance().getProperty("user.dev", false);

		List<ModelRoot> roots = ResourceManagers.getIntance().getModelroots();
		for(ModelRoot root:roots) {
			DesignClassGroup classes = root.getClasses();
			if (classes != null && classes.getDesignClasse() != null && classes.getDesignClasse().size() > 0) {
				for (DesignClasse classe : classes.getDesignClasse()) {
					PaletteGroup grp2 = new PaletteGroup(classe.getName()+" ("+root.getName()+")");
					grp2.setData(classe);
					grp2.setModifiable(false);
					grp2.setDeletable(false);
					if (classe.getCategorie() != null && classe.getCategorie().size() > 0) {
						for (MechanicDesignGroup famille : classe.getCategorie()) {
							if (famille != null && famille.getMechanicdesign() != null && famille.isPublic()) {
								PaletteGroup grp3 = new PaletteGroup(famille.getName());
								grp3.setData(famille);
								grp3.setModifiable(false);
								grp3.setDeletable(false);
								for (MechanicDesign design : famille.getMechanicdesign()) {
									if (design != null && design.isPublic()) {
										PaletteItem p = new PaletteItem(design.getName(),"dressing.command.addMechanicDesign");
										p.setData(design);
										grp3.getItems().add(p);
										p.setParent(grp3);
										if(design.getPreviewImagePath()!=null && design.getPreviewImagePath()!=null)
										{
											p.setImage(WorkspaceConfiguration.getIconsPath()+File.separator+design.getPreviewImagePath());
										}else {
											p.setImage(WorkspaceConfiguration.getIconsPath()+File.separator+"cube-64.png");
										}
										
										p.setModifiable(isdev);
										p.setDeletable(isdev);
										p.setExportcopy(true);
									}
								}
								for (DesignInstance design : famille.getDesignsintances()) {
									if (design != null && design.isPublic()) {
										PaletteItem p = new PaletteItem(design.getName(),"dressing.command.addMechanicDesign");
										p.setData(design);
										grp3.getItems().add(p);
										p.setParent(grp3);
										p.setModifiable(isdev);
										p.setDeletable(isdev);
										p.setExportcopy(false);
										if(design.getPerviewPath()!=null&& !design.getPerviewPath().isEmpty()) {
											p.setImage(WorkspaceConfiguration.getIconsPath()+File.separator+design.getPerviewPath());
										}else {
											p.setImage(WorkspaceConfiguration.getIconsPath()+File.separator+"cube-64.png");
										}
									}
								}
								if (famille.getPerviewPath() != null && !famille.getPerviewPath().isEmpty()) 
								{
									grp3.setImage(WorkspaceConfiguration.getIconsPath()+File.separator+famille.getPerviewPath());
								} else {
									String imagePath=WorkspaceConfiguration.getIconsPath()+File.separator+"icons8-folder-100.png";
									grp3.setImage(imagePath);
	
								}
								grp2.getPalettegroupes().add(grp3);
								grp3.setParent(grp2);
							}
						}
					}
					if (classe.getPerviewPath() != null && !classe.getPerviewPath().isEmpty()) 
					{
						grp2.setImage(WorkspaceConfiguration.getIconsPath()+File.separator+classe.getPerviewPath());
					} else {
						grp2.setImage(WorkspaceConfiguration.getIconsPath()+File.separator+"icons8-folder-100.png");
					}
					palette.getPalettegroupes().add(grp2);
					grp2.setParent(palette);
				}
	
			}
		}
		for (Catalog cat : ResourceManagers.getIntance().getCatalogs()) {
			PaletteGroup grp2 = new PaletteGroup(cat.getName() + " (" + cat.getOwner() + ")");
			grp2.setData(cat);
			grp2.setModifiable(true);
			grp2.setDeletable(true);
			if (cat.getCategorie() != null && !cat.getCategorie().isEmpty()) {
				for (MechanicDesignGroup famille : cat.getCategorie()) {
					if (famille != null && famille.getMechanicdesign() != null) {
						PaletteGroup grp3 = new PaletteGroup(famille.getName());
						grp3.setData(famille);
						grp3.setModifiable(true);
						grp3.setDeletable(true);
						for (MechanicDesign design : famille.getMechanicdesign()) {
							if (design != null && design.isPublic()) {
								PaletteItem p = new PaletteItem(design.getName(), "dressing.command.addMechanicDesign");
								p.setData(design);
								p.setModifiable(design.isChangeable());
								p.setDeletable(design.isDeleteable());
								p.setExportcopy(true);
								grp3.getItems().add(p);
								p.setParent(grp3);
								if(design.getPreviewImagePath()!=null && design.getPreviewImagePath()!=null)
								{
									p.setImage(WorkspaceConfiguration.getIconsPath()+File.separator+design.getPreviewImagePath());
								}else {
									p.setImage(WorkspaceConfiguration.getIconsPath()+File.separator+"cube-64.png");
								}
							}
						}
						for (DesignInstance design : famille.getDesignsintances()) {
							if (design != null) {
								PaletteItem p = new PaletteItem(design.getName(),"dressing.command.addMechanicDesign");
								p.setData(design);
								p.setModifiable(design.isChangeable());
								p.setDeletable(true);
								p.setExportcopy(true);
								grp3.getItems().add(p);
								p.setParent(grp3);
								if(design.getPerviewPath()!=null&& !design.getPerviewPath().isEmpty()) {
									p.setImage(WorkspaceConfiguration.getIconsPath()+File.separator+design.getPerviewPath());
								}else {
									p.setImage(WorkspaceConfiguration.getIconsPath()+File.separator+"cube-64.png");
								}
							}
						}
						if (famille.getPerviewPath() != null && !famille.getPerviewPath().isEmpty()) 
						{
							grp3.setImage(WorkspaceConfiguration.getIconsPath()+File.separator+famille.getPerviewPath());
						} else {
							grp3.setImage(WorkspaceConfiguration.getIconsPath()+File.separator+"icons8-folder-100.png");
						}
						grp2.getPalettegroupes().add(grp3);
						grp3.setParent(grp2);
					}
				}
			}
			if (cat.getPerviewPath() != null && !cat.getPerviewPath().isEmpty()) 
			{
				grp2.setImage(WorkspaceConfiguration.getIconsPath()+File.separator+cat.getPerviewPath());
			} else {
				grp2.setImage(WorkspaceConfiguration.getIconsPath()+File.separator+"icons8-folder-100.png");

			}
			palette.getPalettegroupes().add(grp2);
			grp2.setParent(palette);
		}
		System.err.println("end palette \t" +(new Date().getTime()-debut));
	}
	
}
