package dressing.ui.editorWindows;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import dressing.config.persistence.ResourceManagers;
import dressing.ui.PublicParamEditorComposite;
import dressing.ui.util.EditorWindow;
import param.MechanicDesign;
import param.MechanicPublicParam;
import param.Option;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.wb.swt.SWTResourceManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;

public class DesignOptionParamEditorWindow extends EditorWindow {
	
	private ScrolledComposite container;
	private Composite root;

	private Text txtName;
	private Option option;
	private Label lblLabel;
	private Text txtLabel;
	private Composite composite;
	private Map<MechanicPublicParam,PublicParamEditorComposite> dirtyParams=new HashMap<MechanicPublicParam,PublicParamEditorComposite>();
	private Map<MechanicPublicParam,PublicParamEditorComposite> ParamsCompositeMap=new HashMap<MechanicPublicParam,PublicParamEditorComposite>();

	public DesignOptionParamEditorWindow(Shell parentShell,int update,Option article) {
		super(parentShell,update);
		this.option = article;
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		parent.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		
		
		
		root = new Composite(parent, SWT.NONE);
		root.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		root.setLayout(new GridLayout(1, false));
		
		container = new ScrolledComposite(root, SWT.V_SCROLL);
		container.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		container.setExpandHorizontal(true);
		container.setExpandVertical(true);
		
		composite = new Composite(container, SWT.NONE);
		composite.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
//		tbtmGnral.setControl(container);
		composite.setLayout(new GridLayout(2, false));
		
		Label lblNom = new Label(composite, SWT.NONE);
		lblNom.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		lblNom.setText("Désignation");
		
		txtName = new Text(composite, SWT.BORDER);
		txtName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		lblLabel = new Label(composite, SWT.NONE);
		lblLabel.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		lblLabel.setText("Label");
		lblLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));

		txtLabel = new Text(composite, SWT.BORDER);
		txtLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		List<MechanicPublicParam> params=new ArrayList<MechanicPublicParam>();
		params.addAll(option.getInjectedPublicParam().getMechanicpublicparam());
		for(MechanicPublicParam param:params) {
			if(option.getGroup()!=null && option.getGroup().getParentDesign()!=null) {
				try {
					MechanicPublicParam designparam=	option.getGroup().getParentDesign().getPublicParam(param.getKey());
					param.setUserlabel(designparam.getUserlabel());
					param.setName(designparam.getName());
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			PublicParamEditorComposite paramEditor=new PublicParamEditorComposite(composite, SWT.NONE, param,dirtyParams,true); 
			ParamsCompositeMap.put(param, paramEditor);
		}
		
		container.setContent(composite);
		container.setMinSize(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		Point preferedSize = container.computeSize(SWT.DEFAULT, SWT.DEFAULT);
		int frameX = shell.getSize().x - shell.getClientArea().width;
		int frameY = shell.getSize().y - shell.getClientArea().height;
		shell.setSize(preferedSize.x + frameX + 50, preferedSize.y + frameY + 50);
		shell.setLocation((shell.getParent().getSize().x - shell.getSize().x) / 2 + shell.getParent().getLocation().x,
				(shell.getParent().getSize().y - shell.getSize().y) / 2 + shell.getParent().getLocation().y);
		String titleWindow = "d'Option Elément";


		this.shell.setText("Editeur " + titleWindow+": "+option.getName());
		shell.redraw();
		parent.requestLayout();

		initDataBindings();

		addControl(); 
		return root;
	}
	
	public void updateParamValues() {
		for(MechanicPublicParam designParam : dirtyParams.keySet()) {
			MechanicPublicParam optionParam = option.getInjectedPublicParam().getParam(designParam.getKey());
			if(optionParam==null) {
				optionParam = EcoreUtil.copy(designParam);
				option.getInjectedPublicParam().getMechanicpublicparam().add(optionParam);
			}
			dirtyParams.get(designParam).updateValues(optionParam);

		}
	}
	
	public void addControl() {

	}
	@Override
	public boolean terminer() {
		if(!super.terminer()) {
			return false;
		}
		updateParamValues();
		ResourceManagers.getIntance().saveLibraryResource();

		finish();
		return true;
	}
	
	@Override
	public boolean check() {
		errorExist=false;
		errorMessage="";
		String name =txtName.getText().trim();
		if(name==null || name.isEmpty()) {
			errorExist=true;
			errorMessage="Le nom est obligatoire";
		}
		
		return !errorExist;
	}
	public ScrolledComposite getContainer() {
		return container;
	}

	public void setContainer(ScrolledComposite container) {
		this.container = container;
	}

	public Composite getRoot() {
		return root;
	}

	public void setRoot(Composite root) {
		this.root = root;
	}
	
	@Override
	protected void cancel() {

		
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTxtNameObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtName);
		IObservableValue nameAccessoireObserveValue = BeanProperties.value("name").observe(option);
		bindingContext.bindValue(observeTextTxtNameObserveWidget, nameAccessoireObserveValue, null, null);
		//
		IObservableValue observeTexttxtLabelObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtLabel);
		IObservableValue labelAccessoireObserveValue = BeanProperties.value("label").observe(option);
		bindingContext.bindValue(observeTexttxtLabelObserveWidget, labelAccessoireObserveValue, null, null);
		//
		return bindingContext;
	}
}
