package dressing.ui;

import java.util.List;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;

import dressing.ui.editorWindows.DesignOptionParamEditorWindow;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.ListEditorWindow;
import param.Option;
import param.OptionGroup;

public class OptionParamsListWindow extends ListEditorWindow {

	private TableColumn tblclmnLabel;
	private TableViewerColumn tableViewerColumnLabel;
	private TableColumn tblclmnName;
	private TableViewerColumn tableViewerColumnName;
	private OptionGroup optionGroup;
	public OptionParamsListWindow(Shell parentShell,OptionGroup optionGroup) {
		super(parentShell);
		this.optionGroup=optionGroup;
	}

	@Override
	protected Composite createClientArea(Composite parent,int style) {
		Composite clientArea = super.createClientArea(parent, style|SWT.MULTI);
		getShell().setText("Liste des Options");
		return clientArea;
	}
	
	public void createColums(TableViewer tableViewer) {
		tableViewerColumnName = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerColumnName.setLabelProvider(new ColumnLabelProvider() {
			public Image getImage(Object element) {
				// TODO Auto-generated method stub
				return null;
			}
			public String getText(Object element) {
				if(element !=null && element instanceof Option ) {
					return ((Option)element).getName();
				}
				return "";
			}
		});
		tblclmnName = tableViewerColumnName.getColumn();
		tblclmnName.setAlignment(SWT.NONE);
		tblclmnName.setMoveable(true);
//		tblclmnName.setWidth(200);
		tblclmnName.setText("Nom");
		tblclmnName.setImage(null);
		//
		tableViewerColumnLabel = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerColumnLabel.setLabelProvider(new ColumnLabelProvider() {
			public Image getImage(Object element) {
				// TODO Auto-generated method stub
				return null;
			}
			public String getText(Object element) {
				if(element !=null && element instanceof Option ) {
					return ((Option)element).getLabel();
				}
				return "";
			}
		});
		tblclmnLabel = tableViewerColumnLabel.getColumn();
		tblclmnLabel.setAlignment(SWT.NONE);
		tblclmnLabel.setMoveable(true);
//		tblclmnEpaisseur.setWidth(200);
		tblclmnLabel.setText("Label");
		tblclmnLabel.setImage(null);
	}
	@Override
	protected void Add() {
		param.Option option= EcoreUtil.copy(optionGroup.getSelectedOption());
		DesignOptionParamEditorWindow designOptionWindow=new DesignOptionParamEditorWindow(getShell(),EditorWindow.update, option);
		designOptionWindow.create();
		int ret=designOptionWindow.open();
		if(ret==Window.OK) {
			optionGroup.getOptions().add(option);
			refresh();
		}
	}

	@Override
	protected void Modify() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof Option) {
			DesignOptionParamEditorWindow designOptionWindow=new DesignOptionParamEditorWindow(getShell(),EditorWindow.update, (Option) selection.getFirstElement() );
			designOptionWindow.create();
			int ret=designOptionWindow.open();
			if(ret==Window.OK) {
				refresh();
			}
		}
	}

	@Override
	protected void delete() {
		boolean ret = MessageDialog.openConfirm(shell, "Confirmation de supression","Voulez vous supprimer les composant sélectionner" );
		if(ret) {
			IStructuredSelection selection=tableViewer.getStructuredSelection();
			if(selection!=null&& !selection.isEmpty()) {
				List selections=selection.toList();
				for(Object obj:selections) {
					if(obj!=null && obj instanceof Option) {
						optionGroup.getOptions().remove(obj);
					}
				}
				refresh();
			}
		}
		

	}

	@Override
	protected void view() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof Option) {
			DesignOptionParamEditorWindow designOptionWindow=new DesignOptionParamEditorWindow(getShell(),EditorWindow.View, (Option) selection.getFirstElement() );
			designOptionWindow.create();
			int ret=designOptionWindow.open();
			if(ret==Window.OK) {
				tableViewer.refresh();
			}
		}
		

	}

	@Override
	protected void updateButtons() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection==null || selection.isEmpty()) {
			btnModify.setEnabled(false);
			btnView.setEnabled(false);
			btnDelete.setEnabled(false);
		}else if(selection!=null && selection.size()>1){
			btnModify.setEnabled(false);
			btnView.setEnabled(false);
			btnDelete.setEnabled(true);
		}else {
			btnModify.setEnabled(true);
			btnView.setEnabled(true);
			btnDelete.setEnabled(true);
		}
		
	}

	@Override
	public List<?> getInput() {
		return optionGroup.getOptions();
	}
	@Override
	protected Point getInitialSize() {
		return new Point(1280, 720);
	}

	protected void constrainShellSize() {
		// limit the shell size to the display size
		Rectangle bounds = shell.getBounds();
		bounds.width = 1024;
		bounds.height = 600;
		shell.setBounds(bounds);
		Rectangle parentSize = getShell().getParent().getBounds();
		Rectangle shellSize = getShell().getBounds();
		int locationX = (parentSize.width - shellSize.width) / 2 + parentSize.x;
		int locationY = (parentSize.height - shellSize.height) / 2 + parentSize.y;
		getShell().setLocation(new Point(locationX, locationY));
	}

	@Override
	protected ViewerFilter createListFilter() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	protected Composite createSearchArea(Composite parent, int style) {
		// TODO Auto-generated method stub
		return null;
	}
}
