package dressing.ui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import dressing.config.persistence.ResourceManagers;
import dressing.ui.util.DoubleToStringConvertor;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.NumericConvertor;
import param.MechanicDesign;
import param.ParamFamily;
import param.PublicParamGroup;

import java.util.stream.Collectors;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.window.Window;
import org.eclipse.wb.swt.SWTResourceManager;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import param.MechanicPublicParam;
import param.OptionGroup;
import param.ParamFactory;

import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.core.databinding.observable.list.IObservableList;

public class MechanicDesignParamFamilyConfigEditorWindow extends EditorWindow {
	private DataBindingContext m_bindingContext;

	private MechanicDesign design;
	private ParamFamily family;
	private Composite parentComposite;
	private Composite clientArea;
	private Text txtName;
	private Text txtLabel;
	private Group group;

	private Text colNumber;
	private Button btnExpandbar;
	private Button btnGroups;
	private Button btnTappedpane;
	private ListViewer listViewerParams;
	private PublicParamGroup designParamroup;

	private ListViewer listViewerDesignParams;

	private Button btnAddParam;

	private Button btnDeleteParam;

	private Button btnAddFamily;

	private Button btnDeleteFamily;

	private ListViewer listViewerChildFamilies;

	private Button btnModifyFamily;

	private Button btnIsUsinage;

	private Group groupControl;

	private Button btnIsVisible;

	public MechanicDesignParamFamilyConfigEditorWindow(Shell parentShell,MechanicDesign design,ParamFamily family,int update) {
		super(parentShell,update);
		
		this.design = design;
		this.designParamroup=this.design.getPublicparamgroup();
		this.family=family;
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		parentComposite=parent;
		clientArea = new Composite(parent, SWT.BORDER);
		clientArea.setLayout(new GridLayout(2, false));
		clientArea.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		Label lblName = new Label(clientArea, SWT.NONE);
		lblName.setText("Nom");
		
		txtName = new Text(clientArea, SWT.BORDER);
		txtName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblEp = new Label(clientArea, SWT.NONE);
		lblEp.setText("Label");
		
		txtLabel = new Text(clientArea, SWT.BORDER | SWT.WRAP);
		txtLabel.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		
		Label lblColNB = new Label(clientArea, SWT.NONE);
		lblColNB.setText("Nombre Colonnes");
		
		colNumber = DoubleTextFieldFactory.createDoubleTextField(clientArea, SWT.BORDER);;
		colNumber.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		//
		groupControl = new Group(clientArea, SWT.NONE);
		GridLayout gl_groupControl = new GridLayout(3, false);
		gl_groupControl.marginWidth = 0;
		gl_groupControl.verticalSpacing = 0;
		gl_groupControl.horizontalSpacing = 0;
		groupControl.setLayout(gl_groupControl);
		groupControl.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 2, 1));
		
		btnIsVisible = new Button(groupControl, SWT.CHECK);
		btnIsVisible.setText("Visible");
		
		btnIsUsinage = new Button(groupControl, SWT.CHECK);
		btnIsUsinage.setText("Usinage");
		//
		group = new Group(clientArea, SWT.NONE);
		GridLayout gl_group = new GridLayout(3, false);
		gl_group.marginWidth = 0;
		gl_group.verticalSpacing = 0;
		gl_group.horizontalSpacing = 0;
		group.setLayout(gl_group);
		group.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 2, 1));
		
		btnExpandbar = new Button(group, SWT.RADIO);
		btnExpandbar.setText("ExpandBar");
		
		btnGroups = new Button(group, SWT.RADIO);
		btnGroups.setText("Groups");
		
		btnTappedpane = new Button(group, SWT.RADIO);
		btnTappedpane.setText("TappedPane");
		
		ScrolledComposite scrolledComposite = new ScrolledComposite(clientArea, SWT.BORDER | SWT.H_SCROLL| SWT.V_SCROLL);
		scrolledComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		scrolledComposite.setExpandHorizontal(true);
		scrolledComposite.setExpandVertical(true);
		scrolledComposite.setAlwaysShowScrollBars(true);
		Composite composite = new Composite(scrolledComposite, SWT.NONE);
		composite.setLayout(new GridLayout(3, false));
		
		Label lblParamtres = new Label(composite, SWT.NONE);
		lblParamtres.setFont(SWTResourceManager.getFont("Arial Greek", 12, SWT.BOLD));
		lblParamtres.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, false, false, 1, 1));
		lblParamtres.setText("Paramètres");
		new Label(composite, SWT.NONE);
		
		Label lblDesignParamtres = new Label(composite, SWT.NONE);
		lblDesignParamtres.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, false, false, 1, 1));
		lblDesignParamtres.setText("Design Paramètres");
		lblDesignParamtres.setFont(SWTResourceManager.getFont("Arial Greek", 12, SWT.BOLD));
		
		listViewerParams = new ListViewer(composite, SWT.BORDER | SWT.V_SCROLL|SWT.MULTI);
		List listParams = listViewerParams.getList();
		listParams.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 5));
		new Label(composite, SWT.NONE);
		listViewerParams.setLabelProvider(new LabelProvider() {
			@Override
			public String getText(Object element) {
				if(element instanceof MechanicPublicParam) {
					return ((MechanicPublicParam) element).getUserlabel();
				}else if(element instanceof OptionGroup) {
					return ((OptionGroup) element).getName();
				}
				return super.getText(element);
			}
		});
		listViewerParams.setContentProvider(ArrayContentProvider.getInstance());
		
		listViewerDesignParams = new ListViewer(composite, SWT.BORDER | SWT.V_SCROLL|SWT.MULTI);
		List listDesignParams = listViewerDesignParams.getList();
		listDesignParams.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 5));
		new Label(composite, SWT.NONE);
		listDesignParams.setSize(300, 200);
		listParams.setSize(300, 200);
		btnAddParam = new Button(composite, SWT.NONE);
		btnAddParam.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnAddParam.setText("Ajouter");
		btnAddParam.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection=	listViewerDesignParams.getStructuredSelection();
				if(selection !=null && selection.getFirstElement()!=null && selection.getFirstElement() instanceof  MechanicPublicParam) {
					java.util.List<MechanicPublicParam> param2= selection.toList();
					family.getParams().addAll(param2);
					listViewerDesignParams.setInput(designParamroup.getMechanicpublicparam().stream().filter(param-> (param.isChangeable() && param.getFamily()==null)).collect(Collectors.toList()));
				}
			}
			
		});
		btnDeleteParam = new Button(composite, SWT.NONE);
		btnDeleteParam.setText("Supprimer");
		btnDeleteParam.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection=	listViewerParams.getStructuredSelection();
				if(selection !=null && selection.getFirstElement()!=null && selection.getFirstElement() instanceof  MechanicPublicParam) {
					@SuppressWarnings("unchecked")
					java.util.List<MechanicPublicParam> param2= selection.toList();
					family.getParams().removeAll(param2);
					param2.forEach(p->p.setFamily(null));
					listViewerDesignParams.setInput(designParamroup.getMechanicpublicparam().stream().filter(param-> (param.isChangeable() && param.getFamily()==null)).collect(Collectors.toList()));
				}
			}
			
		});
		new Label(composite, SWT.NONE);
		scrolledComposite.setContent(composite);
		scrolledComposite.setMinSize(700,200);
		scrolledComposite.setSize(700, 200);
		Composite composite_1 = new Composite(clientArea, SWT.NONE);
		composite_1.setLayout(new GridLayout(4, false));
		composite_1.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		
		Label lblFamilles = new Label(composite_1, SWT.NONE);
		lblFamilles.setText("Familles");
		
		btnAddFamily = new Button(composite_1, SWT.NONE);
		btnAddFamily.setText("Ajouter");
		btnAddFamily.addSelectionListener(new SelectionListener() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				ParamFamily subfamily=ParamFactory.eINSTANCE.createParamFamily();
				subfamily.setIsChildFamiliesGroups(true);
				subfamily.setNbColonne(2);
				MechanicDesignParamFamilyConfigEditorWindow mechanicDesignWindow=new MechanicDesignParamFamilyConfigEditorWindow(shell, design,subfamily,EditorWindow.update);
				mechanicDesignWindow.create();
				int ret=mechanicDesignWindow.open();
				if(ret==Window.OK) {
					MechanicDesignParamFamilyConfigEditorWindow.this.family.getSubFamilies().add(subfamily);
					listViewerDesignParams.setInput(designParamroup.getMechanicpublicparam().stream().filter(param-> (param.isChangeable() && param.getFamily()==null)).collect(Collectors.toList()));

					listViewerChildFamilies.refresh();
				}
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		btnModifyFamily = new Button(composite_1, SWT.NONE);
		btnModifyFamily.setText("Modifier");
		btnModifyFamily.addSelectionListener(new SelectionListener() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection=	listViewerChildFamilies.getStructuredSelection();
				if(selection !=null && selection.getFirstElement()!=null && selection.getFirstElement() instanceof  ParamFamily) {
					ParamFamily subfamily=(ParamFamily) selection.getFirstElement();
					MechanicDesignParamFamilyConfigEditorWindow mechanicDesignWindow=new MechanicDesignParamFamilyConfigEditorWindow(shell, design,subfamily,EditorWindow.update);
					mechanicDesignWindow.create();
					int ret=mechanicDesignWindow.open();
					listViewerChildFamilies.refresh();
					listViewerDesignParams.setInput(designParamroup.getMechanicpublicparam().stream().filter(param-> (param.isChangeable() && param.getFamily()==null)).collect(Collectors.toList()));

				
				}
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		btnDeleteFamily = new Button(composite_1, SWT.NONE);
		btnDeleteFamily.setText("Supprimer");
		btnDeleteFamily.addSelectionListener(new SelectionListener() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection=	listViewerChildFamilies.getStructuredSelection();
				if(selection !=null && selection.getFirstElement()!=null && selection.getFirstElement() instanceof  ParamFamily) {
					ParamFamily subfamily=(ParamFamily) selection.getFirstElement();
					family.getSubFamilies().remove(subfamily);
					listViewerChildFamilies.refresh();
					listViewerDesignParams.setInput(designParamroup.getMechanicpublicparam().stream().filter(param-> (param.isChangeable() && param.getFamily()==null)).collect(Collectors.toList()));

				}
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		listViewerChildFamilies = new ListViewer(composite_1, SWT.BORDER | SWT.V_SCROLL);
		List list = listViewerChildFamilies.getList();
		list.setSize(list.computeSize(SWT.DEFAULT, SWT.DEFAULT).x, 300);
		list.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 4, 1));
		if(design!=null) {
			m_bindingContext = initDataBindings();
		}
		listViewerDesignParams.setLabelProvider(new LabelProvider() {
			@Override
			public String getText(Object element) {
				if(element instanceof MechanicPublicParam) {
					return ((MechanicPublicParam) element).getUserlabel();
				}else if(element instanceof OptionGroup) {
					return ((OptionGroup) element).getName();
				}
				return super.getText(element);
			}
		});
		listViewerDesignParams.setContentProvider(ArrayContentProvider.getInstance());
		listViewerDesignParams.setInput(designParamroup.getMechanicpublicparam().stream().filter(param-> (param.isChangeable() && param.getFamily()==null)).collect(Collectors.toList()));
		listViewerChildFamilies.setLabelProvider(new LabelProvider() {
			@Override
			public String getText(Object element) {
				if(element instanceof ParamFamily) {
					return ((ParamFamily) element).getLabel();
				}
				return super.getText(element);
			}
		});
		listViewerChildFamilies.setContentProvider(ArrayContentProvider.getInstance());
		listViewerChildFamilies.setInput(family.getSubFamilies());
		
		shell.setSize(1280,720);
		shell.setLocation((shell.getParent().getSize().x - shell.getSize().x) / 2 + shell.getParent().getLocation().x,
				(shell.getParent().getSize().y - shell.getSize().y) / 2 + shell.getParent().getLocation().y);
		this.shell.setText("Editeur: Site");
		parent.requestLayout();
		return clientArea;
	}

	@Override
	public boolean terminer() {
		if(!super.terminer()) {
			return false;
		}

		ResourceManagers.getIntance().saveResource(design.eResource());;
		
		finish();
		return true;
	}
	
	@Override
	public boolean check() {
		errorExist=false;
		errorMessage="";
		String name =txtName.getText().trim();
		if(name==null || name.isEmpty()) {
			errorExist=true;
			errorMessage="Le nom est obligatoire";
		}
		String adresse =txtLabel.getText().trim();
		if(adresse==null || adresse.isEmpty()) {
			errorExist=true;
			errorMessage="Le Label est obligatoire";
		}
		return !errorExist;
	}

	
	@Override
	protected void cancel() {
////		this.site.setName(this.siteOrigin.getName());
//		this.site.setAdresse(this.siteOrigin.getAdresse());
//		
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTxtNameObserveWidget = WidgetProperties.text(SWT.Modify).observe(txtName);
		IObservableValue nameFamilyObserveValue = BeanProperties.value("name").observe(family);
		bindingContext.bindValue(observeTextTxtNameObserveWidget, nameFamilyObserveValue, null, null);
		//
		IObservableValue observeTextTxtLabelObserveWidget = WidgetProperties.text(SWT.Modify).observe(txtLabel);
		IObservableValue labelFamilyObserveValue = BeanProperties.value("label").observe(family);
		bindingContext.bindValue(observeTextTxtLabelObserveWidget, labelFamilyObserveValue, null, null);
		//
		IObservableValue observeTextColNumberObserveWidget = WidgetProperties.text(SWT.Modify).observe(colNumber);
		IObservableValue nbColonneFamilyObserveValue = BeanProperties.value("nbColonne").observe(family);
		UpdateValueStrategy strategy_2 = new UpdateValueStrategy();
		strategy_2.setConverter(new DoubleToStringConvertor());
		UpdateValueStrategy strategy_3 = new UpdateValueStrategy();
		strategy_3.setConverter(new NumericConvertor());
		bindingContext.bindValue(observeTextColNumberObserveWidget, nbColonneFamilyObserveValue, strategy_2, strategy_3);
		//
		IObservableValue observeSelectionBtnExpandbarObserveWidget = WidgetProperties.buttonSelection().observe(btnExpandbar);
		IObservableValue isChildFamiliesExpandBarFamilyObserveValue = BeanProperties.value("isChildFamiliesExpandBar").observe(family);
		bindingContext.bindValue(observeSelectionBtnExpandbarObserveWidget, isChildFamiliesExpandBarFamilyObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnGroupsObserveWidget = WidgetProperties.buttonSelection().observe(btnGroups);
		IObservableValue isChildFamiliesGroupsFamilyObserveValue = BeanProperties.value("isChildFamiliesGroups").observe(family);
		bindingContext.bindValue(observeSelectionBtnGroupsObserveWidget, isChildFamiliesGroupsFamilyObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnTappedpaneObserveWidget = WidgetProperties.buttonSelection().observe(btnTappedpane);
		IObservableValue isChildFamiliesTabbedPaneFamilyObserveValue = BeanProperties.value("isChildFamiliesTabbedPane").observe(family);
		bindingContext.bindValue(observeSelectionBtnTappedpaneObserveWidget, isChildFamiliesTabbedPaneFamilyObserveValue, null, null);
		//
		
		//
		IObservableValue observeSelectionBtnIsVisibleObserveWidget = WidgetProperties.buttonSelection().observe(btnIsVisible);
		IObservableValue visibleFamilyObserveValue = BeanProperties.value("visible").observe(family);
		bindingContext.bindValue(observeSelectionBtnIsVisibleObserveWidget, visibleFamilyObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnIsUsinageObserveWidget = WidgetProperties.buttonSelection().observe(btnIsUsinage);
		IObservableValue usinageFamilyObserveValue = BeanProperties.value("usinage").observe(family);
		bindingContext.bindValue(observeSelectionBtnIsUsinageObserveWidget, usinageFamilyObserveValue, null, null);
		//
		IObservableList paramsFamilyObserveList = BeanProperties.list("params").observe(family);
		listViewerParams.setInput(paramsFamilyObserveList);
		//
		
		return bindingContext;
	}
@Override
protected Point getInitialSize() {
	return new Point(1280, 720);
}
}
