package dressing.ui;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.config.ModulesPreferences;
import dressing.config.ReportingPreferences;
import dressing.model.DesignObject3D;
import param.Chant;
import param.Material;
import param.MaterialTypeInstance;
import param.MechanicDesign;
import param.MechanicDressing;
import param.MechanicPublicParam;
import param.Option;
import param.OptionGroup;
import param.PieceType;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IStructuredSelection;

public class MechanicDesignEditorComposite extends MechanicDeisgnEditorUtil {
	private DataBindingContext m_bindingContext;

	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 * @param rootspace 
	 * @param update
	 * @param isModel 
	 */
	public MechanicDesignEditorComposite(Composite parent, int style,MechanicDesign design, DesignObject3D rootspace, int update, boolean isModel) {
		super(parent, style);
		setLayout(new GridLayout(2, false));
		setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		this.design=design;
		this.rootspace=rootspace;
		this.update=update;
		this.ismodel=isModel;
		this.accessoiresGroup = design.getAccessoires();
		this.quincailleriesGroup = design.getQuincailleries();
		Label lblNom = new Label(this, SWT.NONE);
		lblNom.setText("Nom");
		lblNom.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		name = new Text(this, SWT.BORDER);
		name.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		name.setText(design.getName());
		tabFolder = new CTabFolder(this, SWT.BORDER);
		tabFolder.setHighlightEnabled(true);
		tabFolder.setSimple(false);
		tabFolder.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		tabFolder.setSelectionBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_BACKGROUND));
		tabFolder.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		tabFolder.setBorderVisible(true);

		if((design.getPublicparamgroup()!=null && design.getPublicparamgroup().getMechanicpublicparam()!=null && design.getPublicparamgroup().getMechanicpublicparam().size()>0&& design.getPublicparamgroup().getMechanicpublicparam().stream().filter(mpp->mpp.isChangeable()).count()>0 )
				||(design instanceof MechanicDressing || design.getType().equals(PieceType.DRESSING)) ){
			createGeneralTab();
		}
		if(this.design!=null && containsChildsPublicParams()) {
			createComponentsConfigTab();
		}
		if(this.design!=null && containsChildsPublicConcurrentParams()) {
			createComponentsConceptionConfigTab();
		}
		if(!design.getType().equals(PieceType.PIECE2D)) {		
			
			createModelTabComposite();
		}
		if(design.getMechanicelementgroup()!=null 
				&& design.getMechanicelementgroup().getMechanicdesignelment()!=null 
				&& design.getMechanicelementgroup().getMechanicdesignelment().size()>0
				&& !(design instanceof MechanicDressing) && !design.getType().equals(PieceType.DRESSING))
		{
			if(design.getMechanicelementgroup()!=null && design.getMechanicelementgroup().getMechanicdesignelment()!=null
					&&!design.getMechanicelementgroup().getMechanicdesignelment().isEmpty() )
			{
				createPieceModelTab();
			}
		}
		boolean isShowAccessoire = ReportingPreferences.getInstance().getProperty("report.accessoire", true);
		boolean isShowQuicaillerie = ReportingPreferences.getInstance().getProperty("report.quicaillerie", true);
		boolean isUser_dev = ReportingPreferences.getInstance().getProperty("user.dev", false);
		boolean useUsinage = ModulesPreferences.getInstance().getProperty("use.usinage", true);

		if(isShowAccessoire||isShowQuicaillerie ) {
			createArticlesTab(isShowAccessoire,isShowQuicaillerie);
		}
		if(isUser_dev&&useUsinage)
		{
			createAssemblageTab();
		}
		parent.requestLayout();
		if(tbtmGnral!=null)
		{
			tabFolder.setSelection(tbtmGnral);
			tbtmGnral.getControl().setFocus();
		}else {
			tabFolder.setSelection(0);
		}
		tabFolder.redraw();
		m_bindingContext = initDataBindings();
		
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}
	public void updateValues() {
		design.setName(design.getName().trim());
		for(MechanicPublicParam param:dirtyParams.keySet()) {
			dirtyParams.get(param).updateValues();
		}
		for(OptionGroup group:dirtyOptions.keySet()) {
			ComboViewer viewer=	dirtyOptions.get(group);
			Option option=(Option) viewer.getStructuredSelection().getFirstElement();
			group.setSelectedOption(option);
			for(MechanicPublicParam param : option.getInjectedPublicParam().getMechanicpublicparam()) {
				try {
					if(param.getTypedef()!=null && param.getTypedefelement()!=null)
					{
						design.getPublicparamgroup().setParamType(param.getKey(), param.getTypedefelement());
					}else {
						design.setPublicParamValue(param.getKey(), param.getDefaultvalue());
					}
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
		if(!design.getType().equals(PieceType.PIECE2D)) {		
			IStructuredSelection selection = tableComboVwr_Eltmat.getStructuredSelection();
			Object se = selection.getFirstElement();
			if(se!=null &&se instanceof Material ) {
				if (se != this.design.getPrincipalmaterial()) {
					this.design.setPrincipalmaterial((Material) se);
				}
			}
			this.design.setPrincipalMaterialFree(btnEltmatLibre_1.getSelection());
			//
			IStructuredSelection selection2 = tableComboVwr_facademat.getStructuredSelection();
			Object se2 = selection2.getFirstElement();
			if(se2!=null &&se2 instanceof Material ) {
				if (se2 != this.design.getFacadeMaterial()) {
					this.design.setFacadeMaterial((Material) se2);
				}
			}
			this.design.setFacadeMaterialFree(btnfacadematLibre_1.getSelection());

			IStructuredSelection selectionDos = tableComboVwr_Dosmat.getStructuredSelection();
			Object dos = selectionDos.getFirstElement();
			if(dos!=null &&dos instanceof Material ) {
				if (dos != this.design.getSecondmaterial()) {
					this.design.setSecondmaterial((Material) dos);
				}
			}
			this.design.setSecondMaterialFree(btnDosmatLibre_1.getSelection());
			//
			if(this.facadeMaterialType.isDirty()) {
				MaterialTypeInstance material=facadeMaterialType.getMaterial();
				MaterialTypeInstance facadeMaterialType =design.getFacadeMaterialType();
				facadeMaterialType.setIsColor(material.isIsColor());
				facadeMaterialType.setMaterial(material.getMaterial());
				facadeMaterialType.setTexture(this.facadeMaterialType.getSelectedTexture());
				if(this.facadeMaterialType.getColorComposite().isDirty())
				{
					facadeMaterialType.setColor(this.facadeMaterialType.getColorComposite().getEmfColor());
				}
			}
			if(this.elementMaterialType.isDirty()) {
				MaterialTypeInstance material=elementMaterialType.getMaterial();
				MaterialTypeInstance elementMaterialType =design.getPrincipalMaterialType();
				elementMaterialType.setIsColor(material.isIsColor());
				elementMaterialType.setMaterial(material.getMaterial());
				elementMaterialType.setTexture(this.elementMaterialType.getSelectedTexture());
				if(this.elementMaterialType.getColorComposite().isDirty())
				{
					elementMaterialType.setColor(this.elementMaterialType.getColorComposite().getEmfColor());
				}
			}
			if(this.dosMaterialType.isDirty()) {
				MaterialTypeInstance material=dosMaterialType.getMaterial();
				MaterialTypeInstance dosMaterialType =design.getSecondMaterialType();
				dosMaterialType.setIsColor(material.isIsColor());
				dosMaterialType.setMaterial(material.getMaterial());
				dosMaterialType.setTexture(this.dosMaterialType.getSelectedTexture());
				if(this.dosMaterialType.getColorComposite().isDirty())
				{
					dosMaterialType.setColor(this.dosMaterialType.getColorComposite().getEmfColor());
				}
			}
			//
			if(btnChantFacadeLibre.getSelection()!=design.isChantFacadeFree()) {
				design.setChantFacadeFree(btnChantFacadeLibre.getSelection());			
			}
			IStructuredSelection selectionchantFacade = tableComboVwr_ChantFacade.getStructuredSelection();
			Object chantFacade = selectionchantFacade.getFirstElement();
			if(chantFacade!=null &&chantFacade instanceof Chant ) {
				if (chantFacade != this.design.getChantFacade()) {
					this.design.setChantFacade((Chant) chantFacade);
				}
			}
			//
			if(btnChantElementLibre.getSelection()!=design.isChantElementFree()) {
				design.setChantElementFree(btnChantElementLibre.getSelection());			
			}
			IStructuredSelection selectionchantElement = tableComboVwr_ChantElement.getStructuredSelection();
			Object chantElement = selectionchantElement.getFirstElement();
			if(chantElement!=null &&chantElement instanceof Chant ) {
				if (chantElement != this.design.getChantElement()) {
					this.design.setChantElement((Chant) chantElement);
				}
			}			
			
			//
		}
		if(design.getMechanicelementgroup()!=null 
				&& design.getMechanicelementgroup().getMechanicdesignelment()!=null 
				&& design.getMechanicelementgroup().getMechanicdesignelment().size()>0
				&& !(design instanceof MechanicDressing) && !design.getType().equals(PieceType.DRESSING))
		{
			pieceModel_Composite.updateValues();
		}
	}
	
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextNameObserveWidget = WidgetProperties.text(SWT.Modify).observe(name);
		IObservableValue nameDesignObserveValue = BeanProperties.value("name").observe(design);
		bindingContext.bindValue(observeTextNameObserveWidget, nameDesignObserveValue, null, null);
		//
		if (design instanceof MechanicDressing) {
			MechanicDressing dressing = (MechanicDressing) design;
		
			//
			IObservableValue observeTextchantierObserveWidget = WidgetProperties.text(SWT.Modify).observe(txtChantier);
			IObservableValue chantierDesignObserveValue = BeanProperties.value("chantier").observe(design);
			bindingContext.bindValue(observeTextchantierObserveWidget, chantierDesignObserveValue, null, null);
			//
			//
			IObservableValue observeTextEtageObserveWidget = WidgetProperties.text(SWT.Modify).observe(txtEtage);
			IObservableValue etageDesignObserveValue = BeanProperties.value("etage").observe(design);
			bindingContext.bindValue(observeTextEtageObserveWidget, etageDesignObserveValue, null, null);
			//
			IObservableValue observeTextAppartementObserveWidget = WidgetProperties.text(SWT.Modify).observe(txtAppartement);
			IObservableValue appartementDesignObserveValue = BeanProperties.value("appartement").observe(design);
			bindingContext.bindValue(observeTextAppartementObserveWidget, appartementDesignObserveValue, null, null);
			//
		}
		return bindingContext;
	}
	
}
