package dressing.ui;

import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.config.persistence.ResourceManagers;
import dressing.ui.util.EditorWindow;
import param.DesignInstance;
import param.DirectionDelimiterMap;

public class MechaincDesignInstanceEditorWindow extends EditorWindow {
	private MechanicDesignInstanceEditorComposite paramGroup;
	private DesignInstance design;
	private int update;
	Composite parentComposite;
	DirectionDelimiterMap constraintdelimeters=null;
	IEventBroker eventBroker;

	
	public MechaincDesignInstanceEditorWindow(Shell parentShell, DesignInstance design) {
		super(parentShell,EditorWindow.update);
		this.design=design;
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		parentComposite=parent;
		paramGroup =new MechanicDesignInstanceEditorComposite(parent, SWT.NONE, this.design,this.update);
		paramGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1)); 
		parent.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		Button structure = new Button(paramGroup, SWT.NONE);
		structure.setLayoutData(new GridData(SWT.RIGHT, SWT.FILL, false, false, 2, 1));
		structure.setText("...");
		structure.addSelectionListener(new SelectionListener() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				DesignStructureEditorWindow mechanicDesignWindow=new DesignStructureEditorWindow(shell, design.getDesign());
				mechanicDesignWindow.create();
				mechanicDesignWindow.open();
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub

			}
		});
		
		if(design.getDesign().getPublicparamgroup()!=null && design.getDesign().getPublicparamgroup().getParametersFamilies()!=null) {
			Button configParam=new Button(paramGroup, SWT.NONE);
			configParam.setLayoutData(new GridData(SWT.RIGHT, SWT.FILL, false, false, 2, 1)); 
			configParam.setText("......");
			configParam.addSelectionListener(new SelectionListener() {
				
				@Override
				public void widgetSelected(SelectionEvent e) {
					// TODO Auto-generated method stub
					MechanicDesignParamFamilyConfigEditorWindow mechanicDesignWindow=new MechanicDesignParamFamilyConfigEditorWindow(shell, design.getDesign(),design.getDesign().getPublicparamgroup().getParametersFamilies(),EditorWindow.update);
					mechanicDesignWindow.create();
					mechanicDesignWindow.open();
				}
				
				@Override
				public void widgetDefaultSelected(SelectionEvent e) {
					// TODO Auto-generated method stub
					
				}
			});
		}
		Point preferedSize =paramGroup.computeSize(SWT.DEFAULT, SWT.DEFAULT);
		 int frameX = shell.getSize().x - shell.getClientArea().width;
         int frameY = shell.getSize().y - shell.getClientArea().height;
         shell.setSize(preferedSize.x + frameX, preferedSize.y + frameY+50);
         shell.setLocation((shell.getParent().getSize().x -shell.getSize().x)/2, (shell.getParent().getSize().y -shell.getSize().y)/2);
		this.shell.setText("Editeur");
		parent.requestLayout();
		return paramGroup;
	}

	@Override
	public boolean terminer() {
		if(!super.terminer()) {
			return false;
		}
		paramGroup.updateValues();
		ResourceManagers.getIntance().saveResource(design.eResource());
		eventBroker.send("update_DataModel", ResourceManagers.getIntance().getApplication());
		finish();
		return true;
	}
	@Override
	public boolean check() {
		errorExist=false;
		errorMessage="";
		return !errorExist;
	}
	public int getUpdate() {
		return update;
	}

	public void setUpdate(int update) {
		this.update = update;
	}

	public IEventBroker getEventBroker() {
		return eventBroker;
	}

	public void setEventBroker(IEventBroker eventBroker) {
		this.eventBroker = eventBroker;
	}

	public Composite getParamGroup() {
		return paramGroup;
	}

	public DesignInstance getDesign() {
		return design;
	}

	@Override
	protected void cancel() {
	
		
	}
}
