package dressing.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;
import org.jogamp.vecmath.Point3d;

import com.badlogic.gdx.Gdx;

import dressing.config.persistence.ResourceManagers;
import dressing.events.EventDriver;
import dressing.mathutils.Vector4;
import dressing.model.DesignObject3D;
import dressing.model.Kitchen;
import dressing.model.MechanicDesignCreator;
import dressing.model.ProjectManager;
import dressing.model.Space3D;
import dressing.model.Space3DFree;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.SupercadProgressMonitorDialog;
import gdxapp.object3d.KitchenElement;
import gdxapp.scenes.Scene;
import gdxapp.scenes.SceneEvent;
import gdxapp.screens.room.RoomScreen;
import param.DirectionDelimiterMap;
import param.MechanicDesign;
import param.MechanicPublicParam;
import param.PieceType;

public class MechaincDesignEditorWindow extends EditorWindow {
	public static final boolean ISMODEL=true;
	public static final boolean DIRECT_PARENT=true;
	private MechanicDesignEditorComposite paramGroup;
	private MechanicDesign design;
	private DesignObject3D parent;
	private boolean isdirectParent;
	private int update;
	private DesignObject3D rootspace;
	Composite parentComposite;
	DirectionDelimiterMap constraintdelimeters=null;
	private Point3d point;
	private boolean isModel;
	IEventBroker eventBroker;

	
	public MechaincDesignEditorWindow(Shell parentShell, MechanicDesign design,boolean isModel,Point3d point, DesignObject3D parentSpace,DesignObject3D rootspace,DirectionDelimiterMap  spacedelimeters, boolean isdirectParent,int update) {
		super(parentShell,update);
		this.design=design;
		this.parent=parentSpace;
		this.isdirectParent=isdirectParent;
		this.constraintdelimeters=spacedelimeters;
		this.update=update;
		this.rootspace=rootspace;
		this.point=point;
		this.isModel=isModel;
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		parentComposite=parent;
		paramGroup =new MechanicDesignEditorComposite(parent, SWT.NONE, this.design,rootspace,this.update,isModel());
		paramGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1)); 
		parent.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		if(this.isModel) {
			Button structure=new Button(paramGroup, SWT.NONE);
			structure.setLayoutData(new GridData(SWT.RIGHT, SWT.FILL, false, false, 2, 1)); 
			structure.setText("...");
			structure.addSelectionListener(new SelectionListener() {
				
				@Override
				public void widgetSelected(SelectionEvent e) {
					// TODO Auto-generated method stub
					DesignStructureEditorWindow mechanicDesignWindow=new DesignStructureEditorWindow(shell, design);
					mechanicDesignWindow.create();
					mechanicDesignWindow.open();
				}
				
				@Override
				public void widgetDefaultSelected(SelectionEvent e) {
					// TODO Auto-generated method stub
					
				}
			});
			if(design.getPublicparamgroup()!=null && design.getPublicparamgroup().getParametersFamilies()!=null) {
				Button configParam=new Button(paramGroup, SWT.NONE);
				configParam.setLayoutData(new GridData(SWT.RIGHT, SWT.FILL, false, false, 2, 1)); 
				configParam.setText("......");
				configParam.addSelectionListener(new SelectionListener() {
					
					@Override
					public void widgetSelected(SelectionEvent e) {
						// TODO Auto-generated method stub
						MechanicDesignParamFamilyConfigEditorWindow mechanicDesignWindow=new MechanicDesignParamFamilyConfigEditorWindow(shell, design,design.getPublicparamgroup().getParametersFamilies(),EditorWindow.update);
						mechanicDesignWindow.create();
						mechanicDesignWindow.open();
					}
					
					@Override
					public void widgetDefaultSelected(SelectionEvent e) {
						// TODO Auto-generated method stub
						
					}
				});
			}
			
			
		}
		
		Point preferedSize =paramGroup.computeSize(SWT.DEFAULT, SWT.DEFAULT);
		 int frameX = shell.getSize().x - shell.getClientArea().width;
         int frameY = shell.getSize().y - shell.getClientArea().height;
         shell.setSize(preferedSize.x + frameX, preferedSize.y + frameY+50);
         shell.setLocation((shell.getParent().getSize().x -shell.getSize().x)/2, (shell.getParent().getSize().y -shell.getSize().y)/2);
		this.shell.setText("Editeur");
		parent.requestLayout();
		return paramGroup;
	}

	@Override
	public boolean terminer() {
		if(!super.terminer()) {
			return false;
		}
		paramGroup.updateValues();
		if(!isModel) {
			if(!paramGroup.getDirtyParams().isEmpty()) {
				for(MechanicPublicParam param:paramGroup.getDirtyParams().keySet()) {
					param.setImport(false);
				}
			}
			SupercadProgressMonitorDialog progressmonitor =new SupercadProgressMonitorDialog(getShell());
			IRunnableWithProgress operation = new IRunnableWithProgress() {

				@Override
				public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
					Date deb = new Date();

					try {
						//create
						if (update != MechanicDesignCreator.update || rootspace == null) {
							monitor.beginTask("Appliquer les modifications a l'objet", IProgressMonitor.UNKNOWN);
							ProjectManager.getInstance().getRoot().setNotificationon(false);
							if(constraintdelimeters==null && point!=null && parent!=null && !design.getType().equals(PieceType.OBSTACLE)) {
								constraintdelimeters=((Space3D) parent.getRootModule()).getDependenceController().getparentSpace(point,design, parent);
		    					DesignObject3D spaceParent = ((Space3D) parent.getRootModule()).getDependenceController().createConstraintSpace(constraintdelimeters, parent,false);
		    					//make temporary space directPArent for test  purposes
		    					if(spaceParent!=null) {
		    						isdirectParent=false;
		    						parent=spaceParent;
		    					}
							}
							
							if(parent!=null && parent instanceof Space3D && constraintdelimeters!=null&& parent.getRootModule()!=null && ((Space3D) parent.getRootModule()).getDependenceController()!=null) {
								monitor.beginTask("mise a jour d'etat dans les systeme ", IProgressMonitor.UNKNOWN);
								((Space3D) parent.getRootModule()).getDependenceController().addORUpdateTargetDependent(design, constraintdelimeters);
								monitor.done();
							}
							
							DesignObject3D result = MechanicDesignCreator.getInstance().constructObject(design, parent,isdirectParent, false);
							if(parent!=null && design.getType().equals(param.PieceType.OBSTACLE)){
								((Space3DFree) parent.getRootModule()).update(true);
							}
							monitor.done();
							
							monitor.beginTask("propagation de la modication", IProgressMonitor.UNKNOWN);
							ProjectManager.getInstance().getRoot().setNotificationon(true);
							if(result!=null && result instanceof Space3D && design.getType().equals(param.PieceType.DRESSING) ) {
								ProjectManager.getInstance().getRoot().firePropertyChange("project.dressing.added", 1, result);

							}else
							{
								ProjectManager.getInstance().getRoot().firePropertyChange("project.child.added", 1, result);
							}
							monitor.done();
						} else {
							//update
							monitor.beginTask("Appliquer les modifications a l'objet", IProgressMonitor.UNKNOWN);
							rootspace.update(true);
							monitor.done();
						}
						Gdx.app.postRunnable(new Runnable() {
							@Override
							public void run() {
								updateKitchenElement();
							}

						});
						

					} catch (Exception e) {
						e.printStackTrace();
						if(parent!=null && parent instanceof Space3D && parent.getRootModule()!=null && ((Space3D) parent.getRootModule()).getDependenceController()!=null) {
							((Space3D) parent.getRootModule()).getDependenceController().deleteDependent(design);
						}
						Display.getDefault().asyncExec(new Runnable() {
							@Override
							public void run() {
								MessageDialog.openError(paramGroup.getShell(), "une erreur dans la création d'object",
								e.getMessage());
							}
						});
					}
					System.gc();

					System.err.println("********time to update****" + (new Date().getTime() - deb.getTime()));
				}
			};
			try {
				// This runs the options, and shows progress.
				//
				progressmonitor.run(true, false, operation);

			} catch (Exception exception) {
				// Something went wrong that shouldn't.
				//
				exception.printStackTrace();
			}
		}else {
			if(eventBroker!=null) {
				eventBroker.send("update_DataModel", ResourceManagers.getIntance().getApplication());
			}
		}
		
		finish();
		return true;
	}
	@Override
	public boolean check() {
		errorExist=false;
		errorMessage="";
		return !errorExist;
	}
	public int getUpdate() {
		return update;
	}

	public void setUpdate(int update) {
		this.update = update;
	}

	public DesignObject3D getRootspace() {
		return rootspace;
	}

	public void setRootspace(DesignObject3D rootspace) {
		this.rootspace = rootspace;
	}

	public boolean isModel() {
		return isModel;
	}

	public void setModel(boolean isModel) {
		this.isModel = isModel;
	}

	public IEventBroker getEventBroker() {
		return eventBroker;
	}

	public void setEventBroker(IEventBroker eventBroker) {
		this.eventBroker = eventBroker;
	}

	public Composite getParamGroup() {
		return paramGroup;
	}

	public void setParamGroup(MechanicDesignEditorComposite paramGroup) {
		this.paramGroup = paramGroup;
	}

	public MechanicDesign getDesign() {
		return design;
	}

	public void setDesign(MechanicDesign design) {
		this.design = design;
	}

	public DesignObject3D getParent() {
		return parent;
	}

	public void setParent(DesignObject3D parent) {
		this.parent = parent;
	}

	public boolean isIsdirectParent() {
		return isdirectParent;
	}

	public void setIsdirectParent(boolean isdirectParent) {
		this.isdirectParent = isdirectParent;
	}

	public void setMechanicDesign(MechanicDesign design) {
		this.design=design;
		if(paramGroup!=null) {
			paramGroup.dispose();
		}
		this.paramGroup=new MechanicDesignEditorComposite(parentComposite, SWT.NONE, this.design, rootspace, update,isModel);
		paramGroup.pack();
		paramGroup.getParent().requestLayout();

	}
	private void updateKitchenElement() {
		DesignObject3D element=rootspace!=null? rootspace.getRoot():(parent!=null ?parent.getRoot():null);
		if(element!=null) {
			KitchenElement kitchenElement =	ProjectManager.getInstance().getCurrentKitchen().getScene().getKitchenElement(element );
			kitchenElement.getObjectDimention();
//			float y = spny.getSelection() * 0.001f;
//			float altitude = y + dim.y / 2.0f;
//			kitchenElement.getRealWorldPosition().y = altitude;
			kitchenElement.setRequireRefrech(true);
			EventDriver.getDriver().deliverEvent(SceneEvent.OBJECT_CHANGED, kitchenElement);
		}
	}
	@Override
	protected void cancel() {
	
		
	}
}
