package dressing.ui;

import java.io.File;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;

import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;

import dressing.config.ReportingPreferences;
import dressing.config.WorkspaceConfiguration;
import dressing.config.persistence.ResourceManagers;
import dressing.profiling.TimeProfiler;
import dressing.ui.util.DoubleViewerComparator;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.ImageLoaderCache;
import dressing.ui.util.ListEditorWindow;
import dressing.ui.util.StringViewerComparator;
import param.Finition;
import param.Fournisseur_fabricant;
import param.MDFThickness;
import param.Material;
import param.Nature_panneaux;
import param.ParamFactory;

public class MaterialListWindow extends ListEditorWindow {

	IEventBroker eventBroker;
	private ElementComboSelect frsElementComboSelect;
	
	private ElementComboSelect finitionElementComboSelect;
	
	private NaturePanneauxComboSelect naturePanneauxComboSelect;
	private Timer refreshTimer;
	String filterText="";
	private Text text;
	private EppaisseurPanneauxComboSelect eppaisseurPanneauxComboSelect;
	public MaterialListWindow(Shell parentShell, IEventBroker eventBroker) {
		super(parentShell);
		this.eventBroker=eventBroker;
	}

	@Override
	protected Composite createClientArea(Composite parent,int style) {
		Composite clientArea = super.createClientArea(parent, style|SWT.MULTI);
		getShell().setText("Liste des matériaux");
		return clientArea;
	}
	
	public void createColums(TableViewer tableViewer) {
		ColumnLabelProvider nameLabelProvider=new ColumnLabelProvider() {
			public Image getImage(Object element) {
				Material art=(Material) element;
				String imagePath1 =art.getImage();
				if(art.getImage()!=null  && !art.getImage().isEmpty()) {
					if(ImageLoaderCache.isValidImagePath(imagePath1)|| ImageLoaderCache.isValidImageUrl(imagePath1)) {
						return	ImageLoaderCache.getInstance().loadImage(art.getImage(), 150, 150);
					}else {
						String imagePath = WorkspaceConfiguration.TEXTURES_FOLDER + File.separator + imagePath1;
						if(ImageLoaderCache.isValidImagePath(imagePath)|| ImageLoaderCache.isValidImageUrl(imagePath))
						{
							return	ImageLoaderCache.getInstance().loadImage(imagePath, 150, 150);
						}
						return null;
					}
				}
				return null;
			}
			@Override
			public Color getBackground(Object element) {
				Material art=(Material) element;
				if(art.getGroup().equals(ResourceManagers.getIntance().getSystemMaterialGroup())) {
					return new Color(Display.getCurrent(),161, 227, 249);
				}
				return super.getBackground(element);
			}
			public String getText(Object element) {
				if(element !=null && element instanceof Material ) {
					return ((Material)element).getName();
				}
				return "";
			}
		};
		createColumn(tableViewer, "Nom", true, null, SWT.LEFT, nameLabelProvider, new StringViewerComparator(nameLabelProvider));
		ColumnLabelProvider eppaisseurColumnLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Material ) {
					return String.valueOf(((Material)element).getEpaisseur());
				}
				return "";
			}
			@Override
			public Color getBackground(Object element) {
				Material art=(Material) element;
				if(art.getGroup().equals(ResourceManagers.getIntance().getSystemMaterialGroup())) {
					return new Color(Display.getCurrent(),161, 227, 249);
				}
				return super.getBackground(element);
			}
		};
		createColumn(tableViewer, "Epaisseur", true, null, SWT.CENTER, eppaisseurColumnLabelProvider, new DoubleViewerComparator(eppaisseurColumnLabelProvider));
		
		ColumnLabelProvider priceColumnLabelProvider = new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Material ) {
					return String.valueOf(((Material)element).getPrice());
				}
				return "";
			}
			@Override
			public Color getBackground(Object element) {
				Material art=(Material) element;
				if(art.getGroup().equals(ResourceManagers.getIntance().getSystemMaterialGroup())) {
					return new Color(Display.getCurrent(),161, 227, 249);
				}
				return super.getBackground(element);
			}
		};
		createColumn(tableViewer, "Prix (DT/m² )", true, null, SWT.CENTER, priceColumnLabelProvider, new DoubleViewerComparator(priceColumnLabelProvider));
		//
		ColumnLabelProvider senseFilColumnLabelProvider = new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Material ) {
					return ((Material)element).isSensFil()?"Oui":"Non";
				}
				return "";
			}
			@Override
			public Color getBackground(Object element) {
				Material art=(Material) element;
				if(art.getGroup().equals(ResourceManagers.getIntance().getSystemMaterialGroup())) {
					return new Color(Display.getCurrent(),161, 227, 249);
				}
				return super.getBackground(element);
			}
		};
		createColumn(tableViewer, "Sens du fil", true, null, SWT.LEFT, senseFilColumnLabelProvider, new StringViewerComparator(senseFilColumnLabelProvider));
		
		ColumnLabelProvider babricantColumnLabelProvider =new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Material ) {
					return ((Material)element).getFabricant()!=null?((Material)element).getFabricant().getName():"";
				}
				return "";
			}
			@Override
			public Color getBackground(Object element) {
				Material art=(Material) element;
				if(art.getGroup().equals(ResourceManagers.getIntance().getSystemMaterialGroup())) {
					return new Color(Display.getCurrent(),161, 227, 249);
				}
				return super.getBackground(element);
			}
		};
		createColumn(tableViewer, "Fabricant/Fournisseur", true, null, SWT.LEFT, babricantColumnLabelProvider, new StringViewerComparator(babricantColumnLabelProvider));
		
		ColumnLabelProvider finitionColumnLabelProvider =new ColumnLabelProvider() {
			public Image getImage(Object element) {
				// TODO Auto-generated method stub
				return null;
			}
			public String getText(Object element) {
				if(element !=null && element instanceof Material ) {
					return ((Material)element).getFinition()!=null?((Material)element).getFinition().getName():"";
				}
				return "";
			}
			@Override
			public Color getBackground(Object element) {
				Material art=(Material) element;
				if(art.getGroup().equals(ResourceManagers.getIntance().getSystemMaterialGroup())) {
					return new Color(Display.getCurrent(),161, 227, 249);
				}
				return super.getBackground(element);
			}
		};
		createColumn(tableViewer, "Finition", true, null, SWT.LEFT, finitionColumnLabelProvider, new StringViewerComparator(finitionColumnLabelProvider));
		
		ColumnLabelProvider natureLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Material ) {
					return ((Material)element).getNature_type()!=null?((Material)element).getNature_type().getName():"";
				}
				return "";
			}
			@Override
			public Color getBackground(Object element) {
				Material art=(Material) element;
				if(art.getGroup().equals(ResourceManagers.getIntance().getSystemMaterialGroup())) {
					return new Color(Display.getCurrent(),161, 227, 249);
				}
				return super.getBackground(element);
			}
		};
		createColumn(tableViewer, "Nature/Type Panneaux", true, null, SWT.LEFT, natureLabelProvider,  new StringViewerComparator(natureLabelProvider));
	}

	@Override
	protected Composite createSearchArea(Composite parent,int style) {
		searchArea = new Composite(parent, SWT.BORDER);
		searchArea.setLayout(new FillLayout(SWT.HORIZONTAL));
		GridData gd_composite_1 = new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1);
		
//		gd_composite_1.widthHint = 266;
		gd_composite_1.heightHint = 60;
//		gd_composite_1.minimumHeight=200;
//		gd_composite_1.verticalIndent=50;
		searchArea.setLayoutData(gd_composite_1);
		
		Group grpsearch = new Group(searchArea, SWT.NONE);
		grpsearch.setText("Rechercher");
		GridLayout searchlayaout=new GridLayout(1, false);
		searchlayaout.verticalSpacing=0;
		searchlayaout.marginHeight=2;
		searchlayaout.marginWidth=2;
		grpsearch.setLayout(searchlayaout);
		
		
		
		text = new Text(grpsearch, SWT.BORDER);
		GridData txtdata=new GridData(SWT.FILL, SWT.TOP, true,false);
		txtdata.heightHint=21;
		
		text.setLayoutData(txtdata);

		text.addKeyListener(new KeyListener() {
			
			@Override
			public void keyReleased(KeyEvent e) {
				filterText=text.getText();
				scheduleViewerRefresh();
			}
			
			@Override
			public void keyPressed(KeyEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		
		Group grpFabricant = new Group(searchArea, SWT.NONE);
		grpFabricant.setText("Fabricant/Fournisseur");
		grpFabricant.setLayout(new FillLayout(SWT.HORIZONTAL));
		
		frsElementComboSelect = new FournisseurComboSelect(grpFabricant, SWT.NONE);

		ComboViewer comboViewer = frsElementComboSelect.getComboViewer();
			
		comboViewer.addSelectionChangedListener(new  ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				scheduleViewerRefresh();
			}
			
		});
		Group grpFinition = new Group(searchArea, SWT.NONE);
		grpFinition.setText("Finition");
		grpFinition.setLayout(new FillLayout(SWT.HORIZONTAL));
		
		finitionElementComboSelect = new FinitionsComboSelect(grpFinition, SWT.NONE);

		comboViewer = finitionElementComboSelect.getComboViewer();
			
		comboViewer.addSelectionChangedListener(new  ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				scheduleViewerRefresh();
			}
			
		});
		Group grpNature = new Group(searchArea, SWT.NONE);
		grpNature.setText("Nature/Type Panneaux");
		grpNature.setLayout(new FillLayout(SWT.HORIZONTAL));
		
		naturePanneauxComboSelect = new NaturePanneauxComboSelect(grpNature, SWT.NONE);

		comboViewer = naturePanneauxComboSelect.getComboViewer();

		comboViewer.addSelectionChangedListener(new ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				scheduleViewerRefresh();
			}

		});
		//
		Group grpEppaisseur = new Group(searchArea, SWT.NONE);
		grpEppaisseur.setText("Éppaisseur Panneaux");
		grpEppaisseur.setLayout(new FillLayout(SWT.HORIZONTAL));
		
		eppaisseurPanneauxComboSelect = new EppaisseurPanneauxComboSelect(grpEppaisseur, SWT.NONE);

		comboViewer = eppaisseurPanneauxComboSelect.getComboViewer();

		comboViewer.addSelectionChangedListener(new ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				scheduleViewerRefresh();
			}

		});
		return searchArea;
	}
	public ViewerFilter createListFilter() {
//		return new ViewerFilter() {
//			@Override
//			public boolean select(Viewer arg0, Object parantElement, Object element) {
//				Material mat=(Material) element;
//				boolean iscontainTxtFilter = filterText.equals("")
//						||(mat.getName()!=null&& mat.getName().toUpperCase().contains(filterText.trim().toUpperCase()));
//				
//				Object frsobject=frsElementComboSelect.getComboViewer().getStructuredSelection().getFirstElement();
//				boolean isfrs=false;
//				if(frsobject==null || !(frsobject instanceof Fournisseur_fabricant)|| frsobject.equals(((Material) element).getFabricant())) {
//					isfrs=true;
//				}
//				
//				Object finitionobject=finitionElementComboSelect.getComboViewer().getStructuredSelection().getFirstElement();
//				boolean isfinition=false;
//				if(finitionobject==null|| !(finitionobject instanceof Finition)|| finitionobject.equals(((Material) element).getFinition())) {
//					isfinition=true;
//				}
//				
//				Object nature=naturePanneauxComboSelect.getComboViewer().getStructuredSelection().getFirstElement();
//				boolean isnature=false;
//				if(nature==null|| !(nature instanceof Nature_panneaux)|| nature.equals(((Material) element).getNature_type())) {
//					isnature=true;
//				}
//				Object ep=eppaisseurPanneauxComboSelect.getComboViewer().getStructuredSelection().getFirstElement();
//				boolean isep=false;
//				if(ep==null ||!(ep instanceof MDFThickness)|| ((MDFThickness)ep).getThickness()==((Material) element).getEpaisseur() ) {
//					isep=true;
//				}
//				
//				if (iscontainTxtFilter && isfrs && isfinition && isnature && isep) {
//					return true;
//				}
//
//				return false;
//			}
//		};
		return null;
	}
	
	private boolean matchesFilter(Material mat) {
	    boolean isContainTxtFilter = filterText.isEmpty()
	        || (mat.getName() != null && mat.getName().toUpperCase().contains(filterText.trim().toUpperCase()));

	    Object frsobject = frsElementComboSelect.getComboViewer().getStructuredSelection().getFirstElement();
	    boolean isFrs = frsobject == null
	        || !(frsobject instanceof Fournisseur_fabricant)
	        || frsobject.equals(mat.getFabricant());

	    Object finitionObject = finitionElementComboSelect.getComboViewer().getStructuredSelection().getFirstElement();
	    boolean isFinition = finitionObject == null
	        || !(finitionObject instanceof Finition)
	        || finitionObject.equals(mat.getFinition());

	    Object nature = naturePanneauxComboSelect.getComboViewer().getStructuredSelection().getFirstElement();
	    boolean isNature = nature == null
	        || !(nature instanceof Nature_panneaux)
	        || nature.equals(mat.getNature_type());

	    Object ep = eppaisseurPanneauxComboSelect.getComboViewer().getStructuredSelection().getFirstElement();
	    boolean isEp = ep == null
	        || !(ep instanceof MDFThickness)
	        || ((MDFThickness) ep).getThickness() == mat.getEpaisseur();

	    return isContainTxtFilter && isFrs && isFinition && isNature && isEp;
	}
	
	@Override
	protected Composite createButtonArea(Composite parent) {
		Composite buttonArea=super.createButtonArea(parent);
		
		Button btnNewButton = new Button(buttonArea, SWT.NONE);
		GridData gd_btnRun = new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1);
		gd_btnRun.heightHint = 100;
		btnNewButton.setLayoutData(gd_btnRun);
		btnNewButton.setImage(ResourceManager.getPluginImage("Dressing", "icons/ajout.png"));
		btnNewButton.setText("Ajouter Multiple");
		btnNewButton.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				Material material=null;
				IStructuredSelection selection=tableViewer.getStructuredSelection();
				if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof Material) {
					material = (Material) selection.getFirstElement();
					material=EcoreUtil.copy(material);
				}else {
					material=ParamFactory.eINSTANCE.createMaterial();
					material.setName("");
					material.setEpaisseur(0);
				}
				MaterialMultipleAddWindow materialEditorWindow = new MaterialMultipleAddWindow(shell,eventBroker,material,EditorWindow.create);
				materialEditorWindow.create();
				int ret=materialEditorWindow.open();
				if(ret==Window.OK) {
					refresh();
				}
			}
			
		});
		return buttonArea;
	}
	@Override
	protected void Add() {
		
		Material material=null;
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof Material) {
			material = (Material) selection.getFirstElement();
			material=EcoreUtil.copy(material);
		}else {
			material=ParamFactory.eINSTANCE.createMaterial();
			material.setName("");
			material.setEpaisseur(0);
		}
		
		MaterialEditorWindow materialEditorWindow = new MaterialEditorWindow(shell,eventBroker,material,EditorWindow.create);
		materialEditorWindow.create();
		int ret=materialEditorWindow.open();
		if(ret==Window.OK) {
			refresh();
		}
	}

	@Override
	protected void Modify() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof Material) {
			MaterialEditorWindow mechanicDesignWindow = new MaterialEditorWindow(shell,eventBroker,(Material) selection.getFirstElement(),EditorWindow.update);
			mechanicDesignWindow.create();
			int ret=mechanicDesignWindow.open();
			if(ret==Window.OK) {
				refresh();
			}
		}
	}

	@Override
	protected void delete() {
		boolean ret = MessageDialog.openConfirm(shell, "Confirmation de supression","Voulez vous supprimer les composant sélectionner" );
		if(ret) {
			IStructuredSelection selection=tableViewer.getStructuredSelection();
			if(selection!=null&& !selection.isEmpty()) {
				List selections=selection.toList();
				for(Object obj:selections) {
					if(obj!=null && obj instanceof Material) {
						Material mat=(Material) obj;
						mat.getGroup().getMaterial().remove(mat);
					}
				}
				ResourceManagers.getIntance().saveLibraryResource();
				refresh();
			}
		}
		

	}

	@Override
	protected void view() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof Material) {
			MaterialEditorWindow mechanicDesignWindow = new MaterialEditorWindow(shell,eventBroker,(Material) selection.getFirstElement(),EditorWindow.View);
			mechanicDesignWindow.create();
			mechanicDesignWindow.open();
			refresh();
		}

	}
	public void refresh() {
		List<Material> allMaterials = (List<Material>) getInput(); // or your data source
		TimeProfiler.getInstance().start("table material filteing");
		List<Material> filteredList = allMaterials.stream()
		    .filter(this::matchesFilter)
		    .collect(Collectors.toList());
		TimeProfiler.getInstance().stop("table material filteing");
		Table table = tableViewer.getTable();
		table.setRedraw(false);
		try {
		    tableViewer.setInput(filteredList);
		    tableViewer.setItemCount(filteredList.size());
		} finally {
		    table.setRedraw(true);
		}
	}
	
	private void scheduleViewerRefresh() {
	    if (refreshTimer != null) refreshTimer.cancel();
	    refreshTimer = new Timer();
	    refreshTimer.schedule(new TimerTask() {
	        @Override
	        public void run() {
	            Display.getDefault().asyncExec(() -> {
	                if (!tableViewer.getTable().isDisposed()) {
	                	refresh();
	                }
	            });
	        }
	    }, 300); // delay 300 ms after last change
	}
	
	@Override
	public List<?> getInput() {
		return ResourceManagers.getIntance().getMaterials();
	}
	@Override
	protected void updateButtons() {
		super.updateButtons();
		boolean isdev = ReportingPreferences.getInstance().getProperty("user.dev", false);
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		for(Object sel:selection.toList()) {
			Material art=(Material) sel;
			if(!isdev &&art.getGroup().equals(ResourceManagers.getIntance().getSystemMaterialGroup())) {
				btnDelete.setEnabled(false);
				break;
			}
		}
	}
}