package dressing.ui;

import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.config.persistence.ResourceManagers;
import dressing.model.ModelProvider;
import dressing.ui.util.EditorWindow;
import param.Chant;
import param.MechanicDesign;
import param.ParamFactory;

public class DesignStructureEditorWindow extends EditorWindow {

	private MechanicDesign design;
	private Composite parentComposite;
	private Composite clientArea;
	private Label txtName;
	private Text txtCreateAction;
	private Text txtModifyAction;

	IEventBroker eventBroker;

	public DesignStructureEditorWindow(Shell parentShell,MechanicDesign design) {
		super(parentShell,EditorWindow.update);
		
		this.design=design;
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		parentComposite=parent;
		clientArea = new Composite(parent, SWT.BORDER);
		clientArea.setLayout(new GridLayout(2, false));
		clientArea.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		clientArea.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_BACKGROUND));

		Label lblName = new Label(clientArea, SWT.NONE);
		lblName.setText("Nom : ");
		lblName.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
		lblName.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_BACKGROUND));

		txtName = new Label(clientArea, SWT.BOLD);
		txtName.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
		txtName.setText(this.design.getName());
		txtName.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_BACKGROUND));

		SashForm sashForm = new SashForm(clientArea, SWT.NONE);
		sashForm.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_BACKGROUND));
		GridData gd_sashForm = new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1);
		sashForm.setLayoutData(gd_sashForm);

		Composite composite_3 = new Composite(sashForm, SWT.NONE);
		composite_3.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		GridLayout gl_composite_3 = new GridLayout(1,true);
//		gl_composite_3.marginWidth = 0;
//		gl_composite_3.marginHeight = 0;
		composite_3.setLayout(gl_composite_3);
		
		Label lblcreateAction = new Label(composite_3, SWT.NONE);
		lblcreateAction.setText("CreateAction");
		lblcreateAction.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
		lblcreateAction.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));

		txtCreateAction = new Text(composite_3, SWT.BORDER | SWT.WRAP | SWT.H_SCROLL | SWT.V_SCROLL | SWT.CANCEL | SWT.MULTI);
		txtCreateAction.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 3, 3));
		txtCreateAction.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));

		if(design!=null && design.getStructureAction()!=null ) {
			txtName.setText(design.getName());
			if(design.getStructureAction().getCreateAction()!=null)
			{
				txtCreateAction.setText(design.getStructureAction().getCreateAction());
			}
		}

		Composite composite_4 = new Composite(sashForm, SWT.NONE);
		composite_4.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		GridLayout gl_composite_4 = new GridLayout(1,true);
//		gl_composite_4.marginWidth = 0;
//		gl_composite_4.marginHeight = 0;
		composite_4.setLayout(gl_composite_4);
		
		Label lblmodifyAction = new Label(composite_4, SWT.NONE);
		lblmodifyAction.setText("Action de modification");
		lblmodifyAction.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
		lblmodifyAction.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));

		txtModifyAction = new Text(composite_4, SWT.BORDER | SWT.WRAP | SWT.H_SCROLL | SWT.V_SCROLL | SWT.CANCEL | SWT.MULTI);
		txtModifyAction.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 3, 3));
		txtModifyAction.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));

		if(design!=null && design.getStructureAction()!=null ) {
			txtName.setText(design.getName());
			if(design.getStructureAction().getUpdateStructureAction()!=null)
			{
				txtModifyAction.setText(design.getStructureAction().getUpdateStructureAction());
			}
		}
		else if(design.getStructureAction()==null) {
			design.setStructureAction(ParamFactory.eINSTANCE.createStructureAction());
		}
		this.shell.setText("Editeur");
//		txtCreateAction.setSize(txtCreateAction.computeSize(SWT.DEFAULT, SWT.DEFAULT).x, 400);
//		txtModifyAction.setSize(txtModifyAction.computeSize(SWT.DEFAULT, SWT.DEFAULT).x, 400);
		sashForm.setWeights(new int[] { 200, 200 });
		clientArea.setTabList(new Control[]{sashForm});
		parent.requestLayout();
		return clientArea;
	}

	@Override
	public boolean terminer() {
		if(!super.terminer()) {
			return false;
		}
		design.getStructureAction().setCreateAction(txtCreateAction.getText());
		design.getStructureAction().setUpdateStructureAction(txtModifyAction.getText());

		ResourceManagers.getIntance().saveLibraryResource();
		finish();
		return true;
	}
	@Override
	public boolean check() {
		errorExist=false;
		errorMessage="";
		
		return !errorExist;
	}
	
	@Override
	protected void cancel() {
		// TODO Auto-generated method stub
		
	}
	
}
